/************************************************************/
/*															*/
/*	File :	1dDataDlg.cpp									*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2007 FUJIFILM Corporation			*/
/*															*/
/************************************************************/


#include "stdafx.h"
#include "sdksample.h"
#include "1dDataDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// C1dDataDlg

C1dDataDlg::C1dDataDlg(CWnd* pParent /*=NULL*/)
	: CDialog(C1dDataDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(C1dDataDlg)
	//}}AFX_DATA_INIT
	m_fCreate = FALSE;
}


void C1dDataDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(C1dDataDlg)
//#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	DDX_Control(pDX, IDC_SLIDER_RR, m_slider_RR);
	DDX_Control(pDX, IDC_SLIDER_GG, m_slider_GG);
	DDX_Control(pDX, IDC_SLIDER_BB, m_slider_BB);
	DDX_Control(pDX, IDC_EDIT_RR, m_edit_RR);
	DDX_Control(pDX, IDC_EDIT_GG, m_edit_GG);
	DDX_Control(pDX, IDC_EDIT_BB, m_edit_BB);
//#endif
	DDX_Control(pDX, IDC_SLIDER_D, m_slider_D);
	DDX_Control(pDX, IDC_SLIDER_Y, m_slider_Y);
	DDX_Control(pDX, IDC_SLIDER_M, m_slider_M);
	DDX_Control(pDX, IDC_SLIDER_C, m_slider_C);
	DDX_Control(pDX, IDC_EDIT_D, m_edit_D);
	DDX_Control(pDX, IDC_EDIT_Y, m_edit_Y);
	DDX_Control(pDX, IDC_EDIT_M, m_edit_M);
	DDX_Control(pDX, IDC_EDIT_C, m_edit_C);
	DDX_Control(pDX, IDC_COMBO_METHOD, m_combo_Method);	//Ver.2.4.0
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(C1dDataDlg, CDialog)
	//{{AFX_MSG_MAP(C1dDataDlg)
	ON_WM_HSCROLL()
	ON_CBN_SELCHANGE(IDC_COMBO_METHOD, OnSelchangeComboMethod)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C1dDataDlg Handler

BOOL C1dDataDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_fCreate = TRUE;
	SetGUI(TRUE);
	
	return TRUE;
}

////////////////////////////////////////////////
// GUI Operator

void C1dDataDlg::SetGUI(BOOL fInit)
{
	if(fInit){
#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
		m_slider_RR.SetRange(PARAM_MIN_LIN_GAMMA, PARAM_MAX_LIN_GAMMA, TRUE);
		m_slider_RR.SetTicFreq(PARAM_TIC_FREQ_LIN_GAMMA);
		m_slider_GG.SetRange(PARAM_MIN_LIN_GAMMA, PARAM_MAX_LIN_GAMMA, TRUE);
		m_slider_GG.SetTicFreq(PARAM_TIC_FREQ_LIN_GAMMA);
		m_slider_BB.SetRange(PARAM_MIN_LIN_GAMMA, PARAM_MAX_LIN_GAMMA, TRUE);
		m_slider_BB.SetTicFreq(PARAM_TIC_FREQ_LIN_GAMMA);
#endif

		m_slider_D.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_D.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_Y.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_Y.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_M.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_M.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_C.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_C.SetTicFreq(PARAM_TIC_FREQ);
	}

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	SetEditboxInt(m_edit_RR, PARAM_DEFAULT, FALSE);
	m_slider_RR.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_GG, PARAM_DEFAULT, FALSE);
	m_slider_GG.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_BB, PARAM_DEFAULT, FALSE);
	m_slider_BB.SetPos(PARAM_DEFAULT);
#endif

	SetEditboxInt(m_edit_D, PARAM_DEFAULT, FALSE);
	m_slider_D.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_Y, PARAM_DEFAULT, FALSE);
	m_slider_Y.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_M, PARAM_DEFAULT, FALSE);
	m_slider_M.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_C, PARAM_DEFAULT, FALSE);
	m_slider_C.SetPos(PARAM_DEFAULT);

//Ver.2.4.0
#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	m_combo_Method.InsertString(-1, _T("New Linear"));
	m_combo_Method.InsertString(-1, _T("New Gamma"));
#endif
	m_combo_Method.InsertString(-1, _T("Old Linear"));
	m_combo_Method.InsertString(-1, _T("Old Gamma"));
//	m_combo_Method.InsertString(-1, _T("Linear"));
//	m_combo_Method.InsertString(-1, _T("Curve"));
	m_combo_Method.SetCurSel(0);
}

void C1dDataDlg::GetGUI()
{
#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	m_iRR = GetEditboxInt(m_edit_RR);
	m_iGG = GetEditboxInt(m_edit_GG);
	m_iBB = GetEditboxInt(m_edit_BB);
#endif
	m_iD = GetEditboxInt(m_edit_D);
	m_iY = GetEditboxInt(m_edit_Y);
	m_iM = GetEditboxInt(m_edit_M);
	m_iC = GetEditboxInt(m_edit_C);
}

void C1dDataDlg::SetEditboxInt(CEdit &edit, int num, BOOL fZero)
{
	CString	strInt;

	if(fZero && num==0){
		edit.SetWindowText(_T(""));
	}else{
		strInt.Format(_T("%d"), num);
		edit.SetWindowText(strInt);
	}
}

int C1dDataDlg::GetEditboxInt(CEdit &edit)
{
	CString	strInt;

	edit.GetWindowText(strInt);
	if(strInt==""){
		return 0;
	}else{
		return _ttoi(strInt);
	}
}


void C1dDataDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if( (CSliderCtrl*)pScrollBar == &m_slider_D ){
		SetEditboxInt(m_edit_D, m_slider_D.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_Y ){
		SetEditboxInt(m_edit_Y, m_slider_Y.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_M ){
		SetEditboxInt(m_edit_M, m_slider_M.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_C ){
		SetEditboxInt(m_edit_C, m_slider_C.GetPos(), FALSE);
	}
#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	else if( (CSliderCtrl*)pScrollBar == &m_slider_RR ){
		SetEditboxInt(m_edit_RR, m_slider_RR.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_GG ){
		SetEditboxInt(m_edit_GG, m_slider_GG.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_BB ){
		SetEditboxInt(m_edit_BB, m_slider_BB.GetPos(), FALSE);
	}
#endif
	else{ ;}

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void C1dDataDlg::OnOK() 
{
	GetGUI();
	CString	strDataPath, strMsg;
// Ver.2.4.0
/*
	if ( m_pPrinter->Create1dDataFile(m_iD, m_iY, m_iM, m_iC, strDataPath) ) {
		strMsg.Format(_T("Data path=%s"), strDataPath);
		AfxMessageBox(strMsg);
	}
*/
	DWORD	dwRet;
	int		nPos;

	nPos = m_combo_Method.GetCurSel();

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	if (nPos == 0) {
		// New Linear
		dwRet = m_pPrinter->Create1dDataFileNewLinear(m_iRR, m_iGG, m_iBB, strDataPath);
	} 
	else if(nPos == 1) {
		// New Gamma Curve
		dwRet = m_pPrinter->Create1dDataFileNewGamma(m_iRR, m_iGG, m_iBB, strDataPath);
	}
	else if(nPos == 2) {
		// Old Linear
		dwRet = m_pPrinter->Create1dDataFileOldLinear(m_iD, m_iY, m_iM, m_iC, strDataPath);
	}
	else {
		// Old Gamma Curve
		dwRet = m_pPrinter->Create1dDataFileOldGamma(m_iD, m_iY, m_iM, m_iC, strDataPath);
	}

#else
	if (nPos == 0) {
		dwRet = m_pPrinter->Create1dDataFile(m_iD, m_iY, m_iM, m_iC, strDataPath);
	} else {
		dwRet = m_pPrinter->Create1dDataFileWithGammaCurve(m_iD, m_iY, m_iM, m_iC, strDataPath);
	}
#endif

	if (dwRet) {
		strMsg.Format(_T("Data path=%s"), strDataPath);
		AfxMessageBox(strMsg);
	}
// Ver.2.4.0

	CDialog::OnOK();
}

// nakashima addition 06/08/30 Ver.2.4.1
void C1dDataDlg::OnSelchangeComboMethod() 
{
	int		nPos;

	nPos = m_combo_Method.GetCurSel();

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	if((nPos == 0) || (nPos == 1)) {
		m_slider_RR.SetRange(PARAM_MIN_LIN_GAMMA, PARAM_MAX_LIN_GAMMA, TRUE);
		m_slider_RR.SetTicFreq(PARAM_TIC_FREQ_LIN_GAMMA);
		m_slider_GG.SetRange(PARAM_MIN_LIN_GAMMA, PARAM_MAX_LIN_GAMMA, TRUE);
		m_slider_GG.SetTicFreq(PARAM_TIC_FREQ_LIN_GAMMA);
		m_slider_BB.SetRange(PARAM_MIN_LIN_GAMMA, PARAM_MAX_LIN_GAMMA, TRUE);
		m_slider_BB.SetTicFreq(PARAM_TIC_FREQ_LIN_GAMMA);
	}
	else if (nPos == 2) {
		m_slider_D.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_D.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_Y.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_Y.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_M.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_M.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_C.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_C.SetTicFreq(PARAM_TIC_FREQ);
	} else {
		m_slider_D.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_D.SetTicFreq(PARAM_TIC_FREQ_CURVE);
		m_slider_Y.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_Y.SetTicFreq(PARAM_TIC_FREQ_CURVE);
		m_slider_M.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_M.SetTicFreq(PARAM_TIC_FREQ_CURVE);
		m_slider_C.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_C.SetTicFreq(PARAM_TIC_FREQ_CURVE);
	}
#else
	if (nPos == 0) {
		m_slider_D.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_D.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_Y.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_Y.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_M.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_M.SetTicFreq(PARAM_TIC_FREQ);
		m_slider_C.SetRange(PARAM_MIN, PARAM_MAX, TRUE);
		m_slider_C.SetTicFreq(PARAM_TIC_FREQ);
	} else {
		m_slider_D.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_D.SetTicFreq(PARAM_TIC_FREQ_CURVE);
		m_slider_Y.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_Y.SetTicFreq(PARAM_TIC_FREQ_CURVE);
		m_slider_M.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_M.SetTicFreq(PARAM_TIC_FREQ_CURVE);
		m_slider_C.SetRange(PARAM_MIN_CURVE, PARAM_MAX_CURVE, TRUE);
		m_slider_C.SetTicFreq(PARAM_TIC_FREQ_CURVE);
	}
#endif

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	SetEditboxInt(m_edit_RR, PARAM_DEFAULT, FALSE);
	m_slider_RR.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_GG, PARAM_DEFAULT, FALSE);
	m_slider_GG.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_BB, PARAM_DEFAULT, FALSE);
	m_slider_BB.SetPos(PARAM_DEFAULT);
#endif

	SetEditboxInt(m_edit_D, PARAM_DEFAULT, FALSE);
	m_slider_D.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_Y, PARAM_DEFAULT, FALSE);
	m_slider_Y.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_M, PARAM_DEFAULT, FALSE);
	m_slider_M.SetPos(PARAM_DEFAULT);
	SetEditboxInt(m_edit_C, PARAM_DEFAULT, FALSE);
	m_slider_C.SetPos(PARAM_DEFAULT);
	
}
