/************************************************************/
/*															*/
/*	File :	1dDataDlg.h 									*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2005 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#ifndef __1DDATA_DLG_H__
#define __1DDATA_DLG_H__


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Printer.h"

#define PARAM_DEFAULT	(0)

#define PARAM_MIN		(-20)
#define PARAM_MAX		(20)
#define PARAM_TIC_FREQ	((PARAM_MAX - PARAM_MIN)/10)

// nakashima addition 06/08/30 Ver.2.4.1
#define PARAM_MIN_CURVE			(-7)
#define PARAM_MAX_CURVE			(7)
#define PARAM_TIC_FREQ_CURVE	((PARAM_MAX_CURVE - PARAM_MIN_CURVE)/14)

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
#define PARAM_MIN_LIN_GAMMA			(-15)
#define PARAM_MAX_LIN_GAMMA			(15)
#define PARAM_TIC_FREQ_LIN_GAMMA	((PARAM_MAX_LIN_GAMMA - PARAM_MIN_LIN_GAMMA)/10)
#endif

class C1dDataDlg : public CDialog
{
public:
	C1dDataDlg(CWnd* pParent = NULL);
	BOOL	IsDlgCreate() { return m_fCreate; }
	void	SetPrinter(CPrinter *pPrinter) { m_pPrinter = pPrinter;	}

	//{{AFX_DATA(C1dDataDlg)
	enum { IDD = IDD_1DDATA_DLG };
//#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	CSliderCtrl	m_slider_RR;
	CSliderCtrl	m_slider_GG;
	CSliderCtrl	m_slider_BB;
	CEdit	m_edit_RR;
	CEdit	m_edit_GG;
	CEdit	m_edit_BB;
//#endif
	CSliderCtrl	m_slider_D;
	CSliderCtrl	m_slider_Y;
	CSliderCtrl	m_slider_M;
	CSliderCtrl	m_slider_C;
	CEdit	m_edit_D;
	CEdit	m_edit_Y;
	CEdit	m_edit_M;
	CEdit	m_edit_C;
	CComboBox	m_combo_Method;			//Ver.2.4.0
	//}}AFX_DATA


	//{{AFX_VIRTUAL(C1dDataDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(C1dDataDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	virtual void OnOK();
	afx_msg void OnSelchangeComboMethod();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	BOOL m_fCreate;
#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	int m_iRR;
	int m_iGG;
	int m_iBB;
#endif
	int m_iD;
	int m_iY;
	int m_iM;
	int m_iC;
	CPrinter*	m_pPrinter;

	void SetGUI(BOOL fInit);
	void GetGUI();
	void SetEditboxInt(CEdit &edit, int num, BOOL fZero);
	int  GetEditboxInt(CEdit &edit);
};

//{{AFX_INSERT_LOCATION}}

#endif // __1DDATA_DLG_H__
