/************************************************************/
/*                                                          */
/*  File :  Debug.cpp                                       */
/*                                                          */
/*  FUJIFILM Printer Control DLL                            */
/*      (Debug function implement file)                     */
/*                                                          */
/*  Copyright (C) 2002-2005 Fuji Photo Film Co., Ltd.       */
/*                                                          */
/************************************************************/


#include "stdafx.h"	// delete it when you do not use MFC. 
#include <stdio.h>
#include <time.h>
#include "Debug.h"

#ifdef LOGGING
#include "Log_W32c.h"
#endif


///////////////////////////////////////////////////////////////////////////////
//
//	define
//


#ifdef LOGGING
// For log file output

#define	LOG_FILENAME					"AppLog"
#define	LOG_TOP_STR						"FUJIFILM Log file"

#endif	// #ifdef LOGGING


///////////////////////////////////////////////////////////////////////////////
//
//	Internal variable
//


#ifdef LOGGING
// For log file output

static CLogFile		*g_pLog = NULL;

#endif // #ifdef	LOGGING


///////////////////////////////////////////////////////////////////////////////
//
//	Internal function declaration
//

void SetStartTime(DWORD &dwTime);
void GetLapTime(DWORD &dwTime);


///////////////////////////////////////////////////////////////////////////////
//
//	Implementation  for debugging
//


#ifdef LOGGING

//	Function group for log file output

// Output beginning to log fileihModule : Module handle of Execution programj
BOOL DEBUG_StartLog(HMODULE hModule)
{
//	char strFileName[] = LOG_FILENAME;
	char strFileName[MAX_PATH];
	strcpy(strFileName, LOG_FILENAME);
	DEBUG_GetTimeStamp(strFileName);

	g_pLog = new CLogFile(strFileName);
	if (g_pLog == NULL) {
		return	FALSE;
	}


	g_pLog->LOG_SetLogTopString(LOG_TOP_STR);
//	g_pLog->LOG_SetModuleHandle(NULL);
	g_pLog->LOG_SetModuleHandle(hModule);
	g_pLog->LOG_SetLogLevel(LOG_LEVEL_DEFAULT);
//	g_pLog->LOG_SetAddInfo(LOG_ADDINFO_TIME_NOW);
	g_pLog->LOG_SetAddInfo(LOG_ADDINFO_TIME_NOW | LOG_ADDINFO_THREADID);

	g_pLog->LOG_Start();

	return	TRUE;
}


// Output beginning to log fileihModule : Module handle of Execution programj
//	(LogFileTitle : Log file name(except extention))
BOOL DEBUG_StartLog(HMODULE hModule, LPCSTR LogFileTitle){

	g_pLog = new CLogFile(LogFileTitle);
	if (g_pLog == NULL) {
		return	FALSE;
	}

//	g_pLog->LOG_SetLogTopString(LOG_TOP_STR);
	g_pLog->LOG_SetModuleHandle(NULL);
//	g_pLog->LOG_SetModuleHandle(hModule);
	g_pLog->LOG_SetLogLevel(LOG_LEVEL_DEFAULT);
	g_pLog->LOG_SetAddInfo(LOG_ADDINFO_TIME_NOW);
//	g_pLog->LOG_SetAddInfo(LOG_ADDINFO_TIME_NOW | LOG_ADDINFO_THREADID);

	g_pLog->LOG_Start();

	return	TRUE;

}

// Output end in log file
void DEBUG_EndLog(void)
{
	
	if (g_pLog != NULL) {
		delete	g_pLog;
		g_pLog = NULL;
	}
}


// One line is output to the log file by the printf() form. iAutomatic changing linej
BOOL DEBUG_LOG_PRINTF(const char *Format, ... )
{
	va_list		pArg;

	if (g_pLog == NULL) {
		return	FALSE;
	}
	va_start(pArg, Format);
	g_pLog->LOG_VPRINTF(LOG_LEVEL_DEFAULT, Format, pArg);
	va_end(pArg);

	return	TRUE;
}


// Byte array data is output to the log file by the text form(Hexadecimal number row in 16 bytes a line). 
// ipData: Data buffer, Size: Number of databytesj
BOOL DEBUG_LOG_WRITE_DATA(PBYTE pData, WORD Size)
{
	
	if (g_pLog == NULL) {
		return	FALSE;
	}

	return	g_pLog->LOG_WRITE_DATA(LOG_LEVEL_DEFAULT, pData, Size);
}


BOOL DEBUG_GetTimeStamp(char* filename){
	char	szDate [9];
	char	szTime [9];
	char	szTimeStamp[11];
	char	yy[3], mm[3], dd[3], h[3], m[3], s[3];

	_strdate( szDate );
	_strtime( szTime );
	sscanf(szDate, "%2s/%2s/%2s", &mm, &dd, &yy);
	sscanf(szTime, "%2s:%2s:%2s", &h, &m, &s);
	sprintf(szTimeStamp, "_%s%s_%s%s", mm, dd, h, m);

	strcat(filename, szTimeStamp);

	return TRUE;
}

// One line is output to the log file by the printf() form. iAutomatic changing linej
// For time measurement, set start time.
BOOL DEBUG_LOG_PRINTF_SET(DWORD &startTime, const char *Format, ... )
{
	va_list		pArg;

	if (g_pLog == NULL) {
		return	FALSE;
	}
	va_start(pArg, Format);
	g_pLog->LOG_VPRINTF(LOG_LEVEL_DEFAULT, Format, pArg);
	va_end(pArg);

	SetStartTime(startTime);

	return	TRUE;
}

// One line is output to the log file by the printf() form. iAutomatic changing linej
// For time measurement, get the elapsed time .
BOOL DEBUG_LOG_PRINTF_TIME(DWORD startTime, const char *Format, ... )
{
	va_list		pArg;
	char		szBuf[256];
	DWORD		dwLapTime = startTime;

	if (g_pLog == NULL) {
		return	FALSE;
	}

	GetLapTime(dwLapTime);

	va_start(pArg, Format);
	vsprintf(szBuf, Format, pArg);
	va_end(pArg);

	DEBUG_LOG_PRINTF("%s <%d msec>", szBuf, dwLapTime);

	return	TRUE;
}


///////////////////////////////////////////////////////////////////////////////
//
//	Internal function definition
//

void SetStartTime(DWORD &dwTime){
	dwTime = GetTickCount();
}

void GetLapTime(DWORD &dwTime){
	DWORD dwStartTime, dwEndTime;

	dwStartTime = dwTime;
	dwEndTime = GetTickCount();
	dwTime = dwEndTime - dwStartTime;
}


#endif	// #ifdef LOGGING
