/************************************************************/
/*															*/
/*	File :	ErrDlg.cpp										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#include "stdafx.h"
#include "sdksample.h"
#include "ErrDlg.h"
#include "DPBAPI.h"

#include "Encode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Struct for error code table
typedef struct {
	BYTE			ErrCode;
	UINT			ErrStrID;
} ERR_STR_INFO, *PERR_STR_INFO;

// Printer condition error code table
static ERR_STR_INFO PErrInfoTbl[] = {
	{MCP_PERR_PRINTER_BUSY,			IDS_ERR_PERR_PRINTER_BUSY,		},
	{MCP_PERR_NO_PRINTER,			IDS_ERR_PERR_NO_PRINTER,		},
	{MCP_PERR_PRINTER_RESERVED,		IDS_ERR_PERR_PRINTER_RESERVED,	},
	{MCP_PERR_UNKNOWN,				IDS_ERR_UNKNOWN,				},
};

// Printer hardware error code table
static ERR_STR_INFO HErrInfoTbl[] = {
	{MCP_HERR_H,					IDS_ERR_HERR_H,					},
	{MCP_HERR_J,					IDS_ERR_HERR_J,					},
	{MCP_HERR_U,					IDS_ERR_HERR_U,					},
	{MCP_HERR_C,					IDS_ERR_HERR_C,					},
	{MCP_HERR_NO_PAPER,				IDS_ERR_HERR_NO_PAPER,			},
	{MCP_HERR_PARAMETER,			IDS_ERR_HERR_PARAMETER,			},
	{MCP_HERR_UNKNOWN,				IDS_ERR_UNKNOWN,				},
};

// Interface error code table
static ERR_STR_INFO IErrInfoTbl[] = {
	{MCP_IERR_COMM_DEVICE,			IDS_ERR_IERR_COMM_DEVICE,		},
	{MCP_IERR_UNKNOWN,				IDS_ERR_UNKNOWN,				},
};

// SDK software error code table
static ERR_STR_INFO SErrInfoTbl[] = {
	{MCP_SERR_USE_SDK,				IDS_ERR_SERR_USE_SDK,			},
	{MCP_SERR_PC_RESOURCE,			IDS_ERR_SERR_PC_RESOURCE,		},
	{MCP_SERR_UNKNOWN,				IDS_ERR_UNKNOWN,				},
};

// Recovery info code table
static ERR_STR_INFO RecoveryTbl[] = {
	{MCP_RECOVERY_IGNORE,			IDS_ERR_RECOVERY_IGNORE,		},
	{MCP_RECOVERY_CMD_RETRY,		IDS_ERR_RECOVERY_CMD_RETRY,		},
	{MCP_RECOVERY_WAIT_READY,		IDS_ERR_RECOVERY_WAIT_READY,	},
	{MCP_RECOVERY_CLOSE_PRINTER,	IDS_ERR_RECOVERY_CLOSE_PRINTER,	},
	{MCP_RECOVERY_OPERATOR_RESET,	IDS_ERR_RECOVERY_OPERATOR_RESET,},
	{MCP_RECOVERY_REBOOT_PRINTER,	IDS_ERR_RECOVERY_REBOOT_PRINTER,},
	{MCP_RECOVERY_REBOOT_PC,		IDS_ERR_RECOVERY_REBOOT_PC,		},
	{MCP_RECOVERY_EXHAUST_PARTS,	IDS_ERR_RECOVERY_EXHAUST_PARTS,	},
	{MCP_RECOVERY_CHECK_ENV,		IDS_ERR_RECOVERY_CHECK_ENV,		},
	{MCP_RECOVERY_CHECK_DEVICE,		IDS_ERR_RECOVERY_CHECK_DEVICE,	},
	{MCP_RECOVERY_CHECK_PROGRAM,	IDS_ERR_RECOVERY_CHECK_PROGRAM,	},
	{MCP_RECOVERY_UNKNOWN,			IDS_ERR_RECOVERY_UNKNOWN,		},
};


// Struct for error flag
typedef struct {
	BYTE			ErrCode;
	UINT			ErrStrID;
	PERR_STR_INFO	pErrInfoTbl;
	int				ErrInfoCnt;
} ERR_FLAG_INFO, *PERR_FLAG_INFO;

// Error flag table
static ERR_FLAG_INFO ErrFlagTbl[] = {
	{MCP_ERRF_OK,			IDS_ERR_ERRF_OK,			NULL,			0,							},
	{MCP_ERRF_P,			IDS_ERR_ERRF_P,				PErrInfoTbl,	COUNTOF_ARRAY(PErrInfoTbl),	},
	{MCP_ERRF_H,			IDS_ERR_ERRF_H,				HErrInfoTbl,	COUNTOF_ARRAY(HErrInfoTbl),	},
	{MCP_ERRF_H_CONTINUE,	IDS_ERR_ERRF_H_CONTINUE,	HErrInfoTbl,	COUNTOF_ARRAY(HErrInfoTbl),	},
	{MCP_ERRF_I,			IDS_ERR_ERRF_I,				IErrInfoTbl,	COUNTOF_ARRAY(IErrInfoTbl),	},
	{MCP_ERRF_S,			IDS_ERR_ERRF_S,				SErrInfoTbl,	COUNTOF_ARRAY(SErrInfoTbl),	},
};


// Struct for error message
typedef struct {
	BYTE			ErrFlag;
	DWORD			ErrCode;
	UINT			ErrStrID;
} ERR_MESSAGE_INFO, *PERR_MESSAGE_INFO;

// Error message table
static ERR_MESSAGE_INFO ErrMessageTbl[] = {
	{MCP_ERRF_P,		MCP_ERR_BUSY_INITIALIZING,		IDS_ERR_SDKP_BUSY_INITIALIZING,		},
	{MCP_ERRF_P,		MCP_ERR_BUSY_PRINTING,			IDS_ERR_SDKP_BUSY_PRINTING,			},
//	{MCP_ERRF_P,		MCP_ERR_BUSY_FEEDANDCUT,		IDS_ERR_SDKP_BUSY_FEEDANDCUT,		},
	{MCP_ERRF_P,		MCP_ERR_BUSY_UNKNOWN,			IDS_ERR_SDKP_BUSY_UNKNOWN,			},
	{MCP_ERRF_P,		MCP_ERR_NO_DEVICE,				IDS_ERR_SDKP_NO_DEVICE,				},
	{MCP_ERRF_H,		MCP_ERR_NO_PAPER,				IDS_ERR_SDKH_NO_PAPER,				},
	{MCP_ERRF_H,		MCP_ERR_NO_INK,					IDS_ERR_SDKH_NO_INK,				},
	{MCP_ERRF_H,		MCP_ERR_PAPER_DOOR_OPEN,		IDS_ERR_SDKH_PAPER_DOOR_OPEN,		},
	{MCP_ERRF_H,		MCP_ERR_INK_DOOR_OPEN,			IDS_ERR_SDKH_INK_DOOR_OPEN,			},
	{MCP_ERRF_H,		MCP_ERR_MEDIA_MISMATCH,			IDS_ERR_SDKH_MEDIA_MISMATCH,		},
	{MCP_ERRF_H,		MCP_ERR_PAPER_JAM,				IDS_ERR_SDKH_PAPER_JAM,				},
	{MCP_ERRF_H,		MCP_ERR_INK_JAM,				IDS_ERR_SDKH_INK_JAM,				},
	{MCP_ERRF_H,		MCP_ERR_MECHA_ERROR,			IDS_ERR_SDKH_MECHA_ERROR,			},
	{MCP_ERRF_H_CONTINUE,		MCP_ERR_PRINTING_PAPER_END,			IDS_ERR_SDKH_PRINTING_PAPER_END,		},
	{MCP_ERRF_H_CONTINUE,		MCP_ERR_PRINTING_INK_END,			IDS_ERR_SDKH_PRINTING_INK_END,			},
	{MCP_ERRF_H_CONTINUE,		MCP_ERR_PRINTING_PAPER_DOOR_OPEN,	IDS_ERR_SDKH_PRINTING_PAPER_DOOR_OPEN,	},
	{MCP_ERRF_H_CONTINUE,		MCP_ERR_PRINTING_INK_DOOR_OPEN,		IDS_ERR_SDKH_PRINTING_INK_DOOR_OPEN,	},
	{MCP_ERRF_H_CONTINUE,		MCP_ERR_PRINTING_MEDIA_MISMATCH,	IDS_ERR_SDKH_PRINTING_MEDIA_MISMATCH,	},
/*
	{MCP_ERRF_H,		MCP_ERR_SHEET_END,				IDS_ERR_SDKH_SHEET_END,				},
	{MCP_ERRF_H,		MCP_ERR_PAPER_END,				IDS_ERR_SDKH_PAPER_END,				},
	{MCP_ERRF_H,		MCP_ERR_PAPER_JAM,				IDS_ERR_SDKH_PAPER_JAM,				},
//	{MCP_ERRF_H,		MCP_ERR_SHEET_CASSET_NOT_SET,	IDS_ERR_SDKH_SHEET_CASSET_NOT_SET,	},
	{MCP_ERRF_H,		MCP_ERR_PAPER_SHEET_ILLEGAL,	IDS_ERR_SDKH_PAPER_SHEET_ILLEGAL,	},
//	{MCP_ERRF_H,		MCP_ERR_PAPER_CASSET_NOT_SET,	IDS_ERR_SDKH_PAPER_CASSET_NOT_SET,	},
	{MCP_ERRF_H,		MCP_ERR_PAPER_SIZE_ILLEGAL,		IDS_ERR_SDKH_PAPER_SIZE_ILLEGAL,	},
//	{MCP_ERRF_H,		MCP_ERR_HEAT_ERROR,				IDS_ERR_SDKH_HEAT_ERROR,			},
	{MCP_ERRF_H,		MCP_ERR_DOOR_OPEN,				IDS_ERR_SDKH_DOOR_OPEN,				},
//	{MCP_ERRF_H,		MCP_ERR_UNUSABLE_SHEET,			IDS_ERR_SDKH_UNUSABLE_SHEET,		},
//	{MCP_ERRF_H,		MCP_ERR_SHEET_CASSET_ILLEGAL,	IDS_ERR_SDKH_SHEET_CASSET_ILLEGAL,	},
//	{MCP_ERRF_H,		MCP_ERR_PAPER_REMAIN,			IDS_ERR_SDKH_PAPER_REMAIN,			},
//	{MCP_ERRF_H,		MCP_ERR_SHEET_REMAIN,			IDS_ERR_SDKH_SHEET_REMAIN,			},
//	{MCP_ERRF_H,		MCP_ERR_SHEET_MARK_ERROR,		IDS_ERR_SDKH_SHEET_MARK_ERROR,		},
//	{MCP_ERRF_H,		MCP_ERR_PAPER_JAM_D,			IDS_ERR_SDKH_PAPER_JAM_D,			},
	{MCP_ERRF_H,		MCP_ERR_MECHA_ERROR,			IDS_ERR_SDKH_MECHA_ERROR,			},
//	{MCP_ERRF_H,		MCP_ERR_MECHA_ERROR_D,			IDS_ERR_SDKH_MECHA_ERROR_D,			},
//	{MCP_ERRF_H,		MCP_ERR_MECHA_INIT_REQ,			IDS_ERR_SDKH_MECHA_INIT_REQ,		},
//	{MCP_ERRF_H,		MCP_ERR_PRINTING_TURN_OFF,		IDS_ERR_SDKH_PRINTING_TURN_OFF,		},
//	{MCP_ERRF_H,		MCP_ERR_CONTRAST_DATA_ERROR,	IDS_ERR_SDKH_CONTRAST_DATA_ERROR,	},
//	{MCP_ERRF_H,		MCP_ERR_TABLE_ERROR,			IDS_ERR_SDKH_TABLE_ERROR,			},
*/
	{MCP_ERRF_I,		MCP_ERR_USB_CONTROL,			IDS_ERR_SDKI_USB_CONTROL,			},
	{MCP_ERRF_S,		MCP_ERR_NO_CONTROL,				IDS_ERR_SDKS_NO_CONTROL,			},
	{MCP_ERRF_S,		MCP_ERR_NO_IMGSET_3DLUT_DATA,	IDS_ERR_SDKS_NO_IMGSET_3DLUT_DATA,	},
	{MCP_ERRF_S,		MCP_ERR_NO_IMGSET_1DLUT_DATA,	IDS_ERR_SDKS_NO_IMGSET_1DLUT_DATA,	},
	{MCP_ERRF_S,		MCP_ERR_STILL_OPEN,				IDS_ERR_SDKS_STILL_OPEN,			},
	{MCP_ERRF_S,		MCP_ERR_ALREADY_OPEN,			IDS_ERR_SDKS_ALREADY_OPEN,			},
	{MCP_ERRF_S,		MCP_ERR_MAX_OPEN,				IDS_ERR_SDKS_MAX_OPEN,				},
	{MCP_ERRF_S,		MCP_ERR_MEMORY_ALLOC,			IDS_ERR_SDKS_MEMORY_ALLOC,			},
	{MCP_ERRF_S,		MCP_ERR_FAIL_START_THREAD,		IDS_ERR_SDKS_FAIL_START_THREAD,		},
//	{MCP_ERRF_S,		MCP_ERR_UNKNOWN,				IDS_ERR_SDK_UNKNOWN,				},
};


/////////////////////////////////////////////////////////////////////////////
// CErrDlg dialog

CErrDlg::CErrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CErrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CErrDlg)
	m_strErrFlag = _T("");
	m_strErrInfo = _T("");
	m_strRecovery = _T("");
	m_strFunc = _T("");
	m_strNo = _T("");
	m_strErrMsg = _T("");
	//}}AFX_DATA_INIT

	m_PrinterError  = " ";
	m_PrinterStatus = 0;
}


void CErrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CErrDlg)
	DDX_Text(pDX, IDC_STATIC_ERRFLAG, m_strErrFlag);
	DDX_Text(pDX, IDC_STATIC_ERRINFO, m_strErrInfo);
	DDX_Text(pDX, IDC_STATIC_RECOVERY, m_strRecovery);
	DDX_Text(pDX, IDC_STATIC_FUNC, m_strFunc);
	DDX_Text(pDX, IDC_STATIC_PRINTERNO, m_strNo);
	DDX_Text(pDX, IDC_STATIC_ERRMSG, m_strErrMsg);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CErrDlg, CDialog)
	//{{AFX_MSG_MAP(CErrDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// Set SDK error code information to display dialog.
void CErrDlg::SetErrorInfo(LPCTSTR FuncName, int PrinterNo, DWORD RetCode, DWORD ErrCode, DWORD DetailErrCode)
{

	m_strFunc		= FuncName;
	m_PrinterNo		= PrinterNo;
	m_RetCode		= RetCode;
	m_ErrCode		= ErrCode;
	m_DetailErrCode	= DetailErrCode;

}


void CErrDlg::SetErrorInfo(LPCTSTR FuncName, int PrinterNo, DWORD RetCode, DWORD ErrCode, DWORD DetailErrCode, char* szPrinterError, DWORD PrinterStatus)
{

	m_strFunc		= FuncName;
	m_PrinterNo		= PrinterNo;
	m_RetCode		= RetCode;
	m_ErrCode		= ErrCode;
	m_DetailErrCode	= DetailErrCode;

	m_PrinterError  = szPrinterError;
	m_PrinterStatus = PrinterStatus;
}


/////////////////////////////////////////////////////////////////////////////
// CErrDlg message handler


// Initialize dialog display.
BOOL CErrDlg::OnInitDialog() 
{
	BYTE			errFlag, errInfo, recovery;
	PERR_STR_INFO	pErrTbl;
	int				errInfoCnt, i;
	CString			tmpStr;
	TCHAR			szPrinterError[4];

// 2006/03/17 Ver.2.3.0
#ifdef UNICODE
	CEncode	Encode;

	if( 0!=Encode.ToUnicode(m_PrinterError, szPrinterError) ){
		AfxMessageBox(_T("File Path Encode Error."));
		return FALSE;
	}
#else
	strcpy(szPrinterError, m_PrinterError);
#endif


	CDialog::OnInitDialog();

	// Display "Printer No.".
	if (m_PrinterNo != UNKNOWN_PRINTER_NO) {
		m_strNo.Format(_T("%d"), m_PrinterNo);
	}

	// Display "Error flag".
	errFlag = MCP_ERRFLAG(m_RetCode);
	for (i = 0; i < COUNTOF_ARRAY(ErrFlagTbl); i++) {
		if (errFlag == ErrFlagTbl[i].ErrCode) {
			m_strErrFlag.LoadString(ErrFlagTbl[i].ErrStrID);
			pErrTbl = ErrFlagTbl[i].pErrInfoTbl;
			errInfoCnt = ErrFlagTbl[i].ErrInfoCnt;
			break;
		}
	}

	// Display "Error info.".
	errInfo = MCP_ERRINFO(m_RetCode);
	if (pErrTbl) {
		for (i = 0; i < errInfoCnt; i++) {
			if (errInfo == pErrTbl[i].ErrCode) {
				m_strErrInfo.LoadString(pErrTbl[i].ErrStrID);
				break;
			}
		}
	} else {
		m_strErrInfo = "";
	}
	if (i >= errInfoCnt) {
		// Unknown error.
		m_strErrInfo.LoadString(ErrFlagTbl[errInfoCnt - 1].ErrStrID);
	}

	// Display "Recovery info.".
	recovery = MCP_RECOVERY(m_RetCode);
	for (i = 0; i < COUNTOF_ARRAY(RecoveryTbl); i++) {
		if (recovery == RecoveryTbl[i].ErrCode) {
			m_strRecovery.LoadString(RecoveryTbl[i].ErrStrID);
			break;
		}
	}
	if (i >= COUNTOF_ARRAY(RecoveryTbl)) {
		// Unknown error.
		m_strRecovery.LoadString(ErrFlagTbl[COUNTOF_ARRAY(RecoveryTbl) - 1].ErrStrID);
	}

	// Dislay "Error code" got by MCP_GetLastError() 
	errFlag = MCP_ERRFLAG(m_ErrCode);
	for (i = 0; i < COUNTOF_ARRAY(ErrMessageTbl); i++) {
		if ((errFlag == ErrMessageTbl[i].ErrFlag) && (m_ErrCode == ErrMessageTbl[i].ErrCode)) {
			m_strErrMsg.LoadString(ErrMessageTbl[i].ErrStrID);/*M*/
			break;
		}
	}
	if (i >= COUNTOF_ARRAY(ErrMessageTbl)) {
		// Unknown error.
		m_strErrMsg.LoadString(IDS_ERR_SDK_UNKNOWN);
		tmpStr.Format(_T("%08Xh"), m_ErrCode);
		m_strErrMsg += tmpStr;
	}

	// 2006/03/13 Ver.2.3.0
	if( ((CString)szPrinterError).IsEmpty() ){
		tmpStr.Format( _T("0x%08x \n%s \n(0x%08x)"), m_ErrCode, m_strErrMsg, m_PrinterStatus );	
		m_strErrMsg = tmpStr;
	}else{
		tmpStr.Format( _T("0x%08x \n%s \n(%s - 0x%08x)"), m_ErrCode, m_strErrMsg, szPrinterError, m_PrinterStatus );
		m_strErrMsg = tmpStr;
	}

	// Recoverable error => OK button is hidden.
	if( MCP_IS_ERRF_H_CONTINUE(m_RetCode) ){
		CButton* pButtonOK = (CButton*)GetDlgItem(IDOK);
		pButtonOK->ShowWindow(SW_HIDE);
	}
	UpdateData(FALSE);

	return TRUE;
}

