/************************************************************/
/*															*/
/*	File :	ImgSetupDlg.cpp									*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#include "stdafx.h"
#include "sdksample.h"
#include "ImgSetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImgSetupDlg


CImgSetupDlg::CImgSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CImgSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CImgSetupDlg)
	//}}AFX_DATA_INIT
	m_fCreate = FALSE;
}

void CImgSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImgSetupDlg)
	DDX_Control(pDX, IDC_CHECK_REDEYE, m_check_redeye);
	DDX_Control(pDX, IDC_CHECK_AUTO, m_check_auto);
	DDX_Control(pDX, IDC_SLIDER_Y, m_slider_Y);
	DDX_Control(pDX, IDC_SLIDER_M, m_slider_M);
	DDX_Control(pDX, IDC_SLIDER_CONTRAST, m_slider_Contrast);
	DDX_Control(pDX, IDC_SLIDER_C, m_slider_C);
	DDX_Control(pDX, IDC_SLIDER_BRIGHTNESS, m_slider_Brightness);
	DDX_Control(pDX, IDC_EDIT_Y, m_edit_Y);
	DDX_Control(pDX, IDC_EDIT_PRINTER_PROFILE, m_edit_PrinterProfile);
	DDX_Control(pDX, IDC_EDIT_M, m_edit_M);
	DDX_Control(pDX, IDC_EDIT_CONTRAST, m_edit_Contrast);
	DDX_Control(pDX, IDC_EDIT_C, m_edit_C);
	DDX_Control(pDX, IDC_EDIT_BRIGHTNESS, m_edit_Brightness);
	DDX_Control(pDX, IDC_COMBO_TYPE, m_combo_type);
	DDX_Control(pDX, IDC_COMBO_MONOTONE, m_combo_monotone);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CImgSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CImgSetupDlg)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_SET_PRINTER_PROFILE, OnSetPrinterProfile)
	ON_BN_CLICKED(IDC_CLEAR_PRINTER_PROFILE, OnClearPrinterProfile)
	ON_BN_CLICKED(IDC_CHECK_REDEYE, OnCheckRedeye)
	ON_BN_CLICKED(IDC_DEFAULT, OnDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImgSetupDlg Message Handler

BOOL CImgSetupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_fCreate = TRUE;
	SetGUI(TRUE);
	
	return TRUE;
}

void CImgSetupDlg::OnCancel() 
{
	CDialog::OnCancel();
}

void CImgSetupDlg::OnOK() 
{
	GetGUI();

	CDialog::OnOK();
}

void CImgSetupDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if( (CSliderCtrl*)pScrollBar == &m_slider_Contrast ){
		SetEditboxInt(m_edit_Contrast, m_slider_Contrast.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_Brightness ){
		SetEditboxInt(m_edit_Brightness, m_slider_Brightness.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_C ){
		SetEditboxInt(m_edit_C, m_slider_C.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_M ){
		SetEditboxInt(m_edit_M, m_slider_M.GetPos(), FALSE);
	}
	else if( (CSliderCtrl*)pScrollBar == &m_slider_Y ){
		SetEditboxInt(m_edit_Y, m_slider_Y.GetPos(), FALSE);
	}
	else{	;}

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}


////////////////////////////////////////////////
// GUI Operator

void CImgSetupDlg::SetGUI(BOOL fInit)
{
	int	index = 0;
	CButton *pBtn_MarkerOn, *pBtn_MarkerOff;
	pBtn_MarkerOn = (CButton *)GetDlgItem(IDC_RADIO_MARKER_ON);
	pBtn_MarkerOff = (CButton *)GetDlgItem(IDC_RADIO_MARKER_OFF);

	if (fInit) {// Processing for which initialization is necessary only once.
		m_combo_monotone.InsertString(-1, _T("OFF"));
		m_combo_monotone.InsertString(-1, _T("Black&White"));
		m_combo_monotone.InsertString(-1, _T("Sepia"));

		m_combo_type.InsertString(-1, _T("TYPE DSC"));
//		m_combo_type.InsertString(-1, _T("TYPE SCN"));

		m_slider_C.SetRange(COLOR_MIN, COLOR_MAX, TRUE);
		m_slider_C.SetTicFreq(1);
		m_slider_M.SetRange(COLOR_MIN, COLOR_MAX, TRUE);
		m_slider_M.SetTicFreq(1);
		m_slider_Y.SetRange(COLOR_MIN, COLOR_MAX, TRUE);
		m_slider_Y.SetTicFreq(1);
		m_slider_Brightness.SetRange(COLOR_MIN, COLOR_MAX, TRUE);
		m_slider_Brightness.SetTicFreq(1);
		m_slider_Contrast.SetRange(COLOR_MIN, COLOR_MAX, TRUE);
		m_slider_Contrast.SetTicFreq(1);
	}
	// Set Auto flag.
	m_check_auto.SetCheck(m_pIsplInfo->fAuto);

	// Set Monotone mode.
	switch(m_pIsplInfo->iMonotone){
	default:
	case MONOTONE_OFF:
		index = 0;
		break;
	case MONOTONE_BW:
		index = 1; 
		break;
	case MONOTONE_SEPIA:
		index = 2; 
		break;
	}
	m_combo_monotone.SetCurSel(index);

	// Set Setup Type.
	switch(m_pIsplInfo->iSetupType){
	default:
	case TYPE_DSC:
		index = 0;
		break;
	case TYPE_SCN:
		index = 1; 
		break;
	}
	m_combo_type.SetCurSel(index);

	// Set RedEye flag.
	m_check_redeye.SetCheck(m_pIsplInfo->fRedEye);
	EnableRedEye(m_pIsplInfo->fRedEye);

	// Set RedEye Marker flag.
	if(m_pIsplInfo->fMarker){
		pBtn_MarkerOn->SetCheck(BST_CHECKED);
		pBtn_MarkerOff->SetCheck(BST_UNCHECKED);
	}else{
		pBtn_MarkerOn->SetCheck(BST_UNCHECKED);
		pBtn_MarkerOff->SetCheck(BST_CHECKED);
	}

	// Set Color Correction Parameter.
	SetEditboxInt(m_edit_C, m_pIsplInfo->iColorC, FALSE);
	SetEditboxInt(m_edit_M, m_pIsplInfo->iColorM, FALSE);
	SetEditboxInt(m_edit_Y, m_pIsplInfo->iColorY, FALSE);
	SetEditboxInt(m_edit_Brightness, m_pIsplInfo->iBright, FALSE);
	SetEditboxInt(m_edit_Contrast, m_pIsplInfo->iContrast, FALSE);

	m_slider_C.SetPos(m_pIsplInfo->iColorC);
	m_slider_M.SetPos(m_pIsplInfo->iColorM);
	m_slider_Y.SetPos(m_pIsplInfo->iColorY);
	m_slider_Brightness.SetPos(m_pIsplInfo->iBright);
	m_slider_Contrast.SetPos(m_pIsplInfo->iContrast);

	// Set Profile.
	m_edit_PrinterProfile.SetWindowText(m_pIsplInfo->wszOutputProfile);
}

void CImgSetupDlg::GetGUI()
{
	CString	strTemp = _T("");

	CButton *pBtn_MarkerOn;
	pBtn_MarkerOn= (CButton *)GetDlgItem(IDC_RADIO_MARKER_ON);

	m_pIsplInfo->iColorC = GetEditboxInt(m_edit_C);
	m_pIsplInfo->iColorM = GetEditboxInt(m_edit_M);
	m_pIsplInfo->iColorY = GetEditboxInt(m_edit_Y);
	m_pIsplInfo->iBright = GetEditboxInt(m_edit_Brightness);
	m_pIsplInfo->iContrast = GetEditboxInt(m_edit_Contrast);

	m_pIsplInfo->fRedEye = m_check_redeye.GetCheck();
	m_pIsplInfo->fMarker = pBtn_MarkerOn->GetCheck();

	m_pIsplInfo->fAuto = m_check_auto.GetCheck();


	switch(	m_combo_type.GetCurSel()){
	default:
	case 0:
		m_pIsplInfo->iSetupType = TYPE_DSC;
		break;
	case 1:
		m_pIsplInfo->iSetupType = TYPE_SCN;
		break;
	}

	switch(	m_combo_monotone.GetCurSel()){
	default:
	case 0:
		m_pIsplInfo->iMonotone = MONOTONE_OFF;
		break;
	case 1:
		m_pIsplInfo->iMonotone = MONOTONE_BW;
		break;
	case 2:
		m_pIsplInfo->iMonotone = MONOTONE_SEPIA;
		break;
	}

	m_edit_PrinterProfile.GetWindowText( strTemp );
	_tcscpy(m_pIsplInfo->wszOutputProfile, strTemp);
}

void CImgSetupDlg::SetEditboxInt(CEdit &edit, int num, BOOL fZero)
{
	CString	strInt;

	if(fZero && num==0){
		edit.SetWindowText(_T(""));
	}else{
		strInt.Format(_T("%d"), num);
		edit.SetWindowText(strInt);
	}
}

int CImgSetupDlg::GetEditboxInt(CEdit &edit)
{
	CString	strInt;
	edit.GetWindowText(strInt);

	if(strInt==""){
		return 0;
	}else{
		return _ttoi(strInt);
	}
}

void CImgSetupDlg::EnableRedEye(BOOL fEnable)
{
	CButton *pBtn_MarkerOn, *pBtn_MarkerOff;
	pBtn_MarkerOn = (CButton *)GetDlgItem(IDC_RADIO_MARKER_ON);
	pBtn_MarkerOff = (CButton *)GetDlgItem(IDC_RADIO_MARKER_OFF);

	pBtn_MarkerOn->EnableWindow(fEnable);
	pBtn_MarkerOff->EnableWindow(fEnable);
}

void CImgSetupDlg::OnSetPrinterProfile() 
{
	CString			strFilePath;

	CFileDialog		dlg( TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_ALLOWMULTISELECT,
                        _T("DAT (*.dat)|*.dat|All Files (*.*)|*.*||"),  this);
	
	if( dlg.DoModal() != IDOK) {
		return;
	}
	strFilePath = dlg.GetPathName();
	_tcscpy(m_pIsplInfo->wszOutputProfile, strFilePath);

	m_edit_PrinterProfile.SetWindowText(strFilePath);		
}

void CImgSetupDlg::OnClearPrinterProfile() 
{
	m_edit_PrinterProfile.SetWindowText(_T(""));		
}

void CImgSetupDlg::OnCheckRedeye() 
{
	EnableRedEye(m_check_redeye.GetCheck());	
}

void CImgSetupDlg::OnDefault() 
{
	SetDefaultParam();
	SetGUI(FALSE);	
}

BOOL CImgSetupDlg::GetExePath(CString &strPath)
{
	TCHAR	tszPath[_MAX_PATH], tszDrive[_MAX_DRIVE], tszDir[_MAX_DIR];

	if(GetModuleFileName( NULL, tszPath, _MAX_PATH )==0){
		return FALSE;
	}	
	_tsplitpath( tszPath, tszDrive, tszDir, NULL, NULL );
	strPath.Format(_T("%s%s"), tszDrive, tszDir);

	return TRUE;
}

void CImgSetupDlg::SetDefaultParam()
{
	CString	strPath, strPrinterName;

	// Default data file path for 3DLUT.
	GetExePath(strPath);

	// 2005/12/16 Ver.2.0.0 Switch the data file
	m_pPrinter->GetProductName(strPrinterName);
	if (strPrinterName == _T("ASK-1500")) {
		strPath += DEFAULT_PRINTER_PROFILE_1500;
	} else if (strPrinterName == _T("ASK-4000")) {
		strPath += DEFAULT_PRINTER_PROFILE_4000;
	} else if (strPrinterName == _T("ASK-2000")) {
		strPath += DEFAULT_PRINTER_PROFILE_2000;
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	} else if (strPrinterName == _T("ASK-4000A")) {
		strPath += DEFAULT_PRINTER_PROFILE_4000A;
#endif
#ifndef RET_VER266	// takanaka addition 2008/10/09 Ver.2.6.8
	} else if (strPrinterName == _T("ASK-2500")) {
		strPath += DEFAULT_PRINTER_PROFILE_2500;
#endif
	} else {
		strPath = _T("");	
	}

	m_pIsplInfo->fAuto = TRUE;
	m_pIsplInfo->fRedEye = FALSE;
	m_pIsplInfo->fMarker = FALSE;
	m_pIsplInfo->iColorC = 0;
	m_pIsplInfo->iColorM = 0;
	m_pIsplInfo->iColorY = 0;
	m_pIsplInfo->iBright = 0;
	m_pIsplInfo->iContrast = 0;
	m_pIsplInfo->iMonotone = 0;
	m_pIsplInfo->iSetupType = 0;
	_tcscpy(m_pIsplInfo->wszOutputProfile, strPath);
}

#ifndef RET_VERSION_261	// nakashima addition 2007/10/11 Ver.2.6.2
void CImgSetupDlg::Set3dFilePath(int nPrintMode)
{
	CString	strPath, strPrinterName;

	// Default data file path for 3DLUT.
	GetExePath(strPath);

	// 2005/12/16 Ver.2.0.0 Switch the data file
	m_pPrinter->GetProductName(strPrinterName);
	if (strPrinterName == _T("ASK-1500")) {
		strPath += DEFAULT_PRINTER_PROFILE_1500;
	} else if (strPrinterName == _T("ASK-4000")) {
		strPath += DEFAULT_PRINTER_PROFILE_4000;
	} else if (strPrinterName == _T("ASK-2000")) {
		if(nPrintMode) {
			strPath += HQ_PRINTER_PROFILE_2000;
		}
		else {
			strPath += DEFAULT_PRINTER_PROFILE_2000;
		}
	} else if (strPrinterName == _T("ASK-4000A")) {
		strPath += DEFAULT_PRINTER_PROFILE_4000A;
#ifndef RET_VER266	// takanaka addition 2008/10/09 Ver.2.6.8
	} else if (strPrinterName == _T("ASK-2500")) {
#ifndef RET_VER268	// takanaka addition 2009/04/09 Ver.2.7.0
		if(nPrintMode){
			strPath += HQ_PRINTER_PROFILE_2500;
		}
		else {
#endif
			strPath += DEFAULT_PRINTER_PROFILE_2500;
#ifndef RET_VER268	// takanaka addition 2009/04/09 Ver.2.7.0
		}
#endif
#endif
	} else {
		strPath = _T("");	
	}

	_tcscpy(m_pIsplInfo->wszOutputProfile, strPath);
}
#endif