/************************************************************/
/*															*/
/*	File :	ImgSetupDlg.h									*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#ifndef __IMGSETUPDLG_H__
#define __IMGSETUPDLG_H__


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Printer.h"

#define	COLOR_MIN	-9
#define	COLOR_MAX	9


class CImgSetupDlg : public CDialog
{
public:
	CImgSetupDlg(CWnd* pParent = NULL);

	BOOL IsDlgCreate() { return m_fCreate; }

	void SetIsplInfo(ISPL_INFO* pIsplInfo){ m_pIsplInfo = pIsplInfo; }// 2005/12/05 Ver.1.7.1
	void SetPrinter(CPrinter* pPrinter){m_pPrinter = pPrinter;}// 2005/12/16 Ver.2.0.0

	void SetDefaultParam();

#ifndef RET_VERSION_261	// nakashima addition 2007/10/11 Ver.2.6.2
	void Set3dFilePath(int nPrintMode);
#endif

	//{{AFX_DATA(CImgSetupDlg)
	enum { IDD = IDD_IMG_SETUP_DLG };
	CButton	m_check_redeye;
	CButton	m_check_auto;
	CSliderCtrl	m_slider_Y;
	CSliderCtrl	m_slider_M;
	CSliderCtrl	m_slider_C;
	CSliderCtrl	m_slider_Contrast;
	CSliderCtrl	m_slider_Brightness;
	CEdit	m_edit_Y;
	CEdit	m_edit_M;
	CEdit	m_edit_C;
	CEdit	m_edit_PrinterProfile;
	CEdit	m_edit_Contrast;
	CEdit	m_edit_Brightness;
	CComboBox	m_combo_type;
	CComboBox	m_combo_monotone;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CImgSetupDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CImgSetupDlg)
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	virtual BOOL OnInitDialog();
	afx_msg void OnSetPrinterProfile();
	afx_msg void OnClearPrinterProfile();
	afx_msg void OnCheckRedeye();
	afx_msg void OnDefault();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	void GetGUI();
	void SetGUI(BOOL fInit);
	void SetEditboxInt(CEdit &edit, int num, BOOL fZero);
	int	 GetEditboxInt(CEdit &edit);

	void EnableRedEye(BOOL fEnable);

	BOOL GetExePath(CString &strPath);

	BOOL		m_fCreate;
	CPrinter*	m_pPrinter;	// 2005/12/16 Ver.2.0.0
	ISPL_INFO*	m_pIsplInfo;// 2005/12/05 Ver.1.7.1
};

//{{AFX_INSERT_LOCATION}}

#endif // __IMGSETUPDLG_H__
