/************************************************************/
/*															*/
/*	File :	LoadImg.h										*/
/*															*/
/*	TA Printer SDK Sample Program							*/
/*		Load image library "LoadImg.lib" Ver.1.1.0			*/
/*		header file											*/
/*															*/
/*	Copyright (C) 2001-2002 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#ifndef __LOADIMG_H__
#define __LOADIMG_H__


#include <Windows.h>


#ifdef __cplusplus
extern "C" {
#endif


/********************************************************************************/
/*																				*/
/*	This library use procedure													*/
/*																				*/
/*		1.	Call LOADIMG_Init() function to initialize library.					*/
/*		2.	Call LOADIMG_Load() function to load 24Bpp file.					*/
/*		3.	When the use of DIB loaded by LOADIMG_Load() is over, free memory	*/
/*			by calling GlobalFree() Windows API.								*/
/*		4.	Call LOADIMG_Finish() function to finish use library.				*/
/*																				*/
/*	Notes																		*/
/*																				*/
/*		1.	When using this library from program, indicate linker option		*/
/*			/NODEFAULTLIB:"Libc.lib" .											*/
/*		2.	Program using this library has to be indicate "8 byte (default)" to	*/
/*			alignment of structure member.										*/
/*																				*/
/********************************************************************************/



/************************************************/
/*                                              */
/*  Function prototype							*/
/*                                              */
/************************************************/


/********************************************************************************/
/* FunctionName : LOADIMG_Init                                                  */
/* FunctionType : void LOADIMG_Init(void);                                      */
/* Arguments    : void;                                                         */
/* ReturnValue  : void;                                                         */
/* Description  : Initialize library.                                           */
/* Notes        :                                                               */
/********************************************************************************/
void WINAPI LOADIMG_Init(void);


/********************************************************************************/
/* FunctionName : LOADIMG_Load                                                  */
/* FunctionType : DWORD LOADIMG_Load(PCSTR ImageFilePath, HGLOBAL *phDib,		*/
/*									PBITMAPINFOHEADER pBih);                    */
/* Arguments    : ImageFilePath;												*/
/*							[IN]  Full path of 24Bpp BMP file .					*/
/*				: phDib;	[OUT] Global memory handle of loaded BMP as 24 Bpp	*/
/*							      DIB (after BITMAPINFOHEADER).					*/
/*				: pBih;		[OUT] BITMAPINFOHEADER of loaded BMP as 24 Bpp DIB.	*/
/* ReturnValue  : DWORD;                                                        */
/* Description  : Load 24 Bpp BMP file.	                                        */
/* Notes        : 1. Memory for loaded DIB is allocated in this function.		*/
/*				: 2. Access to loaded DIB by calling GlobalLock() Windows API.	*/
/*				: 3. When the use of DIB is over, it is necessary to free		*/
/*				     memory by calling GlobalFree() Windows API.				*/
/*				  4. If not need DIB handle, set NULL to phDib.					*/
/*				  5. If not need BITMAPINFOHEADER, set NULL to pBih.			*/
/********************************************************************************/
DWORD WINAPI LOADIMG_Load(PCSTR ImageFilePath, HGLOBAL *phDib, PBITMAPINFOHEADER pBih);

/* LOADIMG_Load() error codes	*/
#define LOADIMG_OK								0x00000000	/* O.K. Succeeded in loading BMP.			*/
#define LOADIMG_ERR_NOT_INIT_LIB				0x20000001	/* Yet LOADIMG_Init() is not called.		*/
#define LOADIMG_ERR_FILE_NOT_FOUND				0x20000002	/* Indicated file is not found.				*/
#define LOADIMG_ERR_FILE_READ					0x20000003	/* Failed to read indicated file.			*/
#define LOADIMG_ERR_MEMORY_ALLOC				0x20000004	/* Fail to allocate memory for loaded DIB. 	*/
#define LOADIMG_ERR_NO_SUPPORT_FORMAT			0x20000005	/* Indicated file is not 24Bpp BMP file.	*/


/********************************************************************************/
/* FunctionName : LOADIMG_Finish                                                */
/* FunctionType : void LOADIMG_Finish(void);                                    */
/* Arguments    : void;                                                         */
/* ReturnValue  : void;                                                         */
/* Description  : Finish use library.                                           */
/* Notes        :                                                               */
/********************************************************************************/
void WINAPI LOADIMG_Finish(void);



#ifdef __cplusplus
}
#endif


#endif /* #ifndef __LOADIMG_H__	*/
