#ifndef __MDPB_H
#define __MDPB_H


#ifdef	__cplusplus
extern "C" {
#endif


#ifdef MDPB_EXPORTS	/* in DLL */
#define DPB_API __declspec(dllexport)
#else				/* in APP */
#define DPB_API __declspec(dllimport)
#endif

#define Error	int
#define U16		unsigned short

#ifndef _EXPORTS
//DPB Status
enum DPD_sts{

	READY,				//
	READY1,				//
	PRINTING,			//
	INITIALIZING,		//
	BUFFER_FULL,		//
	TRANS_DATA,			//
	RECOVERY,			//

	PAPER_END = 10,		//
	RIBBON_END,			//
	PAPER_DOOR_OPEN,	//
	RIBBON_DOOR_OPEN,	//
	MEDIA_MISS_MATCH,	//

	PAPER_JAM = 20,		//
	RIBBON_ERROR,		//
	HARDWARE_ERROR,		//
	SYSTEM_ERROR,		//
	COMMAND_ERROR,		//
	PARAMETER_ERROR,	//
	TRANS_ERROR,		//
	INTERFACE_ERROR,	//

	NO_PRNTR = 30		//
};

//result
enum err{

	GOOD,				//
	TRANSFER_ERROR,		//
	RESPONSE_ERROR,		//
	MEMORY_E,			//
	NO_PRINTER,			//
	PRINTER_OPEN_E,		//
	START_DOC_E,		//
	SIZE_ERROR,			//
	PRINTER_BUSY,		//
	SET_PARAM_ERROR,	//
	RESET_ERROR,		//
	PRINTER_BUFFER_FULL	//
};

// DPB Status2
enum state{

	NONE,				//
	LAMI,				//
	YELLOW,				//
	REV_STATUS1,		//
	MAGENTE,			//
	REV_STATUS2,		//
	CYAN,				//
	INITIALIZE = 7		//
};

struct tdpb {

	U16		Resolution;		// DPI
	U16		ColorType;		// 0x03:Full color
	U16		DataType;		// 0x02:RGB
	U16		MaxImageSizeX;	// 
	U16		MaxImageSizeY; 	// 
};

struct ttmp {

	U16		Head;			// x10
	U16		Room;			// x10
};

struct tinfo {

	U16		Printing;		// 
	U16		PrintQuantity;	// 
	U16		CurrentPrint;	// 
};

struct tfirmhis {

	char			Version[35];	//
	char			Date[11];		//
	unsigned  int	iCount;			//
};

struct tMCData {

	char			MCDataName[10];	//
	int				Value;			//
	int				Length;			//
};
#endif

enum ss_cmd {
	DM1RBNONN,			//
	DM1RBNOFF,			//

	PM1PAPONP,			//
	PM1PAPONMMS,		//
	PM1PAPONPMS,		//
	PM1PAPONM,			//
	PM1PAPOFF,			//

	DM1CUTONN,			//

	DM1HEDONN,			//
	DM1HEDOND,			//
	DM1HEDONP,			//
	DM1HEDONM,			//
	DM1HEDSET,			//

	DM1ROLONP,			//
	DM1ROLONM,			//

	FN1MECONN,			//
	FN1MECOFF,			//

	PW1MECONN,			//
	PW1MECOFF,			//

	FN1HEDONN,			//
	FN1HEDOFF,			//
	
	DM1RBNRWD,
	DM1RBNONM,
	DM1RBNONP,

	SSCMD_END
};

enum rd_cmd {
	LS1MGO,				//
	LS2MGO,				//
	LS1HED,				//
	LS2HED,				//
	LS3HED,				//
	LS1ROL,				//
	LS1HDR,				//
	LS1CUT,				//
	LS1PAP,				//
	LS2PAP,				//

	RMARK1,				//
	RMARK2,				//
	RMARK3,				//
	RMARK4,				//

	HDTEMP,				//
	RMTEMP,				//

	RDCMD_END
};

// Picture size
#define Size_L			4948992			//1536x1074x3
#define Size_A6			6749088			//1832x1228x3
#define Size_2L			9815040			//1536x2130x3
#define Size_68			13366272		//1832x2432x3
#define Size_A6x2		13696032		//1832x2492x3
#define Size_A5			15103008		//1832x2748x3

// 
#define Size_8x10		22318608		//2444x3044x3
#define Size_8x12		26717808		//2444x3644x3

DPB_API Error	Get_DPB_Status(int *Status);
DPB_API Error	Send_Image_Data(unsigned int Size, char *ImageData);
DPB_API Error	Start_Print(void);
DPB_API int		Get_DLL_Version(void);

DPB_API	Error	mDPB_Init(int *pNumberOfPrinters);
DPB_API	Error	mDPB_Init_Not_Semaphore(int *pNumberOfPrinters);
DPB_API	Error	mDPB_Get_Status(int iPrinterID, int *Status);
DPB_API	Error	mDPB_Get_StatusEx(int iPrinterID, char StatusBuffer[]);
DPB_API	Error	mDPB_Send_Image_Data(int iPrinterID, unsigned int Size, char *ImageData, HWND hWnd, UINT Msg);
DPB_API	Error	mDPB_Send_Image_Data_And_Print(int iPrinterID, unsigned int Size, char *ImageData, HWND hWnd, UINT Msg);
DPB_API	Error	mDPB_Send_Image_Data_Plus(int iPrinterID, unsigned int Size, char *ImageData, 
										  HWND hWnd, UINT Msg, HWND hWnd2, UINT Msg2);
DPB_API	Error	mDPB_Send_Image_Data_And_Print_Plus(int iPrinterID, unsigned int Size, char *ImageData, 
													HWND hWnd, UINT Msg, HWND hWnd2, UINT Msg2);
DPB_API	Error	mDPB_Get_Thread_Status(int iPrinterID, int *Status);
DPB_API	Error	mDPB_Start_Print(int iPrinterID, HWND hWnd, UINT Msg);
DPB_API Error	mDPB_Abort(int iPrinterID);

DPB_API Error	mDPB_GetVersion(int iPrinterID, char Version[]);
DPB_API Error	mDPB_GetPrintCount(int iPrinterID, unsigned int *Count);
DPB_API Error	mDPB_SetPrintQuantity(int iPrinterID, int Quantity);
DPB_API Error	mDPB_SendParameter(int iPrinterID, int Width, int Height);
DPB_API	Error	mDPB_nSendImageData(int iPrinterID, unsigned int Size, char *ImageData, HWND hWnd, UINT Msg);
DPB_API	Error	mDPB_nSendImageDataPlus(int iPrinterID, unsigned int Size, char *ImageData, 
										HWND hWnd, UINT Msg, HWND hWnd2, UINT Msg2);
DPB_API Error	mDPB_StopPrint(int iPrinterID);
DPB_API Error	mDPB_ResetPrinter(int iPrinterID);
DPB_API Error	mDPB_ResetPrinter2(int iPrinterID, HWND hWnd, UINT Msg);
DPB_API Error	mDPB_GetPrinterID(int iPrinterID[]);

DPB_API	Error	DPB_GetAllStatus(int Status[]);
DPB_API Error	DPB_SetUnsharp(int iPrinterID, int Unsharp);
DPB_API Error	DPB_SetRange(int iPrinterID, int Range);
DPB_API Error	DPB_SetRef(int iPrinterID, int Ref);
DPB_API Error	DPB_SetWeight(int iPrinterID, double Weight);

DPB_API Error	mDPB_GetParameter(int iPrinterID, int *Width, int *Height);
DPB_API Error	mDPB_ReadMCdata(int iPrinterID, char *FileName);
DPB_API Error	mDPB_ReadMCdata2(int iPrinterID, struct tMCData pMCData[]);
DPB_API Error	mDPB_GetMaxMC(int iPrinterID, int *Max);
DPB_API Error	mDPB_GetMCdata(int iPrinterID, char *MCdata, int *Value);
DPB_API Error	mDPB_WriteMCdata(int iPrinterID, char MCdata[]);

DPB_API Error	mDPB_SaveMCdata(int iPrinterID);
DPB_API Error	mDPB_GetInquiry(int iPrinterID, struct tdpb *pDPB);
DPB_API Error	mDPB_GetTemperature(int iPrinterID, struct ttmp *pTemp);
DPB_API Error	mDPB_GetProInfo(int iPrinterID, struct tinfo *pInfo);
DPB_API Error	mDPB_ActuatorAction(int iPrinterID, int ActuatorAction);
DPB_API Error	mDPB_SensorState(int iPrinterID, int Sensor, int *State);
DPB_API Error	mDPB_CutPaper(int iPrinterID, unsigned long Length);

DPB_API Error	DPB_SetRed(int iPrinterID, int Red);
DPB_API Error	DPB_SetGreen(int iPrinterID, int Green);
DPB_API Error	DPB_SetBlue(int iPrinterID, int Blue);
DPB_API Error	DPB_SetBrightness(int iPrinterID, int Brightness);
DPB_API Error	DPB_SetContrast(int iPrinterID, int Contrast);
DPB_API Error	DPB_SetSaturation(int iPrinterID, int Saturation);
DPB_API Error	DPB_SetSharpness(int iPrinterID, int Sharpness);

DPB_API Error	DPB_SetColorCorrection(int iPrinterID, int Correction);

DPB_API Error	DPB_SetPrintMode(int iPrinterID, int iDPI, int iPrintMode);
DPB_API Error	mDPB_StartMultiPrint(int iPrinterID);
DPB_API Error	mDPB_EndMultiPrint(int iPrinterID);
DPB_API Error	mDPB_GetPrinterKind(int iPrinterID, int *iKind);

DPB_API Error	DPB_SetMultiChop(int iPrinterID, int MultiChop);
DPB_API Error	mDPB_GetTakeupDiameter(int iPrinterID, int *iLength);
DPB_API Error	mDPB_GetRibbonCount(int iPrinterID, int *iCount);
DPB_API Error	mDPB_SetRibbonCount(int iPrinterID, int iCount);
DPB_API Error	mDPB_GetFirmHistory(int iPrinterID, struct tfirmhis pFirmHistory[]);
DPB_API Error	mDPB_GetHeadCount(int iPrinterID, unsigned int *iCount);
DPB_API Error	mDPB_SetHeadCount(int iPrinterID, unsigned int iCount);
DPB_API Error	mDPB_ResetHeadCount(int iPrinterID);
DPB_API Error	mDPB_GetCutterCount(int iPrinterID, unsigned int *iCount);
DPB_API Error	mDPB_SetCutterCount(int iPrinterID, unsigned int iCount);
DPB_API Error	mDPB_ResetCutterCount(int iPrinterID);

DPB_API Error	mDPB_SetPrinterID(int iOldPrinterID, int iNewPrinterID);
DPB_API Error	mDPB_GetSerialNo(int iPrinterID, char pSerialNo[]);

DPB_API Error	DPB_SetDebugMode(int iMode, char LogPath[]);

#ifdef	__cplusplus
}
#endif



#endif /* __MDPB_H */
