/************************************************************/
/*															*/
/*	File :	PrintDlg.cpp									*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

// Relase Note
// Ver.2.4.2	2007/03/30	K}`  2K vgɑΉ (j[ǉ)
//							2K  K}` vgɑΉ (j[ǉ)


#include "stdafx.h"
#include "SDKSample.h"
#include "PrintDlg.h"
#include "Printer.h"
#include "LoadImg.h"
#include "DoPrint.h"
#include "Encode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



// For enableControl() EnableMode parameter
#define	ENABLE_READY_NO_IMAGE			(ENABLE_LIST_DND | ENABLE_BROWS | ENABLE_CLOSE)
#define	ENABLE_READY_HAVE_IMAGE			(ENABLE_READY_NO_IMAGE | ENABLE_START_PRINT)
#define	ENABLE_READY_SEL_IMAGE			(ENABLE_READY_HAVE_IMAGE | ENABLE_CLEAR)
#define	ENABLE_PRINTING					(ENABLE_STOP_PRINT)

#define	ENABLE_LIST_DND					0x00000100
#define	ENABLE_BROWS					0x00000010
#define	ENABLE_CLEAR					0x00000008
#define	ENABLE_START_PRINT				0x00000004
#define	ENABLE_STOP_PRINT				0x00000002
#define	ENABLE_CLOSE					0x00000001


// Struct for printer paper size information table
typedef struct {
	UINT	DispStrId;		// Display name resource ID of StringTable
	POINT	PaperSize;		// Paper size (x : width, y : height) [pixel]
	short	MediaType;		// Paper type (MCP_PRINTERINFO.nMediaType)
	BOOL	fUnknown;		// Unknown paper size?
} PRINTER_PAPERSIZE_INFO, *PPRINTER_PAPERSIZE_INFO;

// Printer paper size information table
static PRINTER_PAPERSIZE_INFO	PrinterPaperSizeTbl[] = {
	// DispStrId				PaperSize.x					PaperSize.y					MediaType					fUnknown
// for COPAL
	{IDS_PAPER_SIZE_UNKNOWN,	{0,							0,							},	MCP_MEDIA_TYPE_UNKNOWN,	TRUE,	},
	{IDS_PAPER_SIZE_NONE,		{0,							0,							},	MCP_MEDIA_TYPE_NONE,	TRUE,	},
	{IDS_PAPER_SIZE_L,			{MCP_PAPER_WIDTH_L,			MCP_PAPER_HEIGHT_L,			},	MCP_MEDIA_TYPE_L,		FALSE,	},
	{IDS_PAPER_SIZE_K,			{MCP_PAPER_WIDTH_K,			MCP_PAPER_HEIGHT_K,			},	MCP_MEDIA_TYPE_K,		FALSE,	},
	{IDS_PAPER_SIZE_2L,			{MCP_PAPER_WIDTH_2L,		MCP_PAPER_HEIGHT_2L,		},	MCP_MEDIA_TYPE_2L,		FALSE,	},
	{IDS_PAPER_SIZE_6X8,		{MCP_PAPER_WIDTH_6X8,		MCP_PAPER_HEIGHT_6X8,		},	MCP_MEDIA_TYPE_6X8_A5,	FALSE,	},
	{IDS_PAPER_SIZE_A5,			{MCP_PAPER_WIDTH_A5,		MCP_PAPER_HEIGHT_A5,		},	MCP_MEDIA_TYPE_6X8_A5,	FALSE,	},
	{IDS_PAPER_SIZE_K_MULTI,	{MCP_PAPER_WIDTH_K,			MCP_PAPER_HEIGHT_K,			},	MCP_MEDIA_TYPE_6X8_A5,	FALSE,	},
	{IDS_PAPER_SIZE_8X10,		{MCP_PAPER_WIDTH_8X10,		MCP_PAPER_HEIGHT_8X10,		},	MCP_MEDIA_TYPE_8X10,	FALSE,	},
	{IDS_PAPER_SIZE_8X12,		{MCP_PAPER_WIDTH_8X12,		MCP_PAPER_HEIGHT_8X12,		},	MCP_MEDIA_TYPE_8X12,	FALSE,	},
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	{IDS_PAPER_SIZE_8X4_3DIV,	{MCP_PAPER_WIDTH_8X12,		MCP_PAPER_HEIGHT_8X4,		},	MCP_MEDIA_TYPE_8X12,	FALSE,	},
	{IDS_PAPER_SIZE_A4,			{MCP_PAPER_WIDTH_A4,		MCP_PAPER_HEIGHT_A4,		},	MCP_MEDIA_TYPE_A4,		FALSE,	},
	{IDS_PAPER_SIZE_A5_MULTI,	{MCP_PAPER_WIDTH_A5_4000A,	MCP_PAPER_HEIGHT_A5_4000A,	},	MCP_MEDIA_TYPE_A4,		FALSE,	},
#endif
#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
//	{IDS_PAPER_SIZE_NOR_MUL,{MCP_PAPER_WIDTH_K,				MCP_PAPER_HEIGHT_6X8,		},	MCP_MEDIA_TYPE_6X8_A5,	FALSE,	},
//	{IDS_PAPER_SIZE_NOR_MUL_2,{MCP_PAPER_WIDTH_K,			MCP_PAPER_HEIGHT_A5,		},	MCP_MEDIA_TYPE_6X8_A5,	FALSE,	},
//	{IDS_PAPER_SIZE_MUL_NOR,{MCP_PAPER_WIDTH_K,				MCP_PAPER_HEIGHT_K,			},	MCP_MEDIA_TYPE_6X8_A5,	FALSE,	},
//	{IDS_PAPER_SIZE_MUL_NOR_2,{MCP_PAPER_WIDTH_K,			MCP_PAPER_HEIGHT_K,			},	MCP_MEDIA_TYPE_6X8_A5,	FALSE,	},
#endif
};

// Default :
//#define	PRINTER_PAPERSIZE_DEFAULT_INDEX		0
#define	PRINTER_PAPERSIZE_DEFAULT_INDEX		2

#define SHARPNESS_DEFAULT	MCP_SHARPNESS_DEFAULT//2005.6.23 mochida 
#define GAMMA_DEFAULT		100

// Number for print image list control each column
#define	NUM_OF_COLUMN					5
#define	COLUMN_IMAGE_NO					0
#define	COLUMN_FILENAME					1
#define	COLUMN_IMAGE_SIZE				2
#define	COLUMN_COPIES					3
#define	COLUMN_STATUS					4


// For print image list control display
static UINT		columnHeader[NUM_OF_COLUMN][3] = {
	// Title,					Width,	Style
	{IDS_IMAGE_COLUMN_NO,		30,		LVCFMT_CENTER,	},
	{IDS_IMAGE_COLUMN_FILENAME,	140,	LVCFMT_LEFT,	},
	{IDS_IMAGE_COLUMN_SIZE,		80,		LVCFMT_CENTER,	},
	{IDS_IMAGE_COLUMN_COPIES,	50,		LVCFMT_CENTER,	},
	{IDS_IMAGE_COLUMN_STATUS,	90,		LVCFMT_CENTER,	},
};


// Window messages
// For SDK callback function called
// Modefy messege IDs	// 2004/12/02 Ver.0.8.0
#define	WM_CALLBACK_BASE				(WM_USER + 0x100)
#define	WM_CALLBACK_READY				(WM_CALLBACK_BASE + STATUS_READY)
#define	WM_CALLBACK_IMAGESETUP			(WM_CALLBACK_BASE + STATUS_IMAGESETUP)
#define	WM_CALLBACK_WAITING				(WM_CALLBACK_BASE + STATUS_WAITING)
#define	WM_CALLBACK_SENDING				(WM_CALLBACK_BASE + STATUS_SENDING)
#define	WM_CALLBACK_SPOOLED				(WM_CALLBACK_BASE + STATUS_SPOOLED)
#define	WM_CALLBACK_PRINTING			(WM_CALLBACK_BASE + STATUS_PRINTING)
#define	WM_CALLBACK_COMPLETE			(WM_CALLBACK_BASE + STATUS_COMPLETE)
#define	WM_CALLBACK_RECOVERY			(WM_CALLBACK_BASE + STATUS_RECOVERY)
#define	WM_CALLBACK_CANCEL				(WM_CALLBACK_BASE + STATUS_CANCEL)
#define	WM_CALLBACK_ERROR				(WM_CALLBACK_BASE + STATUS_ERROR)
#define	WM_CALLBACK_MAX					(WM_CALLBACK_BASE + 0x7000)

#define	WM_SETFOCUS_STARTPRINT			(WM_CALLBACK_MAX + 1)
#define	WM_UPDATE_REMAIN_COPIES			(WM_CALLBACK_MAX + 2)

// Struct for dialog information table
typedef struct {
	HANDLE		hPrinter;
	HWND		hDlg;
} DLG_INFO;

// Dialog information table
static DLG_INFO		g_dlgTbl[MAX_PRINTER_CNT];

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
CPrinter*	g_pPrinter[MAX_PRINTER_CNT];
#else
CPrinter*	g_pPrinter;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrintDlg dialog

CPrintDlg::CPrintDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPrintDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrintDlg)
	m_intPrintMode = -1;
	m_copiesInt = 0;
	m_strRemainCopies = _T("");
	m_chkSharpness = FALSE;
	m_intSharpness = 0;
	m_chkImageSetup = FALSE;
	m_chk1DLUT = FALSE;
	m_chk3DLUT = FALSE;
	m_xv3dlut = _T("");
	//}}AFX_DATA_INIT

	m_pPrinter		= NULL;
	m_create		= FALSE;
	m_fCancel		= FALSE;
	m_fPrinting		= FALSE;

	initPrintImageTbl();

	m_pDoPrint		= NULL;
}


///////////////////////////////////////////////////////////////////////////////
//
//	CPrintDlg class public method
//


// Set this dialog display position.
// (WndPos : Windows left top position.)
void CPrintDlg::SetWindowPosition(POINT WndPos)
{

	m_wndPos = WndPos;

}


// Notify to this dialog ending print.
// (fSuccess : TRUE = print ended normally.)
void CPrintDlg::NotifyPrintEnd(BOOL fSuccess)
{
	POSITION	pos;

	// Check selected item exist.
	pos = m_printImageList.GetFirstSelectedItemPosition();
	if (pos != NULL) {
		enableControl(ENABLE_READY_SEL_IMAGE);
	} else {
		enableControl(ENABLE_READY_HAVE_IMAGE);
	}

	// Enable "Start print" button and set focus.
	::PostMessage(this->m_hWnd, WM_SETFOCUS_STARTPRINT, 0, 0);

	m_fPrinting = FALSE;

}


// Let Update display of printer remain copies.
void CPrintDlg::LetUpdatePrinterRemainPaperCopies()
{

	// Update display of printer remain copies.
	::PostMessage(this->m_hWnd, WM_UPDATE_REMAIN_COPIES, 0, 0);

}

void CPrintDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrintDlg)
	DDX_Control(pDX, IDC_CHECK_AUTO_RECOVERY, m_check_AutoRecovery);
	DDX_Control(pDX, IDC_SLIDER_SHARPNESS, m_sliderSharpness);
	DDX_Control(pDX, IDC_PAPERTYPE_COMBO, m_paperTypeCmb);
	DDX_CBIndex(pDX, IDC_PRINT_MODE_COMBO, m_intPrintMode);
	DDX_Control(pDX, IDC_PRINT_IMAGE_LIST, m_printImageList);
	DDX_Control(pDX, IDC_VOLUME_SPIN, m_volumeSpin);
	DDX_Text(pDX, IDC_VOLUME_EDIT, m_copiesInt);
	DDX_Text(pDX, IDC_STATIC_REMAIN_COPIES, m_strRemainCopies);
	DDX_Check(pDX, IDC_CHECK_SHARPNESS, m_chkSharpness);
	DDX_Text(pDX, IDC_EDIT_SHARPNESS, m_intSharpness);
	DDX_Check(pDX, IDC_CHECK_IMAGE_SETUP, m_chkImageSetup);
	DDX_Check(pDX, IDC_CHECK_1DLUT, m_chk1DLUT);
	DDX_Check(pDX, IDC_CHECK_3DLUT, m_chk3DLUT);
	DDX_CBString(pDX, IDC_3DLUT_COMBO, m_xv3dlut);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPrintDlg, CDialog)
	//{{AFX_MSG_MAP(CPrintDlg)
	ON_BN_CLICKED(IDC_BROWS_BUTTON, OnBrowsButton)
	ON_BN_CLICKED(IDC_CLEAR_BUTTON, OnClearButton)
	ON_BN_CLICKED(IDC_STOP_PRINT, OnStopPrint)
	ON_WM_DROPFILES()
	ON_BN_CLICKED(IDC_START_PRINT, OnStartPrint)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_PRINT_IMAGE_LIST, OnItemchangedPrintImageList)
	ON_BN_CLICKED(IDC_CHECK_SHARPNESS, OnCheckSharpness)
	ON_WM_HSCROLL()
	ON_EN_KILLFOCUS(IDC_EDIT_SHARPNESS, OnKillfocusEditSharpness)
	ON_BN_CLICKED(IDC_IMG_SETUP_BUTTON, OnImgSetupButton)
	ON_BN_CLICKED(IDC_CHECK_IMAGE_SETUP, OnCheckImageSetup)
	ON_BN_CLICKED(IDC_CREATE, OnCreateButton)
	ON_BN_CLICKED(IDC_DELETE, OnDeleteButton)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_PRINTER_INFO, OnPrinterInfo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPrintDlg message handler


// Initialize print image table
void CPrintDlg::initPrintImageTbl()
{

	ZeroMemory(m_printImageTbl, sizeof(m_printImageTbl));
	m_printImageCnt = 0;
}


// Set print image list information.
BOOL CPrintDlg::setPrintImageListInfo(int ImageIndex, PRINT_IMAGE_INFO PrintImageListInfo, BOOL fAdd, BOOL fClear)
{

	if (ImageIndex >= PRINT_IMAGE_LIST_MAX_COUNT) {
		return	FALSE;
	}
	if (!fAdd && ImageIndex >= m_printImageCnt) {
		return	FALSE;
	}

	setPrintImageListDisp(ImageIndex, PrintImageListInfo, fClear);

	// Set image list information to table.
	if ( _tcscmp(PrintImageListInfo.FilePath, _T("")) != 0 ) {
		_tcscpy(m_printImageTbl[ImageIndex].FilePath, PrintImageListInfo.FilePath);
	}
	if ((PrintImageListInfo.ImageSize.x != 0) && (PrintImageListInfo.ImageSize.y != 0)) {
		m_printImageTbl[ImageIndex].ImageSize = PrintImageListInfo.ImageSize;
	}
	if (PrintImageListInfo.Status != STATUS_COMPLETE) {
		m_printImageTbl[ImageIndex].Copied = PrintImageListInfo.Copied;
		m_printImageTbl[ImageIndex].Copies = PrintImageListInfo.Copies;
	}
	if (PrintImageListInfo.Status != STATUS_NON) {
		m_printImageTbl[ImageIndex].Status = PrintImageListInfo.Status;
	}

	if (fAdd) {
		m_printImageCnt++;
	}
	if (fClear) {
		m_printImageCnt--;
	}

	return	TRUE;
}

// Get print image list information.
BOOL CPrintDlg::getPrintImageListInfo(int ImageIndex, PPRINT_IMAGE_INFO pPrintImageListInfo)
{

	if ((ImageIndex >= PRINT_IMAGE_LIST_MAX_COUNT) || (ImageIndex >= m_printImageCnt)) {
		return	FALSE;
	}

	*pPrintImageListInfo = m_printImageTbl[ImageIndex];

	return	TRUE;
}

// Enable control (Image list control, "Brows.", "Clear", "Start print",
// "Stop print" and "Close" button).
// (EnableMode : enable controls flag. (ENABLE_XXXX) )
void CPrintDlg::enableControl(DWORD EnableMode)
{

	if (EnableMode & ENABLE_LIST_DND) {
		this->DragAcceptFiles(TRUE);
	} else {
		this->DragAcceptFiles(FALSE);
	}
	if (EnableMode & ENABLE_BROWS) {
		GetDlgItem(IDC_BROWS_BUTTON)->EnableWindow(TRUE);
	} else {
		GetDlgItem(IDC_BROWS_BUTTON)->EnableWindow(FALSE);
	}
	if (EnableMode & ENABLE_CLEAR) {
		GetDlgItem(IDC_CLEAR_BUTTON)->EnableWindow(TRUE);
	} else {
		GetDlgItem(IDC_CLEAR_BUTTON)->EnableWindow(FALSE);
	}
	if (EnableMode & ENABLE_START_PRINT) {
		GetDlgItem(IDC_START_PRINT)->EnableWindow(TRUE);
	} else {
		GetDlgItem(IDC_START_PRINT)->EnableWindow(FALSE);
	}
	if (EnableMode & ENABLE_STOP_PRINT) {
		GetDlgItem(IDC_STOP_PRINT)->EnableWindow(TRUE);
	} else {
		GetDlgItem(IDC_STOP_PRINT)->EnableWindow(FALSE);
	}
	if (EnableMode & ENABLE_CLOSE) {
		GetDlgItem(IDCANCEL)->EnableWindow(TRUE);
	} else {
		GetDlgItem(IDCANCEL)->EnableWindow(FALSE);
	}

}

// Set print image list control display.
void CPrintDlg::setPrintImageListDisp(int ImageIndex, PRINT_IMAGE_INFO PrintImageListInfo, BOOL fClear)
{
	int			itemCnt;
	LV_ITEM		lvi;
	CString		dispStr, tmpStr;
	CString		strFilePath, strFileTitle;
	TCHAR		wszTemp[MAX_PATH];

	if (fClear) {
		m_printImageList.DeleteItem(ImageIndex);
		return;
	}

	itemCnt = m_printImageList.GetItemCount();

	if (ImageIndex >= itemCnt) {
		if (ImageIndex == 0) {
			enableControl(ENABLE_READY_HAVE_IMAGE);
		}
		// Add new item to list control.
		lvi.mask = LVIF_TEXT;
		lvi.iItem =  ImageIndex;
		lvi.iSubItem = 0;
		_stprintf(wszTemp, _T("%d"), ImageIndex + 1);
		lvi.pszText = wszTemp;
		m_printImageList.InsertItem(&lvi);
		m_printImageList.SetItemData(lvi.iItem, 0);
	}

	// Set file name (only title).
	if ( _tcscmp(PrintImageListInfo.FilePath, _T("")) != 0 ) {
		GetFileTitle(PrintImageListInfo.FilePath, wszTemp, MAX_PATH);
		m_printImageList.SetItemText(ImageIndex, COLUMN_FILENAME, wszTemp);
	}

	// Set image size.
	if ((PrintImageListInfo.ImageSize.x != 0) && (PrintImageListInfo.ImageSize.y != 0)) {
		dispStr.Format(_T("%d * %d"), PrintImageListInfo.ImageSize.x, PrintImageListInfo.ImageSize.y);
		m_printImageList.SetItemText(ImageIndex, COLUMN_IMAGE_SIZE, dispStr);
	}

	// Set copies.
	if (PrintImageListInfo.Status == STATUS_READY) {
		// ready
		m_printImageList.SetItemText(ImageIndex, COLUMN_COPIES, _T("") );
	} else if ((PrintImageListInfo.Copied != 0) || (PrintImageListInfo.Copies != 0)) {
		dispStr.Format(_T("%d / %d"), PrintImageListInfo.Copied, PrintImageListInfo.Copies);
		m_printImageList.SetItemText(ImageIndex, COLUMN_COPIES, dispStr);
	}

	// Set status display.
	if (PrintImageListInfo.Status != STATUS_NON) {
		UINT	rcId;
		switch (PrintImageListInfo.Status) {
		case STATUS_READY:
		default:
			rcId = IDS_STATUS_READY;
			break;
		case STATUS_IMAGESETUP:
			rcId = IDS_STATUS_IMAGESETUP;
			break;
		case STATUS_WAITING:
			rcId = IDS_STATUS_WAITING;
			break;
		case STATUS_SENDING:
			rcId = IDS_STATUS_SENDING;
			break;
		case STATUS_SPOOLED:
			rcId = IDS_STATUS_SPOOLED;
			break;
		case STATUS_PRINTING:
			rcId = IDS_STATUS_PRINTING;
			break;
		case STATUS_COMPLETE:
			rcId = IDS_STATUS_COMPLETE;
			break;
		case STATUS_RECOVERY:
			rcId = IDS_STATUS_RECOVERY;
			break;
		case STATUS_CANCEL:
			rcId = IDS_STATUS_CANCEL;
			break;
		case STATUS_ERROR:
			rcId = IDS_STATUS_ERROR;
			break;
		}
		dispStr.LoadString(rcId);
		m_printImageList.SetItemText(ImageIndex, COLUMN_STATUS, (LPCTSTR)dispStr);
	}

}

// Initialize dialog display.
BOOL CPrintDlg::OnInitDialog() 
{
	MCP_PRINTER_INFO		printerInfo;

	// Set dialog position.
	SetWindowPos(&wndNoTopMost, m_wndPos.x, m_wndPos.y, 0, 0, SWP_NOSIZE);

	CDialog::OnInitDialog();

	enableControl(ENABLE_READY_NO_IMAGE);

	// Resister this dialog information to dialog table.
	g_dlgTbl[m_pPrinter->GetPrinterNo()].hPrinter	= m_pPrinter->GetHandle();
	g_dlgTbl[m_pPrinter->GetPrinterNo()].hDlg		= this->m_hWnd;

	m_create = TRUE;

	// Get printer device information. 
	if (!m_pPrinter->GetPrinterInfo(&printerInfo)) {
		CWaitCursor		wait;
		// Error : End printer control.
		m_pPrinter->Close();
		EndDialog(0);
		return	FALSE;
	}
	// Display printer information at dialog title.
	setDialogCaption();

	// Get printer remain paper.
	if (!updatePrinterRemainPaperCopies()) {
		CWaitCursor		wait;
		// Error : End printer control.
		m_pPrinter->Close();
		EndDialog(0);
		return	FALSE;
	}

	////////////////////////////////////////////////////////
	// Initialize dialog print setting display.

	// Initialize paper size combo box.
	initPaperSizeCombo(printerInfo.nMediaType);

	// Print copies ( Default : 1 piece )
	m_volumeSpin.SetRange(1, MCP_MAX_COPIES);
	m_copiesInt = 1;

	// Print mode
	// Only for ASK-1500 printer, show "Print mode" combo box.
#ifndef RET_VERSION_261	// nakashima addition 2007/10/11 Ver.2.6.2
	m_intPrintMode = 0;		// "Print speed"

	if((printerInfo.nPrinterId == MCP_PRINTER_ID_ASK4000) 
		|| (printerInfo.nPrinterId == MCP_PRINTER_ID_ASK4000A))
	{
		GetDlgItem(IDC_STATIC_PRINT_MODE)->ShowWindow(SW_HIDE);	// for COPAL
		GetDlgItem(IDC_PRINT_MODE_COMBO)->ShowWindow(SW_HIDE);	// for COPAL
	}

#else
	GetDlgItem(IDC_STATIC_PRINT_MODE)->ShowWindow(SW_HIDE);	// for COPAL
	GetDlgItem(IDC_PRINT_MODE_COMBO)->ShowWindow(SW_HIDE);	// for COPAL
	m_intPrintMode = 0;		// "Print speed"
#endif

	// Auto Recovery 2005/12/08 Ver.1.8.0
	m_check_AutoRecovery.SetCheck(0);

	// ISPL parameter 2005/12/05 Ver.1.7.1
	m_ImgSetupDlg.SetPrinter(m_pPrinter);
	m_ImgSetupDlg.SetIsplInfo(&m_IsplInfo);
	m_ImgSetupDlg.SetDefaultParam();

	// Sharpness
	m_chkSharpness = TRUE;
	m_sliderSharpness.SetRange(MCP_SHARPNESS_MIN, MCP_SHARPNESS_MAX, TRUE);

	switch(printerInfo.nPrinterId){	// 2006/03/30 Ver.2.3.0
	case MCP_PRINTER_ID_ASK1500:
		m_intSharpness = MCP_SHARPNESS_DEFAULT_1500;
		break;
	case MCP_PRINTER_ID_ASK4000:
		m_intSharpness = MCP_SHARPNESS_DEFAULT_4000;
		break;
	case MCP_PRINTER_ID_ASK2000:
		m_intSharpness = MCP_SHARPNESS_DEFAULT_2000;
		break;
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	case MCP_PRINTER_ID_ASK4000A:
		m_intSharpness = MCP_SHARPNESS_DEFAULT_4000A;
		break;
#endif
#ifndef RET_VER266	// takanaka addition 2008/10/09 Ver.2.6.8
	case MCP_PRINTER_ID_ASK2500:
		m_intSharpness = MCP_SHARPNESS_DEFAULT_2500;
		break;
#endif		
	default:
		m_intSharpness = MCP_SHARPNESS_DEFAULT;
		break;
	}
	m_sliderSharpness.SetPos(m_intSharpness);

	// Image Setup	
	m_chkImageSetup = TRUE;// Modify at 2005/12/07 Ver.1.7.1
	m_chk1DLUT = FALSE;// 2005/12/06 Ver.1.7.1
	m_chk3DLUT = TRUE; // 2005/12/06 Ver.1.7.1
	

	// Initialize print image list control.
	initPrintImageListControl();
	initPrintImageTbl();

	// takanaka addition 2009/04/09 Ver.2.7.0
	// Initialize 3dLut Method ComboBox
	m_xv3dlut = LUT_COMBO_SDK;

	UpdateData(FALSE);

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	g_pPrinter[m_pPrinter->GetPrinterNo()] = m_pPrinter;
#else
	g_pPrinter = m_pPrinter;// 2005/07/04
#endif

	return TRUE;
}

// Display printer information at dialog title.
void CPrintDlg::setDialogCaption()
{
	CString		strDisp, strProductName;

	m_pPrinter->GetProductName(strProductName);

	strDisp.Format(_T("Printer No. : %d  ( %s )"), m_pPrinter->GetPrinterNo(), strProductName);

	SetWindowText(strDisp);

}

// Initialize paper size combo box.
void CPrintDlg::initPaperSizeCombo(short MediaType)
{
	int			i, comboIndex = 0, defaultSelIndex = -1;
	CString		tmpStr, dispStr;

	m_paperTypeCmb.ResetContent();

	// Add paper size item to combo box.
	for (i = 0; i < COUNTOF_ARRAY(PrinterPaperSizeTbl); i++) {
		tmpStr.LoadString(PrinterPaperSizeTbl[i].DispStrId);
		if (PrinterPaperSizeTbl[i].fUnknown) {
			dispStr.Format(_T("%s"), tmpStr);
		} else {
			dispStr.Format(_T("%s  (%d * %d)"), tmpStr, PrinterPaperSizeTbl[i].PaperSize.x, PrinterPaperSizeTbl[i].PaperSize.y);
		}
		if (m_paperTypeCmb.AddString(dispStr) != CB_ERR) {
			comboIndex++;
		}
		if (defaultSelIndex == -1) {	// 2005/04/15 Ver.1.0.2
			if (PrinterPaperSizeTbl[i].MediaType == MediaType) {
				defaultSelIndex = i;
			}
		}
	}

	if (defaultSelIndex == -1) {
		defaultSelIndex = PRINTER_PAPERSIZE_DEFAULT_INDEX;
	}

#ifdef RET_VER247	// nakashima delete 2007/06/29 Ver.2.5.0
	// 2005/07/12 Ver.1.4.3
	m_pPrinter->GetProductName(tmpStr);
	if (tmpStr==_T("ASK-4000")) {
		defaultSelIndex = 8;
	}
#endif

	m_paperTypeCmb.SetCurSel(defaultSelIndex);

}


// Initialize print image list control.
void CPrintDlg::initPrintImageListControl()
{
	LV_COLUMN		lvc;
	int				i;
	CString			str;

	// Set column header to list control.
	lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	for (i = 0; i < NUM_OF_COLUMN; i++) {
		lvc.iSubItem = i;
		str.LoadString(columnHeader[i][0]);
		lvc.pszText = (LPTSTR)LPCTSTR(str);
		lvc.cx = columnHeader[i][1];
		lvc.fmt = columnHeader[i][2];
		m_printImageList.InsertColumn(i, &lvc);
	}

	m_printImageList.SetExtendedStyle(LVS_EX_FULLROWSELECT);

}

// Get print setting values set on dialog.
void CPrintDlg::getDialogPrintSetting() 
{
	int		paperTypeIndex;

	UpdateData(TRUE);

	// Paper size
	paperTypeIndex = m_paperTypeCmb.GetCurSel();
	m_paperSize = PrinterPaperSizeTbl[paperTypeIndex].PaperSize;

	// Print copies
	m_printInfo.PrintSetting.wCopies = (WORD)m_copiesInt;

	// Print mode
#ifndef RET_VERSION_261	// nakashima addition 2007/10/11 Ver.2.6.2
	m_printInfo.PrintSetting.nPrintMode = m_intPrintMode;
#else
	m_printInfo.PrintSetting.nPrintMode = MCP_PRINT_MODE_SPEED;	// for COPAL
#endif

	// Color correct parameter
	// Sharpness
	if (m_chkSharpness) {
		m_printInfo.PrintSetting.ColorInfo.nSharpness = m_intSharpness;
	} else {
		m_printInfo.PrintSetting.ColorInfo.nSharpness = MCP_SHARPNESS_NOCORRECT;
	}
}


// Handler at file dropped.
void CPrintDlg::OnDropFiles(HDROP hDropInfo) 
{
	UINT		numOfFiles, i;
	int			imageIndex;
	TCHAR		wszFilePath[_MAX_PATH*2];// 2005/12/06 Ver.1.7.1

	numOfFiles = ::DragQueryFile(hDropInfo, 0xffffffff, NULL, 0);
	for (i = 0; i < numOfFiles; i++) {
		if (m_printImageList.GetItemCount() >= PRINT_IMAGE_LIST_MAX_COUNT) {
			// Yet max count of images resisted to print image list control. 
			AfxMessageBox(IDS_ERR_IMAGE_FULL, MB_OK | MB_ICONSTOP);
			break;
		}
//		::DragQueryFile(hDropInfo, i, filePath, _MAX_PATH);
		::DragQueryFile(hDropInfo, i, wszFilePath, _MAX_PATH);
//		if (!isImageFile(filePath)) {
		if (!isImageFile(wszFilePath)) {
			break;
		}
		imageIndex = m_printImageList.GetItemCount();
//		setImageItem(imageIndex, filePath, TRUE);
		setImageItem(imageIndex, wszFilePath, TRUE);
	}

	CDialog::OnDropFiles(hDropInfo);
}

// Handler at "Browse." button pushed.
void CPrintDlg::OnBrowsButton() 
{
	POSITION	pos;
	int			selItem;
	CString		strFilePath, strCurPath;
	BOOL		modifyFlg = FALSE;
	PRINT_IMAGE_INFO	listItemInfo;

	// Check selected item exist.
	pos = m_printImageList.GetFirstSelectedItemPosition();
	if (pos != NULL) {
		modifyFlg = TRUE;
		selItem = m_printImageList.GetNextSelectedItem(pos);
		getPrintImageListInfo(selItem, &listItemInfo);
		strCurPath = listItemInfo.FilePath;
	} else {
		if (m_printImageList.GetItemCount() >= PRINT_IMAGE_LIST_MAX_COUNT) {
			// Yet max count of images resisted to print image list control. 
			AfxMessageBox(IDS_ERR_IMAGE_FULL, MB_OK | MB_ICONSTOP);
			return;
		}
	}

	// Display common file select dialog.
	CFileDialog		dlg(TRUE, NULL, strCurPath, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
					_T("Image file (*.bmp; *.jpg)|*.JPG;*.jpg;*.BMP;*.bmp||") );
	if (dlg.DoModal() == IDOK) {
		strFilePath = dlg.GetPathName();
		if (isImageFile(strFilePath)) {
			if (modifyFlg) {
				// If selected item exist, change image file.
				setImageItem(selItem, strFilePath, FALSE);
			} else {
				// If selected item not exist, add new image file.
				setImageItem(m_printImageList.GetItemCount(), strFilePath, TRUE);
			}
		}
	}

}

// Set item to print image list control.
//BOOL CPrintDlg::setImageItem(int ImageIndex, PCSTR FilePath, BOOL fAdd)
BOOL CPrintDlg::setImageItem(int ImageIndex, LPCTSTR strFilePath, BOOL fAdd)
{
	PRINT_IMAGE_INFO	printImageListInfo;
	POINT		imageSize;

	UpdateData(TRUE);

	// Get width and height of image.
	if (!getImageSize(strFilePath, &imageSize)) {
		return	FALSE;
	}
	_tcscpy(printImageListInfo.FilePath, strFilePath);
	printImageListInfo.ImageSize	= imageSize;
	printImageListInfo.Copied		= 0;
	printImageListInfo.Copies		= 0;
	printImageListInfo.Status		= STATUS_READY;
	setPrintImageListInfo(ImageIndex, printImageListInfo, fAdd, FALSE);

	return	TRUE;
}

// Check file's extension whether is image file or not.
//BOOL CPrintDlg::isImageFile(PCSTR FilePath)
BOOL CPrintDlg::isImageFile(LPCTSTR FilePath)
{
	CString		path = FilePath;
	int			idx, findIdx;

	path.MakeUpper();
	idx = path.ReverseFind('.');
	findIdx = path.Find(_T("BMP"), idx + 1);
	if (findIdx == -1) {
		findIdx = path.Find(_T("JPG"), idx + 1);
	}

	if (findIdx == -1) {
		AfxMessageBox(IDS_ERR_NOT_SUPPORT_FILE, MB_OK | MB_ICONSTOP);
		return	FALSE;
	}

	return	TRUE;
}

// Get width & height of image.
//BOOL CPrintDlg::getImageSize(PCSTR FilePath, PPOINT pImageSize)
BOOL CPrintDlg::getImageSize(LPCTSTR FilePath, PPOINT pImageSize)
{
	BITMAPINFOHEADER	bih;
	CWaitCursor			wait;

	// Load image data;
	if (!loadImageFile(FilePath, NULL, &bih)) {
		return	FALSE;
	}

	// Use only BITMAPINFOHEADER.
	pImageSize->x = bih.biWidth;
	pImageSize->y = bih.biHeight;

	return	TRUE;
}

// Load image file.
BOOL CPrintDlg::loadImageFile(LPCTSTR strFilePath, PHANDLE phDib, PBITMAPINFOHEADER pBih)
{
	DWORD		ret;
	UINT		errStrId;
	char		szFilePath[MAX_PATH];

// 2006/01/12 Ver.2.1.1
#ifdef UNICODE
	CEncode	Encode;
	CString	strTempFile = _T("temp");
	
	ret = Encode.MakeTempFile(strFilePath, strTempFile);
	ret = Encode.ToSJIS(strTempFile, szFilePath);
	if(ret!=0){
		AfxMessageBox(_T("File Path Encode Error."));
		return FALSE;
	}
#else
	strcpy(szFilePath, strFilePath);
#endif

	// Load image file by LOADIMG_Load() of "LoadImg.lib".
	ret = LOADIMG_Load(szFilePath, phDib, pBih);
	if (ret != LOADIMG_OK) {
		switch (ret) {
		case LOADIMG_ERR_FILE_NOT_FOUND:
			errStrId = IDS_ERR_NOT_FOUND_FILE;
			break;
		case LOADIMG_ERR_FILE_READ:
			errStrId = IDS_ERR_CANNOT_ACCESS_FILE;
			break;
		case LOADIMG_ERR_MEMORY_ALLOC:
			errStrId = IDS_ERR_ALLOC_MEM;
			break;
		default:
			errStrId = IDS_ERR_NOT_SUPPORT_FILE;
			break;
		}
		AfxMessageBox(errStrId, MB_OK | MB_ICONSTOP);
		return	FALSE;
	}
#ifdef UNICODE
	DeleteFile(strTempFile);
#endif

	return	TRUE;
}

BOOL CPrintDlg::updatePrinterRemainPaperCopies()
{
	DWORD remainCopies = 0;

	UpdateData(TRUE);

	if (!m_pPrinter->GetPaperRemain(&remainCopies)) {
		return	FALSE;
	}

	if (remainCopies == MCP_PAPER_REMAIN_UNKNOWN) {
		m_strRemainCopies.Format(_T("Unknown"));
	} else {
		m_strRemainCopies.Format(_T("%d"), remainCopies);
	}

	UpdateData(FALSE);

	return	TRUE;
}

// Handler at "Clear" button pushed.
void CPrintDlg::OnClearButton() 
{
	POSITION	pos;
	int			selItem, i;
	PRINT_IMAGE_INFO	printImageListInfo;

	// Check selected item exist.
	pos = m_printImageList.GetFirstSelectedItemPosition();
	if (pos == NULL) {
		return;
	}
	selItem = m_printImageList.GetNextSelectedItem(pos);

	// Slide print list information and display.
	for (i = selItem; i < (m_printImageCnt - 1); i++) {
		getPrintImageListInfo(i + 1, &printImageListInfo);
		printImageListInfo.Status = STATUS_READY;
		printImageListInfo.Copied = 0;
		printImageListInfo.Copies = 0;
		setPrintImageListInfo(i, printImageListInfo, FALSE, FALSE);
	}

	// Delete last of list information and display.
	ZeroMemory(&printImageListInfo, sizeof(printImageListInfo));
	setPrintImageListInfo(m_printImageCnt - 1, printImageListInfo, FALSE, TRUE);

	if (m_printImageList.GetItemCount() == 0) {
		enableControl(ENABLE_READY_NO_IMAGE);
	}

}

// Handler at "Start print" button pushed.
void CPrintDlg::OnStartPrint() 
{
	CDoPrint		*pDoPrint;
	DOPRINT_INFO	doPrintInfo;
	PRINT_IMAGE_INFO	printImageListInfo;
	int					i;
	int				index = m_paperTypeCmb.GetCurSel();
	int printMethod = PRINTMETHOD_NORMAL;

	if (m_printImageCnt == 0) {
		// No image file selected.
		AfxMessageBox(IDS_ERR_NO_SEL_IMAGE, MB_OK | MB_ICONSTOP);
		return;
	}

	if (PrinterPaperSizeTbl[index].fUnknown) {
		// No paper size selected.
		AfxMessageBox(IDS_ERR_NO_SEL_PAPER_SIZE, MB_OK | MB_ICONSTOP);
		return;
	}

	if (PrinterPaperSizeTbl[index].DispStrId ==  IDS_PAPER_SIZE_K_MULTI) {
		printMethod = PRINTMETHOD_MULTI;
	}

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	else if (PrinterPaperSizeTbl[index].DispStrId ==  IDS_PAPER_SIZE_8X4_3DIV) {
		printMethod = PRINTMETHOD_THREEDIV;
	}
	else if (PrinterPaperSizeTbl[index].DispStrId ==  IDS_PAPER_SIZE_A5_MULTI) {
		printMethod = PRINTMETHOD_MULTI;
	}
#endif

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
	else if (PrinterPaperSizeTbl[index].DispStrId ==  IDS_PAPER_SIZE_NOR_MUL) {
		printMethod = PRINTMETHOD_NOR_MUL;
	}
	else if (PrinterPaperSizeTbl[index].DispStrId ==  IDS_PAPER_SIZE_NOR_MUL_2) {
		printMethod = PRINTMETHOD_NOR_MUL_2;
	}
	else if (PrinterPaperSizeTbl[index].DispStrId ==  IDS_PAPER_SIZE_MUL_NOR) {
		printMethod = PRINTMETHOD_MUL_NOR;
	}
	else if (PrinterPaperSizeTbl[index].DispStrId ==  IDS_PAPER_SIZE_MUL_NOR_2) {
		printMethod = PRINTMETHOD_MUL_NOR_2;
	}
#endif

	m_pPrinter->SetPrintMethod( printMethod );

	// 2005/12/08 Ver.1.8.0
	m_pPrinter->SetAutoRecoveryFlag(m_check_AutoRecovery.GetCheck());
	m_fCancel = FALSE;

	// Initialize print status display.
	ZeroMemory(&printImageListInfo, sizeof(printImageListInfo));
	printImageListInfo.Status = STATUS_READY;
	for (i = 0; i < m_printImageCnt; i++) {
		setPrintImageListInfo(i, printImageListInfo, FALSE, FALSE);
	}

	// Get printer remain paper.
	if (!updatePrinterRemainPaperCopies()) {
		return;
	}


	// Create CDoPrint instance.
	if (m_pDoPrint != NULL) {
		delete	m_pDoPrint;
		m_pDoPrint = NULL;
	}
	pDoPrint = new CDoPrint();
	if (pDoPrint == NULL) {
		AfxMessageBox(IDS_ERR_NO_MEMOREY, MB_OK | MB_ICONSTOP);
		return;
	}

	// Pass print information to CDoPrint.
	pDoPrint->SetPrinterInfo(m_pPrinter);
	pDoPrint->SetParentDlg(this);
	pDoPrint->SetImageList(m_printImageTbl, m_printImageCnt);

	m_pDoPrint = pDoPrint;

	// Get print setting values set on dialog.
	getDialogPrintSetting();

#ifndef RET_VERSION_270	// nakashima addition 2010/01/18 Ver.2.7.1
	m_pPrinter->SetPrintMode( m_intPrintMode );
#endif

#ifndef RET_VERSION_261	// nakashima addition 2007/10/11 Ver.2.6.2
	m_ImgSetupDlg.Set3dFilePath(m_intPrintMode);
#endif

	doPrintInfo.PrintInfo = m_printInfo;
	doPrintInfo.PaperSize = m_paperSize;
	doPrintInfo.fImgSetup = m_chkImageSetup;//2005.5.27 mochida
	doPrintInfo.f1DLUT = m_chk1DLUT;  // 2005/12/05 Ver.1.7.1
	doPrintInfo.f3DLUT = m_chk3DLUT;  // 2005/12/05 Ver.1.7.1
	doPrintInfo.IsplInfo = m_IsplInfo;// 2005/12/05 Ver.1.7.1
	pDoPrint->SetDoPrintInfo(doPrintInfo);

	pDoPrint->Set3dlut(m_xv3dlut);

	// Print start
	if (!pDoPrint->StartPrint(this->callbackProcFromDoPrint)) {
		return;
	}
	// Return quickly because CDoPrint::StartPrint create other thread for print.

	m_fPrinting = TRUE;
	enableControl(ENABLE_PRINTING);

}

// Handler at "Stop print" button pushed.
void CPrintDlg::OnStopPrint() 
{
	// Stop print.
	if (m_pDoPrint != NULL) {
		m_pDoPrint->StopPrint();
	}
	m_fCancel = TRUE;
}

// Callback function call from class CDoPrint to notify print progress.
// (hPrinter  : Target printer handle.
//  ImageNo   : Image index in list (0, 1, 2,...)
//  Copied    : Printed copies count
//  Copies    : Requested copies count
//  Status    : Printing status (STATUS_XXXX)
//  ErrorInfo : Error info. (SDK error return code) )
void CPrintDlg::callbackProcFromDoPrint(HANDLE hPrinter, int ImageNo, WORD Copied, WORD Copies, BYTE Status, DWORD ErrorInfo)
{
	int			i;
	UINT		msg;		// Windows message code
							//  Hi byte : Image No. / Low byte : Status (STATUS_XXXX)
	WORD		msgStatus = STATUS_NON;
	WPARAM		wParam;		//  Hi WORD : Printed copies count / low WORD : Requested copies count
	LPARAM		lParam;		//  Error info. (SDK error return code)

	// Search dialog to post message.
	for (i = 0; i < COUNTOF_ARRAY(g_dlgTbl); i++) {
		if (hPrinter == g_dlgTbl[i].hPrinter) {
			break;
		}
	}
	if (i == COUNTOF_ARRAY(g_dlgTbl)) {
		return;
	}

	if (ErrorInfo != MCP_OK) {
		// Error callback
		msgStatus	= WM_CALLBACK_ERROR;
		wParam		= 0;
		lParam		= ErrorInfo;
	} else {
		switch (Status) {
		case STATUS_IMAGESETUP:
			msgStatus	= WM_CALLBACK_IMAGESETUP;
			wParam		= 0;
			break;
		case STATUS_WAITING:
			msgStatus	= WM_CALLBACK_WAITING;
			wParam		= 0;
			break;
		case STATUS_SENDING:
			msgStatus	= WM_CALLBACK_SENDING;
			wParam		= (UINT)MAKELONG(Copies, Copied);
			break;
		case STATUS_SPOOLED:
			msgStatus	= WM_CALLBACK_SPOOLED;
			wParam		= (UINT)MAKELONG(Copies, Copied);
			break;
		case STATUS_PRINTING:
			msgStatus	= WM_CALLBACK_PRINTING;
			wParam		= (UINT)MAKELONG(Copies, Copied);
			break;
		case STATUS_COMPLETE:
			msgStatus	= WM_CALLBACK_COMPLETE;
			wParam		= (UINT)MAKELONG(Copies, Copied);
			break;
		case STATUS_RECOVERY:
			msgStatus	= WM_CALLBACK_RECOVERY;
			wParam		= (UINT)MAKELONG(Copies, Copied);
			break;
		case STATUS_CANCEL:
			msgStatus	= WM_CALLBACK_CANCEL;
			wParam		= 0;
			break;
		case STATUS_ERROR:
			msgStatus	= WM_CALLBACK_ERROR;
			wParam		= 0;
			break;
		default:
			return;
			break;
		}
		lParam		= MCP_OK;
	}

	// 2005/07/12 Ver.1.4.1
	// For Normal print
	if( g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_NORMAL || Status == STATUS_IMAGESETUP || Status == STATUS_WAITING || Status == STATUS_CANCEL ){
		msg = msgStatus + MAKEWORD(0, ImageNo);
		// Post Windows message to main dialog window.
		::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);
	}

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
	else if( (g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_NOR_MUL)
		|| (g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_NOR_MUL_2) ) {	// For Normal and Multi cut print	
//	else if( (g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_NOR_MUL){		// For Normal and Multi cut print	

		if( (ImageNo % 2) == 0 ) {
			msg = msgStatus + MAKEWORD(0, GET_NOR_MUL_NO_N(ImageNo));
			// Post Windows message to main dialog window.
			::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);
		}
		else {
			// 1st image at Multi cut print
			msg = msgStatus + MAKEWORD(0, GET_NOR_MUL_NO_M1(ImageNo) );
			::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);

			// 2nd image at Multi cut print
			msg = msgStatus + MAKEWORD(0, GET_NOR_MUL_NO_M2(ImageNo) );
			::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);
		}
	}
	else if( (g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_MUL_NOR)
		|| (g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_MUL_NOR_2) ) {	// For Multi and Normal cut print	
//	else if( g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_MUL_NOR ) {	// For Multi and Normal cut print	

		if( (ImageNo % 2) == 0 ) {
			// 1st image at Multi cut print
			msg = msgStatus + MAKEWORD(0, GET_MUL_NOR_NO_M1(ImageNo) );
			::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);

			// 2nd image at Multi cut print
			msg = msgStatus + MAKEWORD(0, GET_MUL_NOR_NO_M2(ImageNo) );
			::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);
		}
		else {
			msg = msgStatus + MAKEWORD(0, GET_MUL_NOR_NO_N(ImageNo));
			// Post Windows message to main dialog window.
			::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);
		}
	}
#endif

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	else if(g_pPrinter[i]->GetPrintMethod() == PRINTMETHOD_THREEDIV) {
		// 1st image at Three Div cut print
		msg = msgStatus + MAKEWORD(0, GET_THREEDIV_NO_1ST(ImageNo) );
		::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);

		// 2nd image at Three Div cut print
		msg = msgStatus + MAKEWORD(0, GET_THREEDIV_NO_2ND(ImageNo) );
		::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);

		// 3rd image at Three Div cut print
		msg = msgStatus + MAKEWORD(0, GET_THREEDIV_NO_3RD(ImageNo) );
		::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);
	}
#endif

	else{// For Multi cut print	

		// 1st image at Multi cut print
		msg = msgStatus + MAKEWORD(0, GET_MULTI_NO_1ST(ImageNo) );
		::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);

		// 2nd image at Multi cut print
		msg = msgStatus + MAKEWORD(0, GET_MULTI_NO_2ND(ImageNo) );
		::PostMessage(g_dlgTbl[i].hDlg, msg, wParam, lParam);
	}
	// You should return callback function to SDK quickly.
}

// DefWindowProc() of this dialog.
LRESULT CPrintDlg::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	int			imageNo;
	BYTE		status;
	DWORD		errorInfo;
	PRINT_IMAGE_INFO	printImageInfo;

	// Check Windows message.
	if (message >= WM_CALLBACK_BASE && message <= WM_CALLBACK_MAX) {

		// Callback notify from class CDoPrint.
		imageNo	= HIBYTE(message - WM_CALLBACK_BASE);
		status	= LOBYTE(message - WM_CALLBACK_BASE);
		errorInfo = (DWORD)lParam;
		if (	(status == STATUS_ERROR)	&&
				(errorInfo != MCP_OK)		) {
			m_pPrinter->ErrMessage(IDS_ERR_CALLBACK, errorInfo);
		}

		// Set printing progress to print image list control.
		ZeroMemory(&printImageInfo, sizeof(printImageInfo));
		_tcscpy(printImageInfo.FilePath, _T(""));
		printImageInfo.Copied		= HIWORD(wParam);
		printImageInfo.Copies		= LOWORD(wParam);
		printImageInfo.Status		= status;
		setPrintImageListInfo(imageNo, printImageInfo, FALSE, FALSE);

	}

	if (message == WM_SETFOCUS_STARTPRINT) {
		GetDlgItem(IDC_START_PRINT)->SetFocus();
	} else if (message == WM_UPDATE_REMAIN_COPIES) {
		// Update display of printer remain copies.
		updatePrinterRemainPaperCopies();
	}

	return CDialog::DefWindowProc(message, wParam, lParam);
}


// Handler at "Close" button pushed.
void CPrintDlg::OnCancel() 
{
	// Finish to printer control.
	if (m_pPrinter != NULL) {
		if (m_pPrinter->IsOpen()) {
			CWaitCursor		wait;
			m_pPrinter->Close();
		}
	}
	if (m_pDoPrint != NULL) {
		delete	m_pDoPrint;
		m_pDoPrint = NULL;
	}

	CDialog::OnCancel();
}



//===========================================================================
//	Handler other dialog controls.
//===========================================================================

// Print image list control selected / non-selected.
void CPrintDlg::OnItemchangedPrintImageList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW	*pNMListView = (NM_LISTVIEW *)pNMHDR;

	if (!m_fPrinting) {
		if (pNMListView->uChanged & LVIF_STATE) {
			if (pNMListView->uNewState & LVIS_SELECTED) {
				// If condition of item change from non-selected to selected.
				enableControl(ENABLE_READY_SEL_IMAGE);
			} else if (pNMListView->uOldState & LVIS_SELECTED) {
				// If condition of item change from selected to non-selected.
				enableControl(ENABLE_READY_HAVE_IMAGE);
			}
		}
	}
	
	*pResult = 0;
}


void CPrintDlg::OnOK() 
{
	// If hit enter key, do not anything.
}




// Shanpness ON/OFF check
void CPrintDlg::OnCheckSharpness() 
{
	BOOL	fEnable = TRUE;

	UpdateData(TRUE);

	if (m_chkSharpness) {
		fEnable = TRUE;
	} else {
		fEnable = FALSE;
	}

	GetDlgItem(IDC_SLIDER_SHARPNESS)->EnableWindow(fEnable);
	GetDlgItem(IDC_EDIT_SHARPNESS)->EnableWindow(fEnable);

}

// Slider horizonal scroll
void CPrintDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UpdateData(TRUE);

	m_intSharpness = m_sliderSharpness.GetPos();

	UpdateData(FALSE);

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

// Edit box chage value
void CPrintDlg::OnKillfocusEditSharpness() 
{
/*
	UpdateData(TRUE);
	if (m_intSharpness < MCP_SHARPNESS_MIN) {
		m_intSharpness = MCP_SHARPNESS_MIN;
	} else if (m_intSharpness > MCP_SHARPNESS_MAX) {
		m_intSharpness = MCP_SHARPNESS_MAX;
	}
	m_sliderSharpness.SetPos(m_intSharpness);
	UpdateData(FALSE);
*/
}

// Image setup ON/OFF check
void CPrintDlg::OnCheckImageSetup() 
{
	BOOL	fEnable = TRUE;

	UpdateData(TRUE);

	if (m_chkImageSetup) {
		fEnable = TRUE;
	} else {
		fEnable = FALSE;
	}

	GetDlgItem(IDC_IMG_SETUP_BUTTON)->EnableWindow(fEnable);
}

// 2005.5.27 mochida
void CPrintDlg::OnImgSetupButton() 
{
	if (m_ImgSetupDlg.IsDlgCreate()) {
		m_ImgSetupDlg.DestroyWindow();
	}
	m_ImgSetupDlg.Create(IDD_IMG_SETUP_DLG, this);	
}

// Show 1dData Dialog
void CPrintDlg::OnCreateButton() 
{
	if (m_1dDataDlg.IsDlgCreate()) {
		m_1dDataDlg.DestroyWindow();
	}
	m_1dDataDlg.SetPrinter(m_pPrinter);
	m_1dDataDlg.Create(IDD_1DDATA_DLG, this);	
}

// Delete 1dData file
void CPrintDlg::OnDeleteButton() 
{
	if (m_pPrinter->Delete1dDataFile()) {
		AfxMessageBox(_T("Delete 1D data file.") );
	}
}

void CPrintDlg::OnPrinterInfo() 
{
	DWORD totalPrintedCnt = 0;
	DWORD totalHeadPrintedCnt = 0;

	if (!m_pPrinter->GetPrintedInfo(&totalPrintedCnt, &totalHeadPrintedCnt)) {
		return;
	}
	
	if (m_PrinterInfoDlg.IsDlgCreate()) {
		m_PrinterInfoDlg.DestroyWindow();
	}
	m_PrinterInfoDlg.SetPrintedInfo(totalPrintedCnt, totalHeadPrintedCnt);
	m_PrinterInfoDlg.Create(IDD_PRINTER_INFO_DLG, this);
	
}
