/************************************************************/
/*															*/
/*	File :	PrintDlg.h										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#ifndef __PRNSETUPDLG_H__
#define __PRNSETUPDLG_H__


#include "Printer.h"
#include "ImgSetupDlg.h"
#include "1dDataDlg.h"
#include "PrinterInfoDlg.h"

class CDoPrint;


// Struct for image info list
typedef struct {
	TCHAR		FilePath[MAX_PATH];// 2006/01/12 Ver.2.1.1
	POINT		ImageSize;
	WORD		Copied;
	WORD		Copies;
	BYTE		Status;
} PRINT_IMAGE_INFO, *PPRINT_IMAGE_INFO;


// Max count of image list.
#define	PRINT_IMAGE_LIST_MAX_COUNT		100


// For display status
#define	STATUS_NON						0xFF	// No changed
#define	STATUS_READY					0x00
#define	STATUS_IMAGESETUP				0x01
#define	STATUS_WAITING					0x02
#define	STATUS_SENDING					0x03
#define	STATUS_SPOOLED					0x04
#define	STATUS_PRINTING					0x09
#define	STATUS_COMPLETE					0x0B
#define	STATUS_CANCEL					0x0C
#define	STATUS_RECOVERY					0x0D	// Add 2005.6.9 mochida
#define	STATUS_ERROR					0x14	// Error

// takanaka addition 2009/04/09 Ver.2.7.0
#define LUT_COMBO_SDK					_T("SDK")
#define LUT_COMBO_FFISPL				_T("FFISPL")
#define LUT_COMBO_NONE				_T("None")


/////////////////////////////////////////////////////////////////////////////
// CPrintDlg dialog

class CPrintDlg : public CDialog
{

public:

	CPrintDlg(CWnd* pParent = NULL);

	// Set this dialog display position.
	// (WndPos : Windows left top position.)
	void	SetWindowPosition(POINT WndPos);

	// Set taeget printer control information.
	void	SetPrinterInfo(CPrinter* pPrinter) { m_pPrinter = pPrinter; }

	// Get whether creating Dialog. (TRUE : Creating)
	BOOL	IsDlgCreate() { return m_create; }

	// Notify to this dialog ending print.
	// (fSuccess : TRUE = print ended normally.)
	void	NotifyPrintEnd(BOOL fSuccess);

	// Let update display of printer remain copies.
	void	LetUpdatePrinterRemainPaperCopies();

	// Callback function call from class CDoPrint ro notify print progress.
	// (hPrinter  : Target printer handle.
	//  ImageNo   : Image index in list (0, 1, 2,...)
	//  Copied    : Printed copies count
	//  Copies    : Requested copies count
	//  Status    : Printing status (STATUS_XXXX)
	//  ErrorInfo : Error info. (SDK error return code) )
	static void callbackProcFromDoPrint(HANDLE hPrinter, int ImageNo, WORD Copied, WORD Copies, BYTE Status, DWORD ErrorInfo);

	//{{AFX_DATA(CPrintDlg)
	enum { IDD = IDD_PRINT_DLG };
	CButton	m_check_AutoRecovery;
	CSliderCtrl	m_sliderSharpness;
	CComboBox	m_paperTypeCmb;
	int		m_intPrintMode;
	CListCtrl	m_printImageList;
	CSpinButtonCtrl	m_volumeSpin;
	int		m_copiesInt;
	CString	m_strRemainCopies;
	BOOL	m_chkSharpness;
	int		m_intSharpness;
	BOOL	m_chkImageSetup;
	BOOL	m_chk1DLUT;
	BOOL	m_chk3DLUT;
	CString	m_xv3dlut;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CPrintDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CPrintDlg)
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	afx_msg void OnBrowsButton();
	afx_msg void OnClearButton();
	afx_msg void OnStopPrint();
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnStartPrint();
	afx_msg void OnItemchangedPrintImageList(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	afx_msg void OnCheckSharpness();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKillfocusEditSharpness();
	afx_msg void OnImgSetupButton();
	afx_msg void OnCheckImageSetup();
	afx_msg void OnCreateButton();
	afx_msg void OnDeleteButton();
	afx_msg void OnPrinterInfo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:

	void	initPrintImageTbl();
	BOOL	setPrintImageListInfo(int ImageIndex, PRINT_IMAGE_INFO PrintImageListInfo, BOOL fAdd, BOOL fClear);
	BOOL	getPrintImageListInfo(int ImageIndex, PPRINT_IMAGE_INFO pPrintImageListInfo);
	void	enableControl(DWORD EnableMode);
	void	setPrintImageListDisp(int ImageIndex, PRINT_IMAGE_INFO PrintImageListInfo, BOOL fClear);
	void	setDialogCaption();
	void	initPrintImageListControl();
	void	getDialogPrintSetting();
	void	initPaperSizeCombo(short MediaType);
	void	checkImageInPaper();
	// Modify for Unicode. at 06/01/12
	BOOL	setImageItem(int ImageIndex, LPCTSTR strFilePath, BOOL fAdd);          // 2006/01/12 Ver.2.1.1
	BOOL	isImageFile(LPCTSTR Filepath);                                         // 2006/01/12 Ver.2.1.1
	BOOL	getImageSize(LPCTSTR FilePath, PPOINT pImageSize);                     // 2006/01/12 Ver.2.1.1
	BOOL	loadImageFile(LPCTSTR FilePath, PHANDLE phDib, PBITMAPINFOHEADER pBih);// 2006/01/12 Ver.2.1.1
	BOOL	updatePrinterRemainPaperCopies();


	POINT			m_wndPos;		// Dialog display position.
	BOOL			m_create;		// Flag of creating Dialog.
	CPrinter*		m_pPrinter;		// Pointer to printer control object.
	PRINT_INFO		m_printInfo;	// Print setting.
	POINT			m_paperSize;	// Selected paper size.
//	COLORPARAM_EX	m_colorParam;	// Image setup parameters.	2005/05/27 mochida
	ISPL_INFO		m_IsplInfo;		// Image setup parameters. 2005/12/05 Ver.1.7.1
	PRINT_IMAGE_INFO	m_printImageTbl[PRINT_IMAGE_LIST_MAX_COUNT];	// Print image information table
	int				m_printImageCnt;									// Print image count
	CDoPrint*		m_pDoPrint;		// Pointer to print process object.
	BOOL			m_fPrinting;	// Flag of executing print.
	BOOL			m_fCancel;		// Flag of executed cancel print.

	CImgSetupDlg	m_ImgSetupDlg;	// Image setup dialog.	2005.5.27 mochida
	C1dDataDlg		m_1dDataDlg;	// 1D LUT data generate dialog	2005.6.24 mochida

	CPrinterInfoDlg	m_PrinterInfoDlg;	// Printer Info dialog.	2008.2.10 nakashima
};


///////////////////////////////////////////////////////////////////////////////
//
//	define
//



#endif //__PRNSETUPDLG_H__
