/************************************************************/
/*															*/
/*	File :	Printer.h										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#ifndef	__PRINTER_H__
#define __PRINTER_H__


#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#include "DPBAPI.h"

//===========================================================================
//
//	CPrinter class
//		Class to control target printer and manage print information of
//		target printer by using printer SDK.
//
//		Use this class procedure
//			1. Create instance of this class for target printer, with indicate
//			   printer index and handle got at enumerated CSetup::Enum().
//			2. Call Open() method for starting to control target printer.
//			3. Call each method for controlling target printer.
//			4. Call Close() method for finishing to control target printer.
//			5. After finishing to control target printer, delete instance of
//			   this class.
//
//===========================================================================


// 2005/07/06 Ver.1.4.1
#define	PRINTMETHOD_NORMAL		(0)
#define	PRINTMETHOD_MULTI		(1)

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
#define	PRINTMETHOD_THREEDIV	(2)
#endif

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
#define	PRINTMETHOD_NOR_MUL		(3)
#define	PRINTMETHOD_NOR_MUL_2	(4)
#define	PRINTMETHOD_MUL_NOR		(5)
#define	PRINTMETHOD_MUL_NOR_2	(6)
#endif

// 2005/07/06 Ver.1.4.1
// For Multi cut print
// Convert JobNo to 1st imageNo, 2nd imageNo.
#define GET_MULTI_NO_1ST( JobNo )	( ( JobNo )*2 )
#define GET_MULTI_NO_2ND( JobNo )	( ( JobNo )*2 + 1 )

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
#define GET_THREEDIV_NO_1ST( JobNo )	( ( JobNo )*3 )
#define GET_THREEDIV_NO_2ND( JobNo )	( ( JobNo )*3 + 1 )
#define GET_THREEDIV_NO_3RD( JobNo )	( ( JobNo )*3 + 2 )
#endif

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
#define GET_NOR_MUL_NO_N( JobNo )	( JobNo + ( JobNo / 2 ) )
#define GET_NOR_MUL_NO_M1( JobNo )	( JobNo + ( JobNo / 2 ) )
#define GET_NOR_MUL_NO_M2( JobNo )	( JobNo + ( JobNo / 2 ) + 1 )

#define GET_MUL_NOR_NO_M1( JobNo )	( JobNo + ( JobNo / 2 ) )
#define GET_MUL_NOR_NO_M2( JobNo )	( JobNo + ( JobNo / 2 ) + 1 )
#define GET_MUL_NOR_NO_N( JobNo )	( JobNo + ( JobNo / 2 ) + 1 )
#endif

// Struct for print setting.
typedef struct {
	MCP_PRINTINFO		PrintSetting;		// Print setting information
} PRINT_INFO, *PPRINT_INFO;


class CPrinter  
{

public:
	// Constructor / Destructor
	// (PrinterNo : Index of target printer got at enumerated CSetup::Enum().
	//  hPrinter  : Handle of target printer got at enumerated CSetup::Enum().
	//  strProductName : Printer product name.)
	CPrinter(int PrinterNo, HANDLE hPrinter, LPCTSTR strProductName);// Modify at 2006/01/12 Ver.2.1.1
	virtual ~CPrinter();

	// Get printer No. (1, 2, 3,...)
	int		GetPrinterNo() { return m_printerNo; }

	// Get SDK printer handle.
	HANDLE	GetHandle() { return m_hPrinter; }

	// Get printer product name.
	// (strProductName : Product name)
	void GetProductName(CString& strProductName) { strProductName = m_strProductName; }

	// Start controlling target printer.
	// (Return value : TRUE OK, FALSE error)
	BOOL Open();

	// Finish controlling target printer.
	// (Return value : TRUE OK, FALSE error)
	BOOL Close();

	// Check printer open.
	BOOL IsOpen() { return m_fOpen; };

	// Get device information of target printer.
	// (pPrinterInfo : [OUT] Device information.)
	// (Return value : TRUE OK, FALSE error)
	BOOL GetPrinterInfo(PMCP_PRINTER_INFO pPrinterInfo);

	// Clear frame memory of target printer.
	// (Return value : TRUE OK, FALSE error)
	BOOL PrinterMemoryClear();

	// Send print setting to target printer.
	// (PrintInfo : Print setting.
	//  pfPrinterCannotReceiveDataNow : [OUT] TRUE = Printer is printing and cannot receive image data now.)
	// (Return value : TRUE OK, FALSE error (include pfPrinterCannotReceiveData is TRUE) )
	BOOL SendPrintSetting(PRINT_INFO PrintInfo, PBOOL pfPrinterCannotReceiveDataNow);

	// Send image data to printer, and start print, and resister callback function for notification printing to SDK.
	// (hDib      : Image DIB memory handle.
	//  pCallback :	Address of callback function for SDK notification printing.)
	// (Return value : TRUE OK, FALSE error)
	BOOL SendImageAndPrint(HANDLE hDib, PMCP_CALLBACK pCallback);

	// Cancel print in the way.
	// (Return value : TRUE OK, FALSE error)
	BOOL CancelPrint();

	// Get printer remain paper (Copies).
	// (pRemainCopies : [OUT] Remain copies.)
	// (Return value : TRUE OK, FALSE error)
	BOOL GetPaperRemain(PDWORD pRemainCopies);

#ifndef RET_VERSION_265		// nakashima addition 2008/02/10 Ver.2.6.6
	// Get printer info (TotalPrintedCnt, TotalHeadPrintedCnt).
	// (pTotalPrintedCnt : [OUT] Total printed count after shipment.)
	// (pTotalHeadPrintedCnt : [OUT] Total printed count after head change.)
	// (Return value : TRUE OK, FALSE error)
	BOOL GetPrintedInfo(PDWORD pTotalPrintedCnt, PDWORD pTotalHeadPrintedCnt);
#endif

	// Execute 3D LUT process to image data.
	// (hDib            : Image DIB memory handle. (Original & Result of process)
	//  strDataFileName : File name of 3D LUT parameter data file. (File name only (Not full-path.))
	// (Return value : TRUE OK, FALSE error)
	BOOL Do3dLut(HANDLE hDib, PCSTR strDataFileName);

	// Execute 3D LUT process to image data.
	// (hDib         : Image DIB memory handle. (Original & Result of process)
	// (Return value : TRUE OK, FALSE error)
	BOOL Do3dLut(HANDLE hDib);

	// Display error message. (Indicate string or resource ID of StringTable)
	// (Str      : Error message string.
	//  StrID    : Error message string ID in StringTable.
	//  ErrCode  : SDK functions return code.
	//  fSdkAllErr : SDK error to all printer ==> TRUE.
	//             (If not SDK function error, set 0.)
	void ErrMessage(LPCTSTR Str, DWORD ErrCode = 0, BOOL fSdkAllErr = FALSE);// Modify at 2006/01/12 Ver.2.1.1
	void ErrMessage(UINT StrID, DWORD ErrCode = 0);

	// Check whether error is recoverable or not.
	// (Return value : TRUE yes, FALSE no)
	BOOL IsRecoverable();

	// Set m_fRecoverableError FALSE.
	void ResetRecoverableFlag(){ 
		m_fRecoverableError = FALSE;
	}

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	BOOL Create1dDataFileNewLinear(int iR, int iG, int iB, CString& strDataPath);
	BOOL Create1dDataFileNewGamma(int iR, int iG, int iB, CString& strDataPath);
	BOOL Create1dDataFileOldLinear(int iD, int iY, int iM, int iC, CString& strDataPath);
	BOOL Create1dDataFileOldGamma(int iD, int iY, int iM, int iC, CString& strDataPath);
#else
	// Create peculiar 1D LUT data file to printer.
	BOOL Create1dDataFile(int iD, int iY, int iM, int iC, CString& strDataPath);

	//Ver.2.4.0
	BOOL Create1dDataFileWithGammaCurve(int iD, int iY, int iM, int iC, CString& strDataPath);
#endif

	// Delete peculiar 1D LUT data file to printer.
	BOOL Delete1dDataFile();

	// Execute 1D LUT process to image data.
	// (hDib            : Image DIB memory handle. (Original & Result of process)
	BOOL Do1dLut(HANDLE hDib);

	// Send image data to printer, and start print, and resister callback function for notification printing to SDK.
	// (hDib      : 1st Image DIB memory handle.
	// (hDib2     : 2nd Image DIB memory handle.
	//  pCallback :	Address of callback function for SDK notification printing.)
	// (Return value : TRUE OK, FALSE error)
	BOOL SendImageAndMultiPrint(HANDLE hDib, HANDLE hDib2, PMCP_CALLBACK pCallback);

	// Send image data to printer, and start print, and resister callback function for notification printing to SDK.
	// (hDib      : 1st Image DIB memory handle.
	// (hDib2     : 2nd Image DIB memory handle.
	// (hDib3     : 3rd Image DIB memory handle.
	//  pCallback :	Address of callback function for SDK notification printing.)
	// (Return value : TRUE OK, FALSE error)
	BOOL SendImageAndThreeDivPrint(HANDLE hDib, HANDLE hDib2, HANDLE hDib3, PMCP_CALLBACK pCallback);

	// Check print method.
	int  GetPrintMethod(){ return m_printMethod; }

	// Set print method.
	void SetPrintMethod(int printMethod){ m_printMethod = printMethod; }

	// Set AutoRecovery Flag. 2005/12/08 Ver.1.8.0
	BOOL SetAutoRecoveryFlag(BOOL fAuto);

	// 2005/12/09 Ver.1.9.0
	BOOL StopPrint();

	// 2006/03/13 Ver.2.2.0
	BOOL GetPrinterError(HANDLE hPrinter, char* szPrinterError, DWORD* dwPrinterErrorDetail);

	// Check print mode.
	int  GetPrintMode(){ return m_printMode; }	// nakashima addition 2010/01/18 Ver.2.7.1

	// Set print mode.
	void SetPrintMode(int printMode){ m_printMode = printMode; }	// nakashima addition 2010/01/18 Ver.2.7.1

private:
	int			m_printerNo;		// Index of target printer. (Got at enumerated CSetup::Enum(). (0, 1, 2, ...) )
	HANDLE		m_hPrinter;			// Handle of target printer.
	CString		m_strProductName;	// Product name.
	BOOL		m_fOpen;			// Flag of opening to target printer.
	BOOL		m_fRecoverableError;// Flag of occuring recoverable error.
	int			m_printMethod;		// Print method. (Normal or Multi Cut)
	BOOL		m_fAutoRecovery;
	int			m_printMode;		// Print mode. (Speed or Quality)	// nakashima addition 2010/01/18 Ver.2.7.1
};



#endif // #ifndef	__PRINTER_H__
