/************************************************************/
/*															*/
/*	File :	SaveBmp.c										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*		Save image to BMP file function						*/
/*		implement file										*/
/*															*/
/*	Copyright (C) 2002 Fuji Photo Film Co., Ltd.			*/
/*															*/
/************************************************************/


#include <windows.h>
#include <stdio.h>
#include "SaveBmp.h"



///////////////////////////////////////////////////////////////////////////////
//
//	private functions prototype
//

static BOOL saveBMP(PCSTR BmpFilePath, HGLOBAL hDib);



///////////////////////////////////////////////////////////////////////////////
//
//	public functions prototype
//


//===========================================================================
//
//	SaveDibToBmpFileAtSameFolder()
//
//===========================================================================
BOOL SaveDibToBmpFileAtSameFolder(PCSTR BmpFileName, HGLOBAL hDib)
{
	char	exePath[_MAX_PATH+1], drive[_MAX_DRIVE+1], folder[_MAX_DIR+1], bmpFilePath[_MAX_PATH+1];

	// Get .exe directory.
	GetModuleFileName(NULL, exePath, _MAX_PATH);
	_splitpath(exePath, drive, folder, NULL, NULL);

	// Make full path of save BMP.
	sprintf(bmpFilePath, "%s%s%s", drive, folder, BmpFileName);

	// Save BMP file.
	return saveBMP(bmpFilePath, hDib);
}



///////////////////////////////////////////////////////////////////////////////
//
//	private functions
//


//===========================================================================
//
//	saveBMP()
//		Function :	Save DIB to BMP file.
//		Args     :	BmpFilePath;	[IN]  File name to save BMP (Full path).
//					hDib;			[IN]  Global memory handle of loaded DIB data.
//		Return   :	BOOL;		TRUE : Save O.K., FALSE : Failed to save.
//		Note     :	
//
//===========================================================================
static BOOL saveBMP(PCSTR BmpFilePath, HGLOBAL hDib)
{
	FILE				*fp = NULL;
	BITMAPFILEHEADER	bmfh;
	PBITMAPINFOHEADER	pBmih = NULL;
	long				dibSize, writeCount;
	BOOL				result = TRUE;

	// Open file to save.
	fp = fopen(BmpFilePath, "wb");
	if (fp == NULL) {
		result = FALSE;
		goto	saveBMP_Exit;
	}

	pBmih = (PBITMAPINFOHEADER)GlobalLock(hDib);
	if (pBmih == NULL) {
		result = FALSE;
		goto	saveBMP_Exit;
	}

	// Calculate DIB data size.
	dibSize = sizeof(BITMAPINFOHEADER) + ((pBmih->biWidth * 3 + 3) / 4) * 4 * pBmih->biHeight;

	// Write BITMAPFILEHEADER to file.
	ZeroMemory(&bmfh, sizeof(bmfh));
	bmfh.bfType		= MAKEWORD('B', 'M');
	bmfh.bfSize		= sizeof(bmfh) + dibSize;
	bmfh.bfOffBits	= sizeof(bmfh) + sizeof(BITMAPINFOHEADER);
	writeCount = fwrite(&bmfh, sizeof(bmfh), 1, fp);
	if (writeCount != 1) {
		result = FALSE;
		goto	saveBMP_Exit;
	}

	// Write DIB data to file.
	writeCount = fwrite(pBmih, dibSize, 1, fp);
	if (writeCount != 1) {
		result = FALSE;
		goto	saveBMP_Exit;
	}

saveBMP_Exit:

	if (pBmih != NULL) {
		GlobalUnlock(hDib);
	}
	// Close file to save.
	if (fp != NULL) {
		fclose(fp);
	}

	return	result;
}
