/************************************************************/
/*															*/
/*	File :	Setup.h											*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#ifndef	__SETUP_H__
#define __SETUP_H__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


//#include "CPPRTAPI.h"
#include "DPBAPI.h"



//===========================================================================
//
//	CSetup class
//		Class to Set-up using SDK DLL, and Set-up controlling target printers
//		by using printer SDK.
//
//		Use this class procedure
//			1. Create instance of this class.
//			2. Call Init() method.
//			3. Call Enum() method for get controllable printer handles and
//			   each device information.
//			4. Create instance of CPrinter class for each target printer,
//			   and control printer by using CPrinter class method.
//			5. After finishing to control all printers, call Finish() method.
//			6. Delete instance of this class.
//
//===========================================================================


// Max printer count of this application supported to control at once.
#define	MAX_PRINTER_CNT				8


class CSetup  
{

public:

	// Constructor / Destructor
	CSetup();
	virtual ~CSetup();


	// Initialize printer SDK. (Load DLL etc.)
	// (Return value : TRUE OK, FALSE error)
	BOOL Init();

	// Finish using printer SDK. (Unload DLL etc.)
	// (Return value : TRUE OK, FALSE error)
	BOOL Finish();

	// Enumerate contollable printers, and get device information of each printer.
	// (pPrinterNum : [IN] Max enumerate printers count. [OUT] Enumerated printers count.
	//  pPrinterInfos : [OUT] Information array of found printers.)
	// (Return value : TRUE OK, FALSE error)
	BOOL Enum(PUINT pPrinterNum, PMCP_PRINTER_INFO *pPrinterInfos);

	// Get each handle of printer that found at CSetup::Enum().
	// (Index : Printer to get handle index at enumerated CSetup::Enum().)
	// (Return value : Printer handle.)
	HANDLE GetPrinterHandle(int Index);


private:

	BOOL				m_fSdkDllLoad;		// Flag of SDK DLL loaded.
	BOOL				m_fSdkInit;			// Flag of SDK initialized.
	UINT				m_printerCnt;		// Printer count of enumerated at CSetup::Enum().
	HANDLE				m_hPrinter[MAX_PRINTER_CNT];	// Each printer handles.
	PMCP_PRINTER_INFO	m_pPrinterInfos;	// Printer device informations got CSetup::Enum().

	// Modify at 2006/01/12 Ver.2.1.1 For Unicode
	void ErrMessage(LPCTSTR Str, HANDLE hPrinter = NULL, DWORD ErrCode = 0);

	void ErrMessage(UINT StrID, HANDLE hPrinter = NULL, DWORD ErrCode = 0);

};



#endif // #ifndef	__SETUP_H__
