/************************************************************/
/*															*/
/*	File :	sdksetup.h										*/
/*															*/
/*	ASK-1500 series Wrapper SDK Sample Program		        */
/*															*/
/*	Copyright (C) 2001-2005 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#ifndef __SDKSETUP_H__
#define __SDKSETUP_H__


#include <Windows.h>
#include "DPBAPI.h"


#ifdef __cplusplus
extern "C" {
#endif


/*	SDK DLL file name	*/
#define	SDK_DLL_NAME	"DPBAPI.dll"


/*	Struct for SDK import functions table	*/
typedef struct {
	PMCP_Init					Init;
	PMCP_Finish					Finish;
	PMCP_EnumPrinter			EnumPrinter;
	PMCP_OpenPrinter			OpenPrinter;
	PMCP_ClosePrinter			ClosePrinter;
	PMCP_GetPrinterInfo			GetPrinterInfo;
	PMCP_InitPrintSetting		InitPrintSetting;
	PMCP_SendPrintSetting		SendPrintSetting;
	PMCP_InitPrinterMemory		InitPrinterMemory;
	PMCP_SendImageAndPrint		SendImageAndPrint;
	PMCP_ReceivePrintedInfo		ReceivePrintedInfo;
	PMCP_ReceiveVerInfo			ReceiveVerInfo;
	PMCP_GetPrinterStatus		GetPrinterStatus;
	PMCP_GetPaperRemain			GetPaperRemain;
	PMCP_GetLastError			GetLastError;
	PMCP_CancelPrint			CancelPrint;
	PMCP_LutConversionForPrinter	LutConversionForPrinter;
	PMCP_Generate1dData			Generate1dData;   /* 2005/06/24 Ver.1.4.0 */
	PMCP_Create1dDataFile		Create1dDataFile; /* 2005/06/24 Ver.1.4.0 */
	PMCP_Delete1dDataFile		Delete1dDataFile; /* 2005/06/24 Ver.1.4.0 */
	PMCP_Search1dDataFile		Search1dDataFile; /* 2005/06/24 Ver.1.4.0 */
	PMCP_Do1dLut				Do1dLut;          /* 2005/06/24 Ver.1.4.0 */
	PMCP_Exec1dConversion		Exec1dConversion; /* 2005/06/24 Ver.1.4.0 */
	PMCP_SendImageAndMultiPrint	SendImageAndMultiPrint;/* 2005/07/04 Ver.1.4.1 */
	PMCP_SetUsbNo				SetUsbNo;              /* 2005/12/09 Ver.1.8.0 */
	PMCP_SetAutoRecoveryFlag	SetAutoRecoveryFlag;   /* 2005/12/09 Ver.1.8.0 */
	PMCP_StopPrint				StopPrint;             /* 2005/12/09 Ver.1.9.0 */
	PMCP_GetPrinterError		GetPrinterError;       /* 2006/03/13 Ver.2.3.0 */
	PMCP_Generate1dDataWithGammaCurve	Generate1dDataWithGammaCurve;	/* 2006/08/14 Ver.2.4.0 */
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	PMCP_SendImageAndThreeDivPrint	SendImageAndThreeDivPrint;
#endif

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	PMCP_Make1dDataLinear		Make1dDataLinear;
	PMCP_Make1dDataGammaCurve	Make1dDataGammaCurve;
#endif

#ifndef RET_VERSION_265		// nakashima addition 2008/02/10 Ver.2.6.6
	PMCP_ReceiveHeadPrintedInfo	ReceiveHeadPrintedInfo;
#endif

} SDK_FUNC;


/*	SDK import functions table		*/
extern SDK_FUNC		fnSDK;


/*	SDK DLL setup functions	*/
extern BOOL	loadNCSDK(void);
extern void	unloadNCSDK(void);


#ifdef __cplusplus
}
#endif


#endif /* __SDKSETUP_H__ */
