/************************************************************/
/*															*/
/*	File :	Debug.h											*/
/*															*/
/*	FUJIFILM Printer Control DLL							*/
/*		(Debug function header file)						*/
/*															*/
/*	Copyright (C) 2002-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#ifndef __DEBUG_H__
#define __DEBUG_H__


#include <windows.h>


///////////////////////////////////////////////////////////////////////////////
//
//	Macro
//

#define	_OK_NG(flag)		(flag ? "OK" : "NG" )
#define	_ON_OFF(flag)		(flag ? "ON" : "OFF" )
#define	_YES_NO(flag)		(flag ? "YES" : "NO" )
#define _DSC_SCN(flag)		(flag ? "SCN" : "DSC" )
#define	_NG_OK(flag)		(flag ? "NG" : "OK" )
#define	_MONOTONE(mode)		(mode==0 ? "OFF" : (mode==1 ? "B&W" : "SEPIA" ) )

///////////////////////////////////////////////////////////////////////////////
//
//	Function declaration for debugging
//


#ifdef LOGGING

//	Function group for log file output

	// Output beginning to log fileihModule : Module handle of Execution programj
	extern BOOL DEBUG_StartLog(HMODULE hModule);

	// Output beginning to log fileihModule : Module handle of Execution programj
	//	(LogFileTitle : Log file name(except extention))
	extern BOOL DEBUG_StartLog(HMODULE hModule, LPCSTR LogFileTitle);

	// Output end in log file
	extern void DEBUG_EndLog(void);

	// One line is output to the log file by the printf() form. iAutomatic changing linej
	extern BOOL DEBUG_LOG_PRINTF(const char *Format, ... );

	// Byte array data is output to the log file by the text form(Hexadecimal number row in 16 bytes a line). 
	// ipData: Data buffer, Size: Number of databytesj
	extern BOOL DEBUG_LOG_WRITE_DATA(PBYTE pData, WORD Size);

	// Set time stamp to filename
	extern	BOOL DEBUG_GetTimeStamp(char* filename);

	// One line is output to the log file by the printf() form. iAutomatic changing linej
	// For time measurement, set start time.
	extern	BOOL DEBUG_LOG_PRINTF_SET(DWORD &startTime, const char *Format, ... );

	
	// One line is output to the log file by the printf() form. iAutomatic changing linej
	// For time measurement, get the elapsed time .
	extern	BOOL DEBUG_LOG_PRINTF_TIME(DWORD startTime, const char *Format, ... );

#else

// The function is invalidated in the mode that doesn't output the log file. 
// (Please ..warning.. and use not (void)0 but __noop() in VC++.NET.) 
	#define DEBUG_StartLog					(void)0
	#define DEBUG_EndLog					(void)0
	#define DEBUG_LOG_PRINTF				(void)0
	#define DEBUG_LOG_WRITE_DATA			(void)0
	#define DEBUG_ReadIniFile				(void)0
	#define DEBUG_GetIniInfo				(void)0

	#define	DEBUG_GetTimeStamp				(void)0
	#define	DEBUG_LOG_PRINTF_SET			(void)0
	#define	DEBUG_LOG_PRINTF_TIME			(void)0
#endif


#endif	// #ifndef __DEBUG_H__
