/************************************************************/
/*															*/
/*	File :	DoPrint.cpp										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2005 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#include "stdafx.h"
#include "SDKSample.h"
#include "DoPrint.h"
#include "PrintDlg.h"
#include "Printer.h"
#include "LoadImg.h"
#include "OperateImg.h"

#include "Encode.h"// for Unicode Convert
#include "afxmt.h" // for CriticalSection

#include "Debug.h"// 2005/12/19 Ver.2.1.0

#ifdef	SAVE_BMP
#include "SaveBmp.h"
#endif


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// For multi print	// 2005/07/12 Ver.1.4.1
#define	GET_MULTI_JOB_COUNT( imageCnt )	( ( imageCnt%2 )==0 ? (imageCnt/2):(imageCnt/2+1) )

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
#define	GET_THREEDIV_JOB_COUNT( imageCnt )	( ( imageCnt%3 )==0 ? (imageCnt/3):(imageCnt/3+1) )
#endif

#ifndef RET_VER242	// nakashima addition 2007/05/14 Ver.2.4.3
#define	GET_NORMUL_JOB_COUNT( imageCnt ) (imageCnt/3*2+imageCnt%3)
#define	GET_MULNOR_JOB_COUNT( imageCnt )	( ( imageCnt%3 )==2 ? (imageCnt/3*2+imageCnt%3-1):(imageCnt/3*2+imageCnt%3) )
#endif

// Image Setup object
extern CSetupImgDll	g_setupImgDll;// 2005.5.27 mochida


///////////////////////////////////////////////////////////////////////////////
//
//	Constants definition
//


#ifdef	SAVE_BMP
#define	IMAGE_SAVE_BMP_FILENAME			"DPBSMP_%02d.bmp"
#endif



///////////////////////////////////////////////////////////////////////////////
//
//	Static values
//


// Struct for CDoPrint instance table
typedef struct {
	HANDLE		hPrinter;
	CDoPrint	*pDoPrint;
} DOPRINT_TABLE_INFO;

// CDoPrint instance table
static DOPRINT_TABLE_INFO		g_doPrintTbl[MAX_PRINTER_CNT];

// CriticalSection for Image setup
CCriticalSection    g_criticalSection_ImgSetup;

///////////////////////////////////////////////////////////////////////////////
//
//	Static functions
//



///////////////////////////////////////////////////////////////////////////////
//
//	class public method
//


// Constructor / Destructor
CDoPrint::CDoPrint()
{

	m_pParentDlg				= NULL;
	m_pPrinter					= NULL;
	m_pPrintImageList			= NULL;
	m_printImageCnt				= 0;
	ZeroMemory(&m_doPrintInfo, sizeof(m_doPrintInfo));
	m_sendingImageNo			= 0;
	m_printingImageNo			= 0;
	m_hSendImageEvent			= NULL;
	m_hPrintEndEvent			= NULL;
	m_hAllPrintEndEvent			= NULL;
	m_errInfo					= MCP_OK;
	m_pAppCallbackProc			= NULL;
	m_fCancel					= FALSE;
	m_fRecovering				= FALSE;
}

CDoPrint::~CDoPrint()
{

	CloseHandle(m_hSendImageEvent);
	CloseHandle(m_hPrintEndEvent);
	CloseHandle(m_hAllPrintEndEvent);

	// Un-resist printer handle and class instance to table.
	if (m_pPrinter != NULL) {
		g_doPrintTbl[m_pPrinter->GetPrinterNo()].hPrinter = NULL;
		g_doPrintTbl[m_pPrinter->GetPrinterNo()].pDoPrint = NULL;
	}

}


// Set target printer control information.
void CDoPrint::SetPrinterInfo(CPrinter* pPrinter)
{

	m_pPrinter = pPrinter;

	// Resist printer handle and class instance to table.
	g_doPrintTbl[m_pPrinter->GetPrinterNo()].hPrinter = m_pPrinter->GetHandle();
	g_doPrintTbl[m_pPrinter->GetPrinterNo()].pDoPrint = this;

}

//	Set CPrintDlg for display printing progress.
//	(pParentDlg : Pointer to CPrintDlg.)
void CDoPrint::SetParentDlg(CPrintDlg *pParentDlg)
{

	m_pParentDlg = pParentDlg;

}

// Set print images list.
// (pPrintImageList : Pointer to print images array.
// (PrintImageCnt   : Count of print images.)
void CDoPrint::SetImageList(const PPRINT_IMAGE_INFO pPrintImageList, int PrintImageCnt)
{

	m_pPrintImageList	= pPrintImageList;
	m_printImageCnt		= PrintImageCnt;

}

// Set print setting information.
// (DoPrintInfo : Print setting information.)
void CDoPrint::SetDoPrintInfo(DOPRINT_INFO DoPrintInfo)
{

	m_doPrintInfo	= DoPrintInfo;

}

// Start print and resister callback function for notify
// printing progress.
// (pAppCallbackProc;	[IN] Appication callback function address.)
// (Return value : BOOL; TRUE : O.K., FALSE : Error)
BOOL CDoPrint::StartPrint(PAPP_CALLBACK pAppCallbackProc)
{
	CWinThread	*thread;

	// Set parameter to pass print thread.
	m_pAppCallbackProc	= pAppCallbackProc;
	m_hSendImageEvent	= CreateEvent(NULL, FALSE, FALSE, NULL);
	m_hPrintEndEvent	= CreateEvent(NULL, FALSE, FALSE, NULL);
	m_hAllPrintEndEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

	m_fCancel			= FALSE;

	// Create printing thread.
	thread = AfxBeginThread(printingThreadProc, this, THREAD_PRIORITY_NORMAL, 0, 0);
	if (thread == NULL) {
		AfxMessageBox(IDS_ERR_BEGIN_PRINT_THREAD, MB_OK | MB_ICONSTOP);
		return	FALSE;
	}

	return	TRUE;
}

// Stop next print. (And call SDK MCP_CancelPrint().)
// (Return value : BOOL; TRUE : O.K., FALSE : Error)
// Last modify at 2005/12/19 Ver.2.0.0 
BOOL CDoPrint::StopPrint()
{

	if (!m_fRecovering) {
		// Cancel print (Send StopPrint command to printer).
		m_pPrinter->CancelPrint();
	} else {
		// Stop print (Clear Printer Buffur)
		m_pPrinter->StopPrint();
	}
	
	// Cancel send image.
	m_fCancel = TRUE;
	m_fRecovering = FALSE;
	return	TRUE;
}


// Print main process.
BOOL CDoPrint::DoNormalPrint()
{
	int					imageCount = m_printImageCnt;
	PPRINT_IMAGE_INFO	pImageList = m_pPrintImageList;
	int					i;
	POINT				paperSize;
	PRINT_INFO			printInfo;
	HANDLE				hLoadDib = NULL, hSendDib = NULL;
	BOOL				ret = TRUE;
	BOOL				fDisplayedErr = FALSE;
	BOOL				fSendedImage = FALSE;

	ISPL_INFO			IsplInfo;//2005/12/05 Ver.1.7.1
	BOOL				fImageSetup;// 2005.5.27 mochida
	BOOL				f1DLUT, f3DLUT;
	POINT				resultImageSize;
	BOOL				fPrinterCannotReceiveDataNow = FALSE;

	DWORD	dwTime = 0;	// For Log

	paperSize = m_doPrintInfo.PaperSize;
	fImageSetup = m_doPrintInfo.fImgSetup;// 2005.5.27 mochida
	f1DLUT = m_doPrintInfo.f1DLUT;	// 2005/12/05 Ver.1.7.1
	f3DLUT = m_doPrintInfo.f3DLUT;	// 2005/12/05 Ver.1.7.1
	IsplInfo = m_doPrintInfo.IsplInfo;	// 2005/12/05 Ver.1.7.1

	// Initial printer memory.
	if (!m_pPrinter->PrinterMemoryClear()) {
		ret = FALSE;
		goto	doNormalPrintExit;
	}

	SetEvent(m_hPrintEndEvent);
	m_sendingImageNo	= 0;
	m_printingImageNo	= 0;

	// Loop for print each image.
	for (i = 0; i < imageCount; i++) {

		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] Start", m_pPrinter->GetPrinterNo(), i);

		m_sendingImageNo = i;

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			goto	doNormalPrintExit;
		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

		// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
		// 2005/12/06 Ver.1.7.1
		if(!TotalImageSetup(i, hSendDib, resultImageSize)){
			ret = FALSE;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			goto	doNormalPrintExit;
		}

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);
#endif

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
#endif
			goto	doNormalPrintExit;
		}

		// Set print setteing parameter.
		printInfo = m_doPrintInfo.PrintInfo;
		printInfo.PrintSetting.ImageInfo.ImageData.x	= resultImageSize.x;
		printInfo.PrintSetting.ImageInfo.ImageData.y	= resultImageSize.y;
		printInfo.PrintSetting.ImageInfo.Offset.x		= 0;
		printInfo.PrintSetting.ImageInfo.Offset.y		= 0;
		printInfo.PrintSetting.PaperInfo.PaperSize.x	= paperSize.x;
		printInfo.PrintSetting.PaperInfo.PaperSize.y	= paperSize.y;

		// Send print setting to printer.
		// If printer is printing and cannot receive image data now, wait for until 1 copy print end.

		while (1) {

			// Send print setting to printer.
			DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] SendPrintSetting()", m_pPrinter->GetPrinterNo(), i);
			if (m_pPrinter->SendPrintSetting(printInfo, &fPrinterCannotReceiveDataNow)) {
				DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] SendPrintSetting() return %d", m_pPrinter->GetPrinterNo(), i, TRUE);
				// OK
				break;
			} else {
				if (fPrinterCannotReceiveDataNow) {
					// Printer is cannot receive image data now, wait for until 1 copy print end.
					m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);
					ResetEvent(m_hPrintEndEvent);

					DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] Waiting", m_pPrinter->GetPrinterNo(), i);
					WaitForSingleObject(m_hPrintEndEvent, INFINITE);
					if (m_errInfo != MCP_OK) {
						m_errInfo = MCP_OK;
						ret = FALSE;
						fDisplayedErr = TRUE;
						goto	doNormalPrintExit;
					}
					// Check whether print canceled.
					if (checkCanceledPrint(i)) {
						// Canceled
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
						m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
#endif
						goto	doNormalPrintExit;
					}
					// ==> Retry to send print setting to printer.
				} else {
					ret = FALSE;
					goto	doNormalPrintExit;
				}
			}

		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, printInfo.PrintSetting.wCopies, STATUS_SENDING, MCP_OK);

		// Send image and print.
		DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] SendImageAndPrint()", m_pPrinter->GetPrinterNo(), i);
		if (!m_pPrinter->SendImageAndPrint(hSendDib, normalPrintCallbackProc)) {
			ret = FALSE;
			goto	doNormalPrintExit;
		}
		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] SendImageAndPrint() return %d", m_pPrinter->GetPrinterNo(), i, ret);

		fSendedImage = TRUE;
		// MCP_SendImageAndPrint() function returns quickly because make thread for print.
		// Wait for send image end.
		WaitForSingleObject(m_hSendImageEvent, INFINITE);
		DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] CallBack_SendImage", m_pPrinter->GetPrinterNo(), i);
		if (m_errInfo != MCP_OK) {
			m_errInfo = MCP_OK;
			ret = FALSE;
			goto	doNormalPrintExit;
		}
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint().
		GlobalFree(hSendDib);
		hSendDib = NULL;

	}	// Loop end for print each image.

doNormalPrintExit:
	
	if (fSendedImage) {
		if (ret) {
			// Wait for all print end.
			WaitForSingleObject(m_hAllPrintEndEvent, INFINITE);
			if (m_errInfo != MCP_OK) {
				ret = FALSE;
			}
		} else if (!fDisplayedErr) {
			// Display error.
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
		}
	} else {// 2005/12/19 Ver.2.0.0
		m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
	}
	if (hLoadDib != NULL) {
		GlobalFree(hLoadDib);
	}
	if (hSendDib != NULL) {
		GlobalFree(hSendDib);
	}

	return	ret;
}


// Multi Print main process.
// 2005/07/12 Ver.1.4.1
BOOL CDoPrint::DoMultiPrint()
{
	int					imageCount = m_printImageCnt;
	PPRINT_IMAGE_INFO	pImageList = m_pPrintImageList;
	int					i = 0;
	POINT				paperSize, resultImageSize;
	PRINT_INFO			printInfo;
	HANDLE				hSendDib = NULL;
	HANDLE				hSendDib2 = NULL;
	BOOL				ret = TRUE;
	BOOL				fDisplayedErr = FALSE;
	BOOL				fSendedImage = FALSE;
	BOOL				fPrinterCannotReceiveDataNow = FALSE;
	int					sendingJobNo;
	int					nImageCnt = 0;
	int					j = 0;

	paperSize = m_doPrintInfo.PaperSize;

	// Initial printer memory.
	if (!m_pPrinter->PrinterMemoryClear()) {
		ret = FALSE;
		goto	doMultiPrintExit;
	}

	SetEvent(m_hPrintEndEvent);
	m_sendingImageNo	= 0;
	m_printingImageNo	= 0;

	sendingJobNo = 0;
	m_printImageCnt = GET_MULTI_JOB_COUNT( m_printImageCnt );

	// Loop for print each image.
	while(1){
		nImageCnt = 0;
		m_sendingImageNo = sendingJobNo;

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
			goto	doMultiPrintExit;
		}
		
		// 1st image
		nImageCnt++;
		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

		// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
		// Modify at 2005/12/06 Ver.1.7.1
		if(!TotalImageSetup(i, hSendDib, resultImageSize)){
			ret = FALSE;
			goto	doMultiPrintExit;
		}

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
#else
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
#endif
			goto	doMultiPrintExit;
		}

		// 2nd image
		i++;
		if( i == imageCount ){
			hSendDib2 = NULL;
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
#endif
		}
		else{
			nImageCnt++;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

			// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
			if(!TotalImageSetup(i, hSendDib2, resultImageSize)){
				ret = FALSE;
				goto	doMultiPrintExit;
			}
		}

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);
#endif

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
			for( j = 0; j < nImageCnt; j++) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
			}
#else
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
#endif
			goto	doMultiPrintExit;
		}

		// Set print setteing parameter.
		printInfo = m_doPrintInfo.PrintInfo;
		printInfo.PrintSetting.ImageInfo.ImageData.x	= paperSize.x;
		printInfo.PrintSetting.ImageInfo.ImageData.y	= paperSize.y;
		printInfo.PrintSetting.ImageInfo.Offset.x		= 0;
		printInfo.PrintSetting.ImageInfo.Offset.y		= 0;
		// Notice: K size is set in parameter though the size of the ribbon is "6x8/9".
		printInfo.PrintSetting.PaperInfo.PaperSize.x	= paperSize.x;
		printInfo.PrintSetting.PaperInfo.PaperSize.y	= paperSize.y;

		// Send print setting to printer.
		// If printer is printing and cannot receive image data now, wait for until 1 copy print end.

		while (1) {

			// Send print setting to printer.
			if (m_pPrinter->SendPrintSetting(printInfo, &fPrinterCannotReceiveDataNow)) {
				// OK
				break;
			} else {
				if (fPrinterCannotReceiveDataNow) {
					// Printer is cannot receive image data now, wait for until 1 copy print end.
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
					for( j = 0; j < nImageCnt; j++) {
						m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_WAITING, MCP_OK);
					}
#else
					m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
					m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);
#endif
					
					ResetEvent(m_hPrintEndEvent);
					WaitForSingleObject(m_hPrintEndEvent, INFINITE);
					if (m_errInfo != MCP_OK) {
						m_errInfo = MCP_OK;
						ret = FALSE;
						fDisplayedErr = TRUE;
						goto	doMultiPrintExit;
					}
					// Check whether print canceled.
					if (checkCanceledPrint(i)) {
						// Canceled
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
						for( j = 0; j < nImageCnt; j++) {
							m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
						}
#else
						m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_CANCEL, MCP_OK);
						m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
#endif
						goto	doMultiPrintExit;
					}
					// ==> Retry to send print setting to printer.
				} else {
					ret = FALSE;
					m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
					goto	doMultiPrintExit;
				}
			}

		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), sendingJobNo, 0, printInfo.PrintSetting.wCopies, STATUS_SENDING, MCP_OK);

		// Send image and print.( 1st and 2nd image )
		if (!m_pPrinter->SendImageAndMultiPrint(hSendDib, hSendDib2, normalPrintCallbackProc)) {
			ret = FALSE;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			goto	doMultiPrintExit;
		}
		fSendedImage = TRUE;
		// MCP_SendImageAndPrint() function returns quickly because make thread for print.
		// Wait for send image end.
		WaitForSingleObject(m_hSendImageEvent, INFINITE);
		if (m_errInfo != MCP_OK) {
			m_errInfo = MCP_OK;
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint().
		GlobalFree(hSendDib);
		GlobalFree(hSendDib2);
		hSendDib = NULL;
		hSendDib2 = NULL;

		i++;
		sendingJobNo++;

		if( i>=imageCount ){
			break;
		}
	}	// Loop end for print each image.

doMultiPrintExit:

	if (fSendedImage) {
		if (ret) {
			// Wait for all print end.
			WaitForSingleObject(m_hAllPrintEndEvent, INFINITE);
			if (m_errInfo != MCP_OK) {
				ret = FALSE;
			}
		} else if (!fDisplayedErr) {
			// Display error.
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
			for( j = 0; j < nImageCnt; j++) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_ERROR, MCP_OK);
			}
#else
//			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_ERROR, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_ERROR, MCP_OK);
#endif
		}
	}
	if (hSendDib != NULL) {
		GlobalFree(hSendDib);
	}
	if (hSendDib2 != NULL) {
		GlobalFree(hSendDib2);
	}
	return	ret;
}

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
BOOL CDoPrint::DoThreeDivPrint()
{
	int					imageCount = m_printImageCnt;
	PPRINT_IMAGE_INFO	pImageList = m_pPrintImageList;
	int					i = 0;
	POINT				paperSize, resultImageSize;
	PRINT_INFO			printInfo;
	HANDLE				hSendDib = NULL;
	HANDLE				hSendDib2 = NULL;
	HANDLE				hSendDib3 = NULL;
	BOOL				ret = TRUE;
	BOOL				fDisplayedErr = FALSE;
	BOOL				fSendedImage = FALSE;
	BOOL				fPrinterCannotReceiveDataNow = FALSE;
	int					sendingJobNo;
	int					nImageCnt = 0;
	int					j = 0;

	paperSize = m_doPrintInfo.PaperSize;

	// Initial printer memory.
	if (!m_pPrinter->PrinterMemoryClear()) {
		ret = FALSE;
		goto	doMultiPrintExit;
	}

	SetEvent(m_hPrintEndEvent);
	m_sendingImageNo	= 0;
	m_printingImageNo	= 0;

	sendingJobNo = 0;
	m_printImageCnt = GET_THREEDIV_JOB_COUNT( m_printImageCnt );

	// Loop for print each image.
	while(1){
		nImageCnt = 0;
		m_sendingImageNo = sendingJobNo;

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+2, 0, 0, STATUS_CANCEL, MCP_OK);
			goto	doMultiPrintExit;
		}
		
		// 1st image
		nImageCnt++;
		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

		// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
		// Modify at 2005/12/06 Ver.1.7.1
		if(!TotalImageSetup(i, hSendDib, resultImageSize)){
			ret = FALSE;
			goto	doMultiPrintExit;
		}

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+2, 0, 0, STATUS_CANCEL, MCP_OK);
			goto	doMultiPrintExit;
		}

		// 2nd image
		i++;
		if( i == imageCount ){
			hSendDib2 = NULL;
			hSendDib3 = NULL;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
		}
		else{
			nImageCnt++;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

			// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
			if(!TotalImageSetup(i, hSendDib2, resultImageSize)){
				ret = FALSE;
				goto	doMultiPrintExit;
			}
		}

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
			goto	doMultiPrintExit;
		}

		if(nImageCnt == 2) {
			// 3rd image
			i++;
			if( i == imageCount ){
				hSendDib3 = NULL;
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
			}
			else{
				nImageCnt++;
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-2, 0, 0, STATUS_WAITING, MCP_OK);
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

				// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
				if(!TotalImageSetup(i, hSendDib3, resultImageSize)){
					ret = FALSE;
					goto	doMultiPrintExit;
				}
			}
		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			for( j = 0; j < nImageCnt; j++) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
			}
			goto	doMultiPrintExit;
		}

		// Set print setteing parameter.
		printInfo = m_doPrintInfo.PrintInfo;
		printInfo.PrintSetting.ImageInfo.ImageData.x	= paperSize.x;
		printInfo.PrintSetting.ImageInfo.ImageData.y	= paperSize.y;
		printInfo.PrintSetting.ImageInfo.Offset.x		= 0;
		printInfo.PrintSetting.ImageInfo.Offset.y		= 0;
		// Notice: K size is set in parameter though the size of the ribbon is "6x8/9".
		printInfo.PrintSetting.PaperInfo.PaperSize.x	= paperSize.x;
		printInfo.PrintSetting.PaperInfo.PaperSize.y	= paperSize.y;

		// Send print setting to printer.
		// If printer is printing and cannot receive image data now, wait for until 1 copy print end.

		while (1) {

			// Send print setting to printer.
			if (m_pPrinter->SendPrintSetting(printInfo, &fPrinterCannotReceiveDataNow)) {
				// OK
				break;
			} else {
				if (fPrinterCannotReceiveDataNow) {
					// Printer is cannot receive image data now, wait for until 1 copy print end.
					for( j = 0; j < nImageCnt; j++) {
						m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_WAITING, MCP_OK);
					}
					
					ResetEvent(m_hPrintEndEvent);
					WaitForSingleObject(m_hPrintEndEvent, INFINITE);
					if (m_errInfo != MCP_OK) {
						m_errInfo = MCP_OK;
						ret = FALSE;
						fDisplayedErr = TRUE;
						goto	doMultiPrintExit;
					}
					// Check whether print canceled.
					if (checkCanceledPrint(i)) {
						// Canceled
						for( j = 0; j < nImageCnt; j++) {
							m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
						}
						goto	doMultiPrintExit;
					}
					// ==> Retry to send print setting to printer.
				} else {
					ret = FALSE;
					m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
					goto	doMultiPrintExit;
				}
			}

		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), sendingJobNo, 0, printInfo.PrintSetting.wCopies, STATUS_SENDING, MCP_OK);

		// Send image and print.( 1st and 2nd and 3rd image )
		if (!m_pPrinter->SendImageAndThreeDivPrint(hSendDib, hSendDib2, hSendDib3, normalPrintCallbackProc)) {
			ret = FALSE;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			goto	doMultiPrintExit;
		}
		fSendedImage = TRUE;
		// MCP_SendImageAndPrint() function returns quickly because make thread for print.
		// Wait for send image end.
		WaitForSingleObject(m_hSendImageEvent, INFINITE);
		if (m_errInfo != MCP_OK) {
			m_errInfo = MCP_OK;
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint().
		GlobalFree(hSendDib);
		GlobalFree(hSendDib2);
		GlobalFree(hSendDib3);
		hSendDib = NULL;
		hSendDib2 = NULL;
		hSendDib3 = NULL;

		i++;
		sendingJobNo++;

		if( i>=imageCount ){
			break;
		}
	}	// Loop end for print each image.

doMultiPrintExit:

	if (fSendedImage) {
		if (ret) {
			// Wait for all print end.
			WaitForSingleObject(m_hAllPrintEndEvent, INFINITE);
			if (m_errInfo != MCP_OK) {
				ret = FALSE;
			}
		} else if (!fDisplayedErr) {
			// Display error.
			for( j = 0; j < nImageCnt; j++) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_ERROR, MCP_OK);
			}
		}
	}
	if (hSendDib != NULL) {
		GlobalFree(hSendDib);
	}
	if (hSendDib2 != NULL) {
		GlobalFree(hSendDib2);
	}
	if (hSendDib3 != NULL) {
		GlobalFree(hSendDib3);
	}

	return	ret;
}
#endif

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
BOOL CDoPrint::DoNorMulPrint(DWORD dwYSize)
{
	int					imageCount = m_printImageCnt;
	PPRINT_IMAGE_INFO	pImageList = m_pPrintImageList;
	int					i = 0;
	POINT				paperSize, resultImageSize;
	PRINT_INFO			printInfo;
	HANDLE				hSendDib = NULL;
	HANDLE				hSendDib2 = NULL;
	BOOL				ret = TRUE;
	BOOL				fDisplayedErr = FALSE;
	BOOL				fSendedImage = FALSE;
	BOOL				fPrinterCannotReceiveDataNow = FALSE;
	int					nImageCnt = 0;
	int					j = 0;

	int	sendingJobNo;

	DWORD	dwTime = 0;	// For Log

	paperSize = m_doPrintInfo.PaperSize;

	// Initial printer memory.
	if (!m_pPrinter->PrinterMemoryClear()) {
		ret = FALSE;
		goto	doMultiPrintExit;
	}

	SetEvent(m_hPrintEndEvent);
	m_sendingImageNo	= 0;
	m_printingImageNo	= 0;

	sendingJobNo = 0;
	m_printImageCnt = GET_NORMUL_JOB_COUNT( m_printImageCnt );

	// Loop for print each image.
	while(1){

		m_doPrintInfo.PaperSize.x = MCP_PAPER_WIDTH_K;
		m_doPrintInfo.PaperSize.y = dwYSize;
//		m_doPrintInfo.PaperSize.y = MCP_PAPER_HEIGHT_6X8;
		paperSize = m_doPrintInfo.PaperSize;

		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] Start", m_pPrinter->GetPrinterNo(), i);

		m_sendingImageNo = sendingJobNo;

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			goto	doMultiPrintExit;
		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

		// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
		// 2005/12/06 Ver.1.7.1
		if(!TotalImageSetup(i, hSendDib, resultImageSize)){
			ret = FALSE;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			goto	doMultiPrintExit;
		}

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			goto	doMultiPrintExit;
		}

		// Set print setteing parameter.
		printInfo = m_doPrintInfo.PrintInfo;
		printInfo.PrintSetting.ImageInfo.ImageData.x	= resultImageSize.x;
		printInfo.PrintSetting.ImageInfo.ImageData.y	= resultImageSize.y;
		printInfo.PrintSetting.ImageInfo.Offset.x		= 0;
		printInfo.PrintSetting.ImageInfo.Offset.y		= 0;
		printInfo.PrintSetting.PaperInfo.PaperSize.x	= paperSize.x;
		printInfo.PrintSetting.PaperInfo.PaperSize.y	= paperSize.y;

		// Send print setting to printer.
		// If printer is printing and cannot receive image data now, wait for until 1 copy print end.

		while (1) {

			// Send print setting to printer.
			DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] SendPrintSetting()", m_pPrinter->GetPrinterNo(), i);
			if (m_pPrinter->SendPrintSetting(printInfo, &fPrinterCannotReceiveDataNow)) {
				DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] SendPrintSetting() return %d", m_pPrinter->GetPrinterNo(), i, TRUE);
				// OK
				break;
			} else {
				if (fPrinterCannotReceiveDataNow) {
					// Printer is cannot receive image data now, wait for until 1 copy print end.
					m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);
					ResetEvent(m_hPrintEndEvent);

					DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] Waiting", m_pPrinter->GetPrinterNo(), i);
					WaitForSingleObject(m_hPrintEndEvent, INFINITE);
					if (m_errInfo != MCP_OK) {
						m_errInfo = MCP_OK;
						ret = FALSE;
						fDisplayedErr = TRUE;
						goto	doMultiPrintExit;
					}
					// Check whether print canceled.
					if (checkCanceledPrint(i)) {
						// Canceled
						goto	doMultiPrintExit;
					}
					// ==> Retry to send print setting to printer.
				} else {
					ret = FALSE;
					goto	doMultiPrintExit;
				}
			}

		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, printInfo.PrintSetting.wCopies, STATUS_SENDING, MCP_OK);

		// Send image and print.
		DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] SendImageAndPrint()", m_pPrinter->GetPrinterNo(), i);
		if (!m_pPrinter->SendImageAndPrint(hSendDib, normalPrintCallbackProc)) {
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] SendImageAndPrint() return %d", m_pPrinter->GetPrinterNo(), i, ret);

		fSendedImage = TRUE;
		// MCP_SendImageAndPrint() function returns quickly because make thread for print.
		// Wait for send image end.
		WaitForSingleObject(m_hSendImageEvent, INFINITE);
		DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] CallBack_SendImage", m_pPrinter->GetPrinterNo(), i);
		if (m_errInfo != MCP_OK) {
			m_errInfo = MCP_OK;
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint().
		GlobalFree(hSendDib);
		hSendDib = NULL;

		i++;
		sendingJobNo++;

		if( i>=imageCount ){
			break;
		}

// *******************************

		m_doPrintInfo.PaperSize.x = MCP_PAPER_WIDTH_K;
		m_doPrintInfo.PaperSize.y = MCP_PAPER_HEIGHT_K;
		paperSize = m_doPrintInfo.PaperSize;
		
		nImageCnt = 0;
		m_sendingImageNo = sendingJobNo;

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
			goto	doMultiPrintExit;
		}
		
		// 1st image
		nImageCnt++;
		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

		// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
		// Modify at 2005/12/06 Ver.1.7.1
		if(!TotalImageSetup(i, hSendDib, resultImageSize)){
			ret = FALSE;
			goto	doMultiPrintExit;
		}

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
#else
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
#endif
			goto	doMultiPrintExit;
		}

		// 2nd image
		i++;
		if( i == imageCount ){
			hSendDib2 = NULL;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
		}
		else{
			nImageCnt++;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

			// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
			if(!TotalImageSetup(i, hSendDib2, resultImageSize)){
				ret = FALSE;
				goto	doMultiPrintExit;
			}
		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			for( j = 0; j < nImageCnt; j++) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
			}
			goto	doMultiPrintExit;
		}

		// Set print setteing parameter.
		printInfo = m_doPrintInfo.PrintInfo;
		printInfo.PrintSetting.ImageInfo.ImageData.x	= paperSize.x;
		printInfo.PrintSetting.ImageInfo.ImageData.y	= paperSize.y;
		printInfo.PrintSetting.ImageInfo.Offset.x		= 0;
		printInfo.PrintSetting.ImageInfo.Offset.y		= 0;
		// Notice: K size is set in parameter though the size of the ribbon is "6x8/9".
		printInfo.PrintSetting.PaperInfo.PaperSize.x	= paperSize.x;
		printInfo.PrintSetting.PaperInfo.PaperSize.y	= paperSize.y;

		// Send print setting to printer.
		// If printer is printing and cannot receive image data now, wait for until 1 copy print end.

		while (1) {

			// Send print setting to printer.
			if (m_pPrinter->SendPrintSetting(printInfo, &fPrinterCannotReceiveDataNow)) {
				// OK
				break;
			} else {
				if (fPrinterCannotReceiveDataNow) {
					// Printer is cannot receive image data now, wait for until 1 copy print end.
					for( j = 0; j < nImageCnt; j++) {
						m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_WAITING, MCP_OK);
					}
				
					ResetEvent(m_hPrintEndEvent);
					WaitForSingleObject(m_hPrintEndEvent, INFINITE);
					if (m_errInfo != MCP_OK) {
						m_errInfo = MCP_OK;
						ret = FALSE;
						fDisplayedErr = TRUE;
						goto	doMultiPrintExit;
					}
					// Check whether print canceled.
					if (checkCanceledPrint(i)) {
						// Canceled
						for( j = 0; j < nImageCnt; j++) {
							m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
						}
						goto	doMultiPrintExit;
					}
					// ==> Retry to send print setting to printer.
				} else {
					ret = FALSE;
					m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
					goto	doMultiPrintExit;
				}
			}

		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), sendingJobNo, 0, printInfo.PrintSetting.wCopies, STATUS_SENDING, MCP_OK);

		// Send image and print.( 1st and 2nd image )
		if (!m_pPrinter->SendImageAndMultiPrint(hSendDib, hSendDib2, normalPrintCallbackProc)) {
			ret = FALSE;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			goto	doMultiPrintExit;
		}
		fSendedImage = TRUE;
		// MCP_SendImageAndPrint() function returns quickly because make thread for print.
		// Wait for send image end.
		WaitForSingleObject(m_hSendImageEvent, INFINITE);
		if (m_errInfo != MCP_OK) {
			m_errInfo = MCP_OK;
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint().
		GlobalFree(hSendDib);
		GlobalFree(hSendDib2);
		hSendDib = NULL;
		hSendDib2 = NULL;

		i++;
		sendingJobNo++;

		if( i>=imageCount ){
			break;
		}
	}	// Loop end for print each image.

doMultiPrintExit:

	if (fSendedImage) {
		if (ret) {
			// Wait for all print end.
			WaitForSingleObject(m_hAllPrintEndEvent, INFINITE);
			if (m_errInfo != MCP_OK) {
				ret = FALSE;
			}
		} else if (!fDisplayedErr) {
			// Display error.
//			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			if( (sendingJobNo % 2) == 0) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_ERROR, MCP_OK);
			}
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_ERROR, MCP_OK);
		}
	}
	if (hSendDib != NULL) {
		GlobalFree(hSendDib);
	}
	if (hSendDib2 != NULL) {
		GlobalFree(hSendDib2);
	}
	return	ret;
}
#endif

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
BOOL CDoPrint::DoMulNorPrint(DWORD dwYSize)
{
	int					imageCount = m_printImageCnt;
	PPRINT_IMAGE_INFO	pImageList = m_pPrintImageList;
	int					i = 0;
	POINT				paperSize, resultImageSize;
	PRINT_INFO			printInfo;
	HANDLE				hSendDib = NULL;
	HANDLE				hSendDib2 = NULL;
	BOOL				ret = TRUE;
	BOOL				fDisplayedErr = FALSE;
	BOOL				fSendedImage = FALSE;
	BOOL				fPrinterCannotReceiveDataNow = FALSE;
	int					nImageCnt = 0;
	int					j = 0;

	int	sendingJobNo;

	DWORD	dwTime = 0;	// For Log

	paperSize = m_doPrintInfo.PaperSize;

	// Initial printer memory.
	if (!m_pPrinter->PrinterMemoryClear()) {
		ret = FALSE;
		goto	doMultiPrintExit;
	}

	SetEvent(m_hPrintEndEvent);
	m_sendingImageNo	= 0;
	m_printingImageNo	= 0;

	sendingJobNo = 0;
	m_printImageCnt = GET_MULNOR_JOB_COUNT( m_printImageCnt );

	// Loop for print each image.
	while(1){

		m_doPrintInfo.PaperSize.x = MCP_PAPER_WIDTH_K;
		m_doPrintInfo.PaperSize.y = MCP_PAPER_HEIGHT_K;
		paperSize = m_doPrintInfo.PaperSize;
		
		m_sendingImageNo = sendingJobNo;
		nImageCnt = 0;

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
			goto	doMultiPrintExit;
		}
		
		// 1st image
		nImageCnt++;
		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

		// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
		// Modify at 2005/12/06 Ver.1.7.1
		if(!TotalImageSetup(i, hSendDib, resultImageSize)){
			ret = FALSE;
			goto	doMultiPrintExit;
		}

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i+1, 0, 0, STATUS_CANCEL, MCP_OK);
#else
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_CANCEL, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
#endif
			goto	doMultiPrintExit;
		}

		// 2nd image
		i++;
		if( i == imageCount ){
			hSendDib2 = NULL;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
		}
		else{
			nImageCnt++;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

			// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
			if(!TotalImageSetup(i, hSendDib2, resultImageSize)){
				ret = FALSE;
				goto	doMultiPrintExit;
			}
		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_WAITING, MCP_OK);

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			for( j = 0; j < nImageCnt; j++) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
			}
			goto	doMultiPrintExit;
		}

		// Set print setteing parameter.
		printInfo = m_doPrintInfo.PrintInfo;
		printInfo.PrintSetting.ImageInfo.ImageData.x	= paperSize.x;
		printInfo.PrintSetting.ImageInfo.ImageData.y	= paperSize.y;
		printInfo.PrintSetting.ImageInfo.Offset.x		= 0;
		printInfo.PrintSetting.ImageInfo.Offset.y		= 0;
		// Notice: K size is set in parameter though the size of the ribbon is "6x8/9".
		printInfo.PrintSetting.PaperInfo.PaperSize.x	= paperSize.x;
		printInfo.PrintSetting.PaperInfo.PaperSize.y	= paperSize.y;

		// Send print setting to printer.
		// If printer is printing and cannot receive image data now, wait for until 1 copy print end.

		while (1) {

			// Send print setting to printer.
			if (m_pPrinter->SendPrintSetting(printInfo, &fPrinterCannotReceiveDataNow)) {
				// OK
				break;
			} else {
				if (fPrinterCannotReceiveDataNow) {
					// Printer is cannot receive image data now, wait for until 1 copy print end.
					for( j = 0; j < nImageCnt; j++) {
						m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_WAITING, MCP_OK);
					}
				
					ResetEvent(m_hPrintEndEvent);
					WaitForSingleObject(m_hPrintEndEvent, INFINITE);
					if (m_errInfo != MCP_OK) {
						m_errInfo = MCP_OK;
						ret = FALSE;
						fDisplayedErr = TRUE;
						goto	doMultiPrintExit;
					}
					// Check whether print canceled.
					if (checkCanceledPrint(i)) {
						// Canceled
						for( j = 0; j < nImageCnt; j++) {
							m_pAppCallbackProc(m_pPrinter->GetHandle(), i-j, 0, 0, STATUS_CANCEL, MCP_OK);
						}
						goto	doMultiPrintExit;
					}
					// ==> Retry to send print setting to printer.
				} else {
					ret = FALSE;
					m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
					goto	doMultiPrintExit;
				}
			}

		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), sendingJobNo, 0, printInfo.PrintSetting.wCopies, STATUS_SENDING, MCP_OK);

		// Send image and print.( 1st and 2nd image )
		if (!m_pPrinter->SendImageAndMultiPrint(hSendDib, hSendDib2, normalPrintCallbackProc)) {
			ret = FALSE;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			goto	doMultiPrintExit;
		}
		fSendedImage = TRUE;
		// MCP_SendImageAndPrint() function returns quickly because make thread for print.
		// Wait for send image end.
		WaitForSingleObject(m_hSendImageEvent, INFINITE);
		if (m_errInfo != MCP_OK) {
			m_errInfo = MCP_OK;
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint().
		GlobalFree(hSendDib);
		GlobalFree(hSendDib2);
		hSendDib = NULL;
		hSendDib2 = NULL;

	//	ResetEvent(m_hPrintEndEvent);
	//	WaitForSingleObject(m_hPrintEndEvent, INFINITE);

		i++;
		sendingJobNo++;

		if( i>=imageCount ){
			break;
		}

// ******************************

		m_doPrintInfo.PaperSize.x = MCP_PAPER_WIDTH_K;
		m_doPrintInfo.PaperSize.y = dwYSize;
//		m_doPrintInfo.PaperSize.y = MCP_PAPER_HEIGHT_6X8;
		paperSize = m_doPrintInfo.PaperSize;

		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] Start", m_pPrinter->GetPrinterNo(), i);

		m_sendingImageNo = sendingJobNo;

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			goto	doMultiPrintExit;
		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_IMAGESETUP, MCP_OK);

		// Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
		// 2005/12/06 Ver.1.7.1
		if(!TotalImageSetup(i, hSendDib, resultImageSize)){
			ret = FALSE;
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			goto	doMultiPrintExit;
		}

		// Check whether print canceled.
		if (checkCanceledPrint(i)) {
			// Canceled
			goto	doMultiPrintExit;
		}

		// Set print setteing parameter.
		printInfo = m_doPrintInfo.PrintInfo;
		printInfo.PrintSetting.ImageInfo.ImageData.x	= resultImageSize.x;
		printInfo.PrintSetting.ImageInfo.ImageData.y	= resultImageSize.y;
		printInfo.PrintSetting.ImageInfo.Offset.x		= 0;
		printInfo.PrintSetting.ImageInfo.Offset.y		= 0;
		printInfo.PrintSetting.PaperInfo.PaperSize.x	= paperSize.x;
		printInfo.PrintSetting.PaperInfo.PaperSize.y	= paperSize.y;

		// Send print setting to printer.
		// If printer is printing and cannot receive image data now, wait for until 1 copy print end.

		while (1) {
//			Sleep(20000);
			// Send print setting to printer.
			DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] SendPrintSetting()", m_pPrinter->GetPrinterNo(), i);
			if (m_pPrinter->SendPrintSetting(printInfo, &fPrinterCannotReceiveDataNow)) {
				DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] SendPrintSetting() return %d", m_pPrinter->GetPrinterNo(), i, TRUE);
				// OK
				break;
			} else {
				if (fPrinterCannotReceiveDataNow) {
					// Printer is cannot receive image data now, wait for until 1 copy print end.
					m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_WAITING, MCP_OK);
					ResetEvent(m_hPrintEndEvent);

					DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] Waiting", m_pPrinter->GetPrinterNo(), i);
					WaitForSingleObject(m_hPrintEndEvent, INFINITE);
					if (m_errInfo != MCP_OK) {
						m_errInfo = MCP_OK;
						ret = FALSE;
						fDisplayedErr = TRUE;
						goto	doMultiPrintExit;
					}
					// Check whether print canceled.
					if (checkCanceledPrint(i)) {
						// Canceled
						goto	doMultiPrintExit;
					}
					// ==> Retry to send print setting to printer.
				} else {
					ret = FALSE;
					goto	doMultiPrintExit;
				}
			}

		}

		m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, printInfo.PrintSetting.wCopies, STATUS_SENDING, MCP_OK);

		// Send image and print.
		DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] SendImageAndPrint()", m_pPrinter->GetPrinterNo(), i);
		if (!m_pPrinter->SendImageAndPrint(hSendDib, normalPrintCallbackProc)) {
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] SendImageAndPrint() return %d", m_pPrinter->GetPrinterNo(), i, ret);

		fSendedImage = TRUE;
		// MCP_SendImageAndPrint() function returns quickly because make thread for print.
		// Wait for send image end.
		WaitForSingleObject(m_hSendImageEvent, INFINITE);
		DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] CallBack_SendImage", m_pPrinter->GetPrinterNo(), i);
		if (m_errInfo != MCP_OK) {
			m_errInfo = MCP_OK;
			ret = FALSE;
			goto	doMultiPrintExit;
		}
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint().
		GlobalFree(hSendDib);
		hSendDib = NULL;

		i++;
		sendingJobNo++;

		if( i>=imageCount ){
			break;
		}

	}	// Loop end for print each image.

doMultiPrintExit:

	if (fSendedImage) {
		if (ret) {
			// Wait for all print end.
			WaitForSingleObject(m_hAllPrintEndEvent, INFINITE);
			if (m_errInfo != MCP_OK) {
				ret = FALSE;
			}
		} else if (!fDisplayedErr) {
			// Display error.
//			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_sendingImageNo, 0, 0, STATUS_ERROR, MCP_OK);
			if( (sendingJobNo % 2) == 0) {
				m_pAppCallbackProc(m_pPrinter->GetHandle(), i-1, 0, 0, STATUS_ERROR, MCP_OK);
			}
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_ERROR, MCP_OK);
		}
	}
	if (hSendDib != NULL) {
		GlobalFree(hSendDib);
	}
	if (hSendDib2 != NULL) {
		GlobalFree(hSendDib2);
	}
	return	ret;
}
#endif

// Update print progress display by called SDK callback function.
void CDoPrint::UpdatePrintProgress(PMCP_PRINTINGINFO pPrintingInfo, DWORD dwErrorInfo)
{
	HWND	hWnd;// 2005.6.8 mochida
	CString srtProductName;
	m_pPrinter->GetProductName(srtProductName);

	int JobNo = pPrintingInfo->wJobNumber - 1;

	// Error
	if (dwErrorInfo != MCP_OK) {// Update 2005.6.8 mochida
		m_pAppCallbackProc(m_pPrinter->GetHandle(), pPrintingInfo->wJobNumber - 1, 0, 0, STATUS_ERROR, dwErrorInfo);

		// If error is not recoverable. print processing is end.
		if( !m_pPrinter->IsRecoverable() ){
			m_errInfo = dwErrorInfo;
			m_pPrinter->ResetRecoverableFlag();			
			SetEvent(m_hSendImageEvent);
			SetEvent(m_hPrintEndEvent);
			SetEvent(m_hAllPrintEndEvent);
			return;
		}
		return;
	}

	switch (pPrintingInfo->bDetailStatus) {
	case MCP_PRINTERSTATUS_START_SENDING:	// 2005/05/11 Ver.1.2.0 
		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] STATUS_START_SENDING", m_pPrinter->GetPrinterNo(), JobNo);
		// Send image data complete. ==> You can free DIB data memory indicate to MCP_SendImageAndPrint() and start to prepare next image.
		SetEvent(m_hSendImageEvent);
		break;
	case MCP_PRINTERSTATUS_SEND_COMPLETE:
		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] STATUS_SEND_COMPLETE", m_pPrinter->GetPrinterNo(), JobNo);
		if (srtProductName == "DPB-1000"){// 2005/08/26 Ver.1.6.1
			SetEvent(m_hSendImageEvent);
		}

		// Send image data complete. ==> Change display only.	// 2005/05/11 Ver.1.2.0
		if( pPrintingInfo->wJobNumber - 1 != 0 ){// 1st image is not display  // 2005/07/12 Ver.1.4.1 
			m_pAppCallbackProc(m_pPrinter->GetHandle(), pPrintingInfo->wJobNumber - 1, pPrintingInfo->wPrintedNumber, pPrintingInfo->wPrintRequestNumber, STATUS_SPOOLED, MCP_OK);
		}
		break;
	case MCP_PRINTERSTATUS_PRINTING:
		// Printing
		DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] STATUS_PRINTING", m_pPrinter->GetPrinterNo(), JobNo);
		m_pAppCallbackProc(m_pPrinter->GetHandle(), pPrintingInfo->wJobNumber - 1, pPrintingInfo->wPrintedNumber, pPrintingInfo->wPrintRequestNumber, STATUS_PRINTING, MCP_OK);
		if (pPrintingInfo->wPrintedNumber > 0) {
			// 1 copy print ended. ==> You may be able to send next image.
			m_pPrinter->ResetRecoverableFlag();			
			SetEvent(m_hPrintEndEvent);
			
/* 2006/01/05 Ver.2.1.1
			// Let update display of printer remain copies.
			m_pParentDlg->LetUpdatePrinterRemainPaperCopies();
*/
		}
		if (pPrintingInfo->wPrintedNumber == pPrintingInfo->wPrintRequestNumber) {
			DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] STATUS_COMPLETE", m_pPrinter->GetPrinterNo(), JobNo);
			DEBUG_LOG_PRINTF("[4x6]  [Printer%d] [Job%d] End", m_pPrinter->GetPrinterNo(), JobNo);
			// 1 Image print ended.
			m_pAppCallbackProc(m_pPrinter->GetHandle(), pPrintingInfo->wJobNumber - 1, pPrintingInfo->wPrintedNumber, pPrintingInfo->wPrintRequestNumber, STATUS_COMPLETE, MCP_OK);
			m_printingImageNo++;
		}
		break;
/*
	case MCP_PRINTERSTATUS_READY:
		// All print ended and printer ready.
		SetEvent(m_hPrintEndEvent);
		if (m_printingImageNo == m_printImageCnt) {
			// All print ended and printer ready.
			SetEvent(m_hSendImageEvent);
			SetEvent(m_hAllPrintEndEvent);
		} else if (m_fCancel) {
			// Print canceled and printer ready.
			m_pAppCallbackProc(m_pPrinter->GetHandle(), m_printingImageNo, 0, 0, STATUS_CANCEL, MCP_OK);
			SetEvent(m_hSendImageEvent);
			SetEvent(m_hPrintEndEvent);
			SetEvent(m_hAllPrintEndEvent);
		break;
*/

	case MCP_PRINTERSTATUS_JOB_CANCEL:		// 2005/04/19 Ver.1.1.0
		// Canceled print on the way of multi copies is end.
		m_pAppCallbackProc(m_pPrinter->GetHandle(), pPrintingInfo->wJobNumber - 1, 0, 0, STATUS_CANCEL, MCP_OK);

		// 2005/12/16 Ver.2.0.0
		// IĎ̃XgbvɑΉ
		SetEvent(m_hSendImageEvent);
		SetEvent(m_hPrintEndEvent);
		SetEvent(m_hAllPrintEndEvent);
		break;

	case MCP_PRINTERSTATUS_READY:
		SetEvent(m_hPrintEndEvent);

		if (m_printingImageNo == m_printImageCnt) {// 2005.6.13 mochida
			// All print ended and printer ready.
			SetEvent(m_hSendImageEvent);
			SetEvent(m_hAllPrintEndEvent);
		}
		else if(m_fCancel){// 2005.6.20 mochida
			SetEvent(m_hSendImageEvent);
			SetEvent(m_hAllPrintEndEvent);
		}
		// 2006/01/11 Ver.2.1.1
		// Notice: MCP_GetPaperRemain() is recommended not to be called while using MCP_SendImageAndPrint(). 
		m_pParentDlg->LetUpdatePrinterRemainPaperCopies();
		break;

	case MCP_PRINTERSTATUS_START_RECOVERY:// 2005.6.8 mochida
		// Close Error Dialog
		while(1){
			hWnd = ::FindWindow( NULL, _T("Error at executing SDK function") );
			if(hWnd==NULL)break;
			::PostMessage(hWnd, WM_COMMAND, MAKELONG( IDCANCEL,BN_CLICKED ), 0 );
		}
		// Update main dialog status. ( Recovery )
		m_pAppCallbackProc(m_pPrinter->GetHandle(), pPrintingInfo->wJobNumber - 1, 0, 0, STATUS_RECOVERY, MCP_OK);
		m_fRecovering = TRUE;

		break;

	default:
		break;
	}

	// You should return callback function to SDK quickly.
}


// Check whether print canceled.
// (PrintingImageIndex : Image index now printing. (0, 1, 2, ...))
// (Return value; TRUE : Canceled)
BOOL CDoPrint::checkCanceledPrint(int PrintingImageIndex)
{

	if (m_fCancel) {
		// Cancel print after this.
		for (int i = PrintingImageIndex; i < m_printImageCnt; i++) {
			m_pAppCallbackProc(m_pPrinter->GetHandle(), i, 0, 0, STATUS_CANCEL, MCP_OK);
		}
	}

	return m_fCancel;
}


// Load image DIB data from file.
// (filePath : [IN]  Image file name (Full path).
//  phDib    : [OUT] Global memory handle of loaded DIB data.
//  pBih     : [OUT] BITMAPINFOHEADER of loaded DIB data.)
// (Return value : BOOL; TRUE : Load O.K., FALSE : Failed to load.)
BOOL CDoPrint::loadImageFile(LPCTSTR strFilePath, PHANDLE phDib, PBITMAPINFOHEADER pBih)
{
	DWORD		ret;
	UINT		errStrId;
	char		szFilePath[MAX_PATH];

// 2006/01/12 Ver.2.1.1
#ifdef UNICODE
	CEncode	Encode;
	CString	strTempFile = _T("temp");
	
	ret = Encode.MakeTempFile(strFilePath, strTempFile);
	ret = Encode.ToSJIS(strTempFile, szFilePath);
	if(ret!=0){
		AfxMessageBox(_T("File Path Encode Error."));
		return FALSE;
	}
#else
	strcpy(szFilePath, strFilePath);
#endif

	// Load image file by LOADIMG_Load() of "LoadImg.lib".
	ret = LOADIMG_Load(szFilePath, phDib, pBih);
	if (ret != LOADIMG_OK) {
		switch (ret) {
		case LOADIMG_ERR_FILE_NOT_FOUND:
			errStrId = IDS_ERR_NOT_FOUND_FILE;
			break;
		case LOADIMG_ERR_FILE_READ:
			errStrId = IDS_ERR_CANNOT_ACCESS_FILE;
			break;
		case LOADIMG_ERR_MEMORY_ALLOC:
			errStrId = IDS_ERR_ALLOC_MEM;
			break;
		default:
			errStrId = IDS_ERR_NOT_SUPPORT_FILE;
			break;
		}
		AfxMessageBox(errStrId, MB_OK | MB_ICONSTOP);
		return	FALSE;
	}
#ifdef UNICODE
	DeleteFile(strTempFile);
#endif

	return	TRUE;
}


// Make image data fit to paper size.
//  - Rotate image clockwise by 90 degrees.
//  - Scale image to specified external tangent to paper in equal scale ratio and by centering.
//  - Truncate on image area to run off the paper.
//  - Free source image DIB memory.
// (hSrcDib      : Global memory handle of loaded source DIB data.
//  SrcImageSize : Source image size.
//  PaperSize    : Paper size.
//  pfRotate     : [OUT] Flag of whether execute rotate image.
//  pfScale      : [OUT] Flag of whether execute scale image.
//  pResultImageSize : [OUT] Image size of process result.)
// (Return value : HGLOBAL; NULL : Process failed. Not NULL : Global memory handle of new DIB data. (Success))
HGLOBAL	CDoPrint::doRotateAndScale(HGLOBAL hSrcDib, POINT SrcImageSize, POINT PaperSize, BOOL* pfRotate, BOOL* pfScale, POINT* pResultImageSize)
{
	HGLOBAL		hDstDib = NULL;
	BOOL		fRotate, fScale;
	POINT		rotatedImageSize;
	DWORD		ret;
	UINT		errStrId;
	int			resultImageX = 0, resultImageY = 0;

	// Whether execute rotate image?
	if (	((SrcImageSize.y >= SrcImageSize.x) && (PaperSize.y >= PaperSize.x)) ||
			((SrcImageSize.y <  SrcImageSize.x) && (PaperSize.y <  PaperSize.x)) ) {
		fRotate = FALSE;
		rotatedImageSize.x = SrcImageSize.x;
		rotatedImageSize.y = SrcImageSize.y;
	} else {
		fRotate = TRUE;
		rotatedImageSize.x = SrcImageSize.y;
		rotatedImageSize.y = SrcImageSize.x;
	}

	// Whether execute scale image?
	if (	(rotatedImageSize.x == PaperSize.x) &&
			(rotatedImageSize.y == PaperSize.y)	) {
		fScale = FALSE;
	} else {
		fScale = TRUE;
	}

	if (fRotate) {

		// Execute rotate image by OPERATEIMG_Rotate() of "OperateImg.lib".
		ret = OPERATEIMG_Rotate(hSrcDib, &hDstDib);
		if (ret != OPERATEIMG_OK) {
			goto doRotateAndScale_ErrorExit;
		}

		GlobalFree(hSrcDib);

	} else {

		// Not execute rotate image.
		hDstDib = hSrcDib;

	}

	if (fScale) {

		hSrcDib = hDstDib;

		// Execute scale image by OPERATEIMG_ScaleExternalRect() of "OperateImg.lib".
		ret = OPERATEIMG_ScaleExternalRect(hSrcDib, PaperSize.x, PaperSize.y, &hDstDib, &resultImageX, &resultImageY);
		if (ret != OPERATEIMG_OK) {
			goto doRotateAndScale_ErrorExit;
		}

		GlobalFree(hSrcDib);

	} else {

		// Not execute scale image.
		resultImageX = rotatedImageSize.x;
		resultImageY = rotatedImageSize.y;

	}

	*pfRotate	= fRotate;
	*pfScale	= fScale;
	pResultImageSize->x = resultImageX;
	pResultImageSize->y = resultImageY;

	return hDstDib;

doRotateAndScale_ErrorExit:

	if (hDstDib != NULL) {
		GlobalFree(hDstDib);
	}

	if (ret != OPERATEIMG_OK) {
		switch (ret) {
		case OPERATEIMG_ERR_MEMORY_ALLOC:
			errStrId = IDS_ERR_ALLOC_MEM;
			break;
		default:
			errStrId = IDS_ERR_NOT_SUPPORT_FILE;
			break;
		}
		AfxMessageBox(errStrId, MB_OK | MB_ICONSTOP);
	}

	return NULL;
}

/* DEL 2005/08/26
// Table for 3D LUT parameter data file name of each printer.
typedef struct {
	short		PrinterId;					// Printer ID
	char		strDataFileName[MAX_PATH];	// File name of 3D LUT parameter data file.
} LUT3D_FILE_NAME_INFO, *PIMGSET_ERR_REC;

static LUT3D_FILE_NAME_INFO	Lut3dFileNameTbl[] = {
	{MCP_PRINTER_ID_DPB1000,	"",				},// 2005/08/22 Ver.1.6.0
	{MCP_PRINTER_ID_DPB1500,	"DP3D1500.dat",	},
	{MCP_PRINTER_ID_DPB4000,	"DP3D4000.dat",	},// 2005/07/12 Ver.1.4.3
}; */
// DEL

// Execute 3D LUT process to image data.
// (hDib     : [IN] Global memory handle of image DIB data. (Original & Result of process) )
// (Return value : BOOL; TRUE : O.K., FALSE : Failed to execute process.)
BOOL CDoPrint::do3dLut(HGLOBAL hDib)
{
//	MCP_PRINTER_INFO	printerInfo;
//	CString		str3dLutDataFileName;

	// Decide 3D LUT parameter data file name by printer type ID.

/*	if (m_str3dLutDataFileName.IsEmpty()) {

		if (!m_pPrinter->GetPrinterInfo(&printerInfo)) {
			return FALSE;
		}

//		str3dLutDataFileName = Lut3dFileNameTbl[0].strDataFileName;
		m_str3dLutDataFileName = Lut3dFileNameTbl[0].strDataFileName;

		for (int i = 0; i < COUNTOF_ARRAY(Lut3dFileNameTbl); i++) {
			if (Lut3dFileNameTbl[i].PrinterId == printerInfo.nPrinterId) {
				m_str3dLutDataFileName = Lut3dFileNameTbl[i].strDataFileName;
				break;
			}
		}

	}

	// Execute 3D LUT process.
	if (!m_pPrinter->Do3dLut(hDib, m_str3dLutDataFileName)) {
		return FALSE;
	}*/

	// Execute 3D LUT process. Ver.1.6.1
	if (!m_pPrinter->Do3dLut(hDib)) {
		return FALSE;
	}

	return TRUE;
}


//-----------------------------------------------------------------------------
//	Function    : TotalImageSetup(int ImageNo, HGLOBAL &hDib, POINT &resultImageSize)
//
//	Description : Total image setup ( Load image, Resize and Rotate, Image Setup, 1DLUT, 3DLUT )
//
//	Arguments   :
//		[in] int ImageNo - index of file list (0,1,2,...)
//		[out] HGLOBAL &hDib - Global memory handle of image DIB data. (Original & Result of process)
//		[out] POINT &resultImageSize - Image size of process result.
//
//	Return Value: BOOL - TRUE : O.K., FALSE : Failed to execute process.
//
//	Modify Date: 2005/12/06	Mochida Takeshi
//-----------------------------------------------------------------------------
BOOL CDoPrint::TotalImageSetup(int ImageNo, HGLOBAL &hDib, POINT &resultImageSize){
	int				iRet, iRetF;
	BOOL			bRet = TRUE;
	HGLOBAL			hLoadDib = NULL;
	HGLOBAL			hSendDib = NULL;
	int				i = ImageNo;
	POINT			imageSize, paperSize;
	BOOL			fRotate, fScale;

	BOOL			fImageSetup, f1DLUT, f3DLUT;
	ISPL_INFO		IsplInfo;// 2005/12/05 Ver.1.7.1

#ifdef	SAVE_BMP
	char		szSaveBmpFileName[MAX_PATH];// Modify at 2005/12/06 Ver.1.7.1 
#endif

	DWORD	dwTime = 0;	// For Log

	fImageSetup = m_doPrintInfo.fImgSetup;
	f1DLUT = m_doPrintInfo.f1DLUT;
	f3DLUT = m_doPrintInfo.f3DLUT;
	IsplInfo = m_doPrintInfo.IsplInfo;// 2005/12/05 Ver.1.7.1

	imageSize = m_pPrintImageList[i].ImageSize;
	paperSize = m_doPrintInfo.PaperSize;

	// Critical Section
	g_criticalSection_ImgSetup.Lock();

	////////////////////////////////////////
	// Load image data.
	DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] loadImageFile()", m_pPrinter->GetPrinterNo(), i);
	if (!loadImageFile(m_pPrintImageList[i].FilePath, &hLoadDib, NULL)) {
		bRet = FALSE;
		goto	Exit;
	}
	DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] loadImageFile() return %d", m_pPrinter->GetPrinterNo(), i, bRet);

	////////////////////////////////////////
	// Make image data fit to paper size.
	//  - Rotate image clockwise by 90 degrees.
	//  - Scale image to specified external tangent to paper in equal scale ratio and by centering.
	//  - Truncate on image area to run off the paper.
	DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] doRotateAndScale()", m_pPrinter->GetPrinterNo(), i);
	hSendDib = doRotateAndScale(hLoadDib, imageSize, paperSize, &fRotate, &fScale, &resultImageSize);
	if (hSendDib == NULL) {
		bRet = FALSE;
		goto	Exit;
	}
	hLoadDib = NULL;
	DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] doRotateAndScale() return %d", m_pPrinter->GetPrinterNo(), i, bRet);

	////////////////////////////////////////
	// Initialize
	if (fImageSetup==TRUE || f3DLUT==TRUE){
		iRet = g_setupImgDll.Init();
		if(iRet!=0) {
			bRet = FALSE;
			goto Exit; 
		}
	}

	////////////////////////////////////////
	// FFISPL Image setup process.
	DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] doImageSetup()", m_pPrinter->GetPrinterNo(), i);
	if (fImageSetup==TRUE){

		ISPL_MANUAL_PARAM	ManualParam;
		ManualParam.sColorC = IsplInfo.iColorC;
		ManualParam.sColorM = IsplInfo.iColorM;
		ManualParam.sColorY = IsplInfo.iColorY;
		ManualParam.sContrast = IsplInfo.iContrast;
		ManualParam.sBrightness = IsplInfo.iBright;
		ManualParam.nMonotoneMode = IsplInfo.iMonotone;

		////////////////////////////////////////
		// Execute Image setup process.
		iRet = g_setupImgDll.DoAutoSetup(IsplInfo.fAuto, IsplInfo.fRedEye, hSendDib, hSendDib, m_pPrintImageList[i].FilePath, ManualParam, IsplInfo.iSetupType, _T(""), _T(""));

		if(iRet!=0) {
			AfxMessageBox(_T("DoAutoSetup() return %d"), iRet);
			bRet = FALSE;
			goto Exit; 
		}

		////////////////////////////////////////
		// RedEye Remove Marking
		if(IsplInfo.fRedEye && IsplInfo.fMarker){
			bRet = g_setupImgDll.DrawRedEyeResult(hSendDib, g_setupImgDll.GetRedEyeResult() );
			if(bRet!=TRUE){
				goto Exit; 
			}
		}
	}
	DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] doImageSetup() return %d", m_pPrinter->GetPrinterNo(), i, iRet);

	////////////////////////////////////////
	// Execute 1D LUT procces.
	DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] do1DLut()", m_pPrinter->GetPrinterNo(), i);
	if (f1DLUT==TRUE){
		if (!m_pPrinter->Do1dLut(hSendDib)) {
			bRet = FALSE;
			goto	Exit;
		}
	}
	DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] do1DLut() return %d", m_pPrinter->GetPrinterNo(), i, bRet);

	////////////////////////////////////////
	// Execute 3D LUT procces.
	DEBUG_LOG_PRINTF_SET(dwTime, "[4x6]  [Printer%d] [Job%d] do3DLut()", m_pPrinter->GetPrinterNo(), i);

	// takanaka delete 2009/04/09 Ver.2.7.0
	/*	if (f3DLUT==TRUE){ 

		// FFISPL function
		iRet = g_setupImgDll.Do3DLut(hSendDib, IsplInfo.wszOutputProfile);
		if(iRet!=0) {
			if(iRet == ISPL_ERR_NOT_FOUND_FILE){
				AfxMessageBox(IDS_ERR_SDKS_NO_IMGSET_3DLUT_DATA);
			}

			bRet = FALSE;
			goto Exit; 
		}
		/* // SDK function
		if (!do3dLut(hSendDib)) { 
			bRet = FALSE;
			goto	Exit;
		}
	}
*/

	// takanaka addition 2009/04/09 Ver.2.7.0
	if(m_s3dLutFnc.Compare(LUT_COMBO_SDK) == 0)
	{
		if (!do3dLut(hSendDib)) { 
			bRet = FALSE;
			goto	Exit;
		}		
	} else if(m_s3dLutFnc.Compare(LUT_COMBO_FFISPL) == 0)
	{
		// FFISPL function
		iRet = g_setupImgDll.Do3DLut(hSendDib, IsplInfo.wszOutputProfile);
		if(iRet!=0) {
			if(iRet == ISPL_ERR_NOT_FOUND_FILE){
				AfxMessageBox(IDS_ERR_SDKS_NO_IMGSET_3DLUT_DATA);
			}

			bRet = FALSE;
			goto Exit; 
		}
	} else {
	
	}

	DEBUG_LOG_PRINTF_TIME(dwTime, "[4x6]  [Printer%d] [Job%d] do3DLut() return %d", m_pPrinter->GetPrinterNo(), i, iRet);

Exit:

#ifdef	SAVE_BMP	// Modify at 2005/12/06 Ver.1.7.1
	sprintf(szSaveBmpFileName, IMAGE_SAVE_BMP_FILENAME, i + 1);
	// Save DIB data to BMP file at same folder. (For confirm image setup process.)
	SaveDibToBmpFileAtSameFolder((PCSTR)szSaveBmpFileName, hSendDib);
#endif

	////////////////////////////////////////
	// Termination
	if (fImageSetup==TRUE || f3DLUT==TRUE){
		iRetF = g_setupImgDll.Finish();
		if(iRet==0){
			iRet = iRetF;
		}
	}

	g_criticalSection_ImgSetup.Unlock();

	hDib = hSendDib;
	return bRet;
}


///////////////////////////////////////////////////////////////////////////////
//
//	class static method
//


// Thread function of print process.
// (pParam : [IN]  Thread parameter.)
UINT CDoPrint::printingThreadProc(PVOID pParam)
{
	CDoPrint		*pDoPrint = (CDoPrint *)pParam;
	BOOL			fSuccess;

	// Print by 1 image print at once.
	if( pDoPrint->m_pPrinter->GetPrintMethod() == PRINTMETHOD_NORMAL ){
		fSuccess = pDoPrint->DoNormalPrint();
	}

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
	else if( pDoPrint->m_pPrinter->GetPrintMethod() == PRINTMETHOD_NOR_MUL ){
		fSuccess = pDoPrint->DoNorMulPrint(MCP_PAPER_HEIGHT_6X8);
	}
	else if( pDoPrint->m_pPrinter->GetPrintMethod() == PRINTMETHOD_NOR_MUL_2 ){
		fSuccess = pDoPrint->DoNorMulPrint(MCP_PAPER_HEIGHT_A5);
	}
	else if( pDoPrint->m_pPrinter->GetPrintMethod() == PRINTMETHOD_MUL_NOR ){
		fSuccess = pDoPrint->DoMulNorPrint(MCP_PAPER_HEIGHT_6X8);
	}
	else if( pDoPrint->m_pPrinter->GetPrintMethod() == PRINTMETHOD_MUL_NOR_2 ){
		fSuccess = pDoPrint->DoMulNorPrint(MCP_PAPER_HEIGHT_A5);
	}
#endif

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	else if( pDoPrint->m_pPrinter->GetPrintMethod() == PRINTMETHOD_THREEDIV ){
		fSuccess = pDoPrint->DoThreeDivPrint();
	}
#endif
	
	else{
		fSuccess = pDoPrint->DoMultiPrint();
	}

	// Set main dialog ready.
	pDoPrint->m_pParentDlg->NotifyPrintEnd(fSuccess);

	return	0;
}


// Callback function registered to SDK at print by MCP_SendImageAndPrint().
// (Args : See SDK call back function definition.)
void CALLBACK CDoPrint::normalPrintCallbackProc(HANDLE hPrinter, PMCP_PRINTINGINFO pPrintingInfo, DWORD dwErrorInfo)
{
	CDoPrint	*pDoPrint;
	int			i;

	// Search printer about this callback function called.
	for (i = 0; i < COUNTOF_ARRAY(g_doPrintTbl); i++) {
		if (hPrinter == g_doPrintTbl[i].hPrinter) {
			pDoPrint = g_doPrintTbl[i].pDoPrint;
			break;
		}
	}
	if (i == COUNTOF_ARRAY(g_doPrintTbl)) {
		return;
	}

	// Update print progress.
	pDoPrint->UpdatePrintProgress(pPrintingInfo, dwErrorInfo);

	// You should return callback function to SDK quickly.
}

