/************************************************************/
/*															*/
/*	File :	DoPrint.h										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#ifndef __DOPRINT_H__
#define __DOPRINT_H__


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "Printer.h"
#include "PrintDlg.h"


//===========================================================================
//
//	DoPrint class
//		Class to manage print at printer by using CPrinter class.
//
//		Use this class procedure
//			1. Create instance of this class for target printer.
//			2. Call SetPrinterInfo() method to resister printer control information.
//			3. Call SetParentDlg() method to resister main display dialog.
//			4. Call SetImageList() method to resister print images.
//			5. Call SetDoPrintInfo() method to resister print setting.
//			6. Call StartPrint() method to start print and resister callback
//			   function for notify printing progress.
//			7. After finishing to print, delete instance of this class.
//
//===========================================================================


// Struct for print setting.
typedef struct {
	PRINT_INFO		PrintInfo;
	POINT			PaperSize;
	BOOL			fImgSetup;// 2005/05/27 mochida
	BOOL			f1DLUT;
	BOOL			f3DLUT;
	ISPL_INFO		IsplInfo;// 2005/12/05 Ver.1.7.1
} DOPRINT_INFO, *PDOPRINT_INFO;


// Pointer type for callback function resisted by CDoPrint::StartPrint().
typedef void (*PAPP_CALLBACK)(HANDLE, int, WORD, WORD, BYTE, DWORD);


class CDoPrint
{

public:
	// Constructor / Destructor
	CDoPrint();
	virtual ~CDoPrint();

	// Set target printer control information.
	void	SetPrinterInfo(CPrinter* pPrinter);

	//	Set CPrintDlg for display printing progress.
	//	(pParentDlg : Pointer to CPrintDlg.)
	void	SetParentDlg(CPrintDlg *pParentDlg);

	// Set print images list.
	// (pPrintImageList : Pointer to print images array.
	// (PrintImageCnt   : Count of print images.)
	void	SetImageList(const PPRINT_IMAGE_INFO pPrintImageList, int PrintImageCnt);

	// Set print setting information.
	// (DoPrintInfo : Print setting information.)
	void	SetDoPrintInfo(DOPRINT_INFO DoPrintInfo);

	// Start print and resister callback function for notify
	// printing progress.
	// (pAppCallbackProc;	[IN] Application callback function address.)
	// (Return value : BOOL; TRUE : O.K., FALSE : Error)
	BOOL	StartPrint(PAPP_CALLBACK pAppCallbackProc);

	// Stop next print. (And call SDK MCP_CancelPrint().)
	// (Return value : BOOL; TRUE : O.K., FALSE : Error)
	BOOL	StopPrint();

	// Used by thread function in this class.
	BOOL	DoNormalPrint();

	// Used by thread function in this class. // 2005/07/12 Ver.1.4.1
	BOOL	DoMultiPrint();

#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	BOOL	DoThreeDivPrint();
#endif

#ifndef RET_VER241	// nakashima addition 2007/03/29 Ver.2.4.2
	BOOL	DoNorMulPrint(DWORD dwYSize);
	BOOL	DoMulNorPrint(DWORD dwYSize);
#endif

	// Used by SDK callback function in this class.
	void	UpdatePrintProgress(PMCP_PRINTINGINFO pPrintingInfo, DWORD dwErrorInfo);

	// takanaka addition 2009/04/09 Ver.2.7.0
	void	Set3dlut(CString s3dlutFnc){ m_s3dLutFnc = s3dlutFnc;}

private:
	// Load image file
	BOOL	loadImageFile(LPCTSTR filePath, PHANDLE phDib, PBITMAPINFOHEADER pBih);
	// Resize & Rotate image
	HGLOBAL	doRotateAndScale(HGLOBAL hSrcDib, POINT SrcImageSize, POINT PaperSize, BOOL* pfRotate, BOOL* pfScale, POINT* pResultImageSize);
	// 3D LUT Conversion
	BOOL	do3dLut(HGLOBAL hDib);
	// Load image, Resize & Rotate image, Image Setup, 1DLUT, 3DLUT 
	BOOL	TotalImageSetup(int ImageNo, HGLOBAL &hDib, POINT &resultImageSize);// Modify at 2005/12/06 Ver.1.7.1

	BOOL	checkCanceledPrint(int PrintingImageIndex);


	static UINT printingThreadProc(PVOID pParam);
	static void CALLBACK normalPrintCallbackProc(HANDLE hPrinter, PMCP_PRINTINGINFO pPrintingInfo, DWORD dwErrorInfo);

	CPrintDlg*			m_pParentDlg;			// Pointer to CPrintDlg
	CPrinter*			m_pPrinter;				// Pointer to printer control object
	PPRINT_IMAGE_INFO	m_pPrintImageList;		// Pointer to print images array
	int					m_printImageCnt;		// Count of print images
	DOPRINT_INFO		m_doPrintInfo;			// Print setting information
	int					m_sendingImageNo;		// No. of image sending now
	int					m_printingImageNo;		// No. of image printing now
	HANDLE				m_hSendImageEvent;		// Handle of event object for notify ending to send image
	HANDLE				m_hPrintEndEvent;		// Handle of event object for notify ending to 1 unit print
	HANDLE				m_hAllPrintEndEvent;	// Handle of event object for notify ending to all print
	DWORD				m_errInfo;				// Error information get by SDK callback function in printing
	PAPP_CALLBACK		m_pAppCallbackProc;		// Callback function for notify printing progress
	BOOL				m_fCancel;				// Cancel flag
	BOOL				m_fRecovering;			// Recovering flag

	// takanaka addition 2009/04/09 Ver.2.7.0
	CString				m_s3dLutFnc;			// 3dLut Dll flag
};


#endif // #ifndef __DOPRINT_H__
