// Encode.cpp: CEncode 
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Encode.h"

#include <locale.h>
#include <wchar.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern	HWND	g_hWnd;

//////////////////////////////////////////////////////////////////////
// 
CEncode::CEncode()
{

}

CEncode::~CEncode()
{

}

int CEncode::ToSJIS(const WCHAR *wszSrcUnicode, char *szDstSjis)
{
	int		iRet = ENCODE_OK;
	int		sizeofTemp;
	char*	szTemp = NULL;

	// For SJIS
	sizeofTemp = WideCharToMultiByte(CP_THREAD_ACP, 0, wszSrcUnicode, -1, szTemp, 0, NULL, NULL);

	// Allocate for SJIS
	szTemp = (char*)malloc( sizeofTemp );
	if(szTemp==NULL){
		iRet = ENCODE_ERROR_ALLOC_FAILED;
		goto Exit;
	}

/*	// Set Local function
	_wsetlocale(LC_ALL, _T("English"));
*/

	// Convert Unicode to SJIS 
	iRet = WideCharToMultiByte(CP_THREAD_ACP, 0, wszSrcUnicode, -1, szTemp, sizeofTemp, NULL, NULL);
	if(iRet==0){
		// Error
		iRet = (int)GetLastError();
		switch(iRet){
		case ERROR_INSUFFICIENT_BUFFER:
			iRet = ENCODE_ERROR_INSUFFICIENT_BUFFER;
			break;
		case ERROR_INVALID_FLAGS:
			iRet = ENCODE_ERROR_INVALID_FLAGS;
			break;
		case ERROR_INVALID_PARAMETER:
			iRet = ENCODE_ERROR_INVALID_PARAMETER;
			break;
		}
	}else{
		iRet = 0;
		if( !strcpy(szDstSjis, szTemp) ){
			iRet = ENCODE_ERROR_STRCPY;
		}
	}

Exit:
	if(szTemp!=NULL){
		free(szTemp);
		szTemp = NULL;
	}
	return iRet;
}

int CEncode::ToUnicode(const char *szSrcSjis, WCHAR *wszDstUnicode)
{
	int		iRet = ENCODE_OK;
	int		sizeofTemp;
	WCHAR*	wszTemp = NULL;

	// For Unicode
	sizeofTemp = MultiByteToWideChar(CP_THREAD_ACP, 0, szSrcSjis, -1, wszTemp, 0);
	
	// Allocate for Unicode
	wszTemp = (WCHAR*)malloc( sizeofTemp * 2 );
	if(wszTemp==NULL){
		iRet = ENCODE_ERROR_ALLOC_FAILED;
		goto Exit;
	}

/*	// Set Local function
	_wsetlocale(LC_ALL, _T("English"));
*/

	// Convert SJIS to Unicode 
	iRet = MultiByteToWideChar(CP_THREAD_ACP, 0, szSrcSjis, -1, wszTemp, sizeofTemp);
	if(iRet==0){
		// Error
		iRet = (int)GetLastError();
		switch(iRet){
		case ERROR_INSUFFICIENT_BUFFER:
			iRet = ENCODE_ERROR_INSUFFICIENT_BUFFER;
			break;
		case ERROR_INVALID_FLAGS:
			iRet = ENCODE_ERROR_INVALID_FLAGS;
			break;
		case ERROR_INVALID_PARAMETER:
			iRet = ENCODE_ERROR_INVALID_PARAMETER;
			break;
		}
	}else{
		iRet = 0;
		if( !wcscpy(wszDstUnicode, wszTemp) ){
			iRet = ENCODE_ERROR_STRCPY;
		}
	}

Exit:
	if(wszTemp!=NULL){
		free(wszTemp);
		wszTemp = NULL;
	}
	return iRet;
}


int CEncode::MakeTempFile(CString strFilePath, CString &strTempFileName)
{
	int	iRet = 0;
	CString strTempPath, strExt, strExePath;

	// Get file extention
	strExt = strFilePath.Right(4);

	// Get Current Directry
	TCHAR szPath[_MAX_PATH];
	TCHAR szDrive[_MAX_DRIVE], szDir[_MAX_DIR];

	if(GetModuleFileName( NULL, szPath, _MAX_PATH )==0){
		return -1;
	}
	_tsplitpath( szPath, szDrive, szDir, NULL, NULL );
	strExePath.Format( _T("%s%s"), szDrive, szDir);

	// Temporay file path
	strTempPath = strExePath + strTempFileName + strExt;

/*	// Delete file	
	DeleteFile(strTempPath);
*/
	// Copy file
	iRet = CopyFile( strFilePath, strTempPath, FALSE);
	if(iRet==0){
		iRet = GetLastError();
	}else{
		iRet = 0;
		strTempFileName = strTempPath;	
	}

	// Set file attribute normal
	SetFileAttributes(strTempPath, FILE_ATTRIBUTE_NORMAL);

	return iRet;	
}
