/************************************************************/
/*															*/
/*	File :	EnumDlg.cpp										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#include "stdafx.h"
#include "sdksample.h"
#include "EnumDlg.h"
#include "Setup.h"
#include "Printer.h"
#include "PrintDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


///////////////////////////////////////////////////////////////////////////////
//
//	Constant value define
//


///////////////////////////////////////////////////////////////////////////////
//
//	Declare static functions
//


/////////////////////////////////////////////////////////////////////////////
// CEnumDlg public method


// Set pointer to CSetup object.
void CEnumDlg::SetPrinterSetup(CSetup *pSetup)
{

	m_pSetup = pSetup;

}


/////////////////////////////////////////////////////////////////////////////
// CEnumDlg dialog


CEnumDlg::CEnumDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEnumDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEnumDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	ZeroMemory(m_pPrinters, sizeof(m_pPrinters));

}


void CEnumDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEnumDlg)
	DDX_Control(pDX, IDC_LIST_PRINTER, m_listPrinter);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEnumDlg, CDialog)
	//{{AFX_MSG_MAP(CEnumDlg)
	ON_BN_CLICKED(ID_SEARCH, OnSearch)
	ON_BN_CLICKED(ID_OPEN, OnOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CEnumDlg message handler


// Initialize dialog display.
BOOL CEnumDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, FALSE);

	UpdateData(FALSE);

	return TRUE;
}


// Struct for Printer product name string table
typedef struct {
	short		ProductId;
	char		strProductName[64];
	BOOL		fSupportControlByThisApp;	// Whether supported by this Sample Program
} PRODUCT_NAME_INFO, *PPRODUCT_NAME_INFO;

// Printer product name string table
static PRODUCT_NAME_INFO ProductNameTbl[] = {
	{MCP_PRINTER_ID_DPB1000,	"DPB-1000", TRUE,	},// 2005/08/22 Ver.1.6.0
//	{MCP_PRINTER_ID_DPB1500,	"DPB-1500",	TRUE,	},
	{MCP_PRINTER_ID_ASK1500,	"ASK-1500",	TRUE,	},// 2005/06/08 mochida
//	{MCP_PRINTER_ID_DPB4000,	"DPB-4000",	TRUE,	},// 2005/07/12 Ver.1.4.3
	{MCP_PRINTER_ID_ASK4000,	"ASK-4000",	TRUE,	},// 2005/12/22 Ver.2.0.2
	{MCP_PRINTER_ID_ASK2000,	"ASK-2000",	TRUE,	},// 2005/12/26 Ver.2.0.3
	{MCP_PRINTER_ID_ASK4000A,	"ASK-4000A",TRUE,	},// 2007/06/29 Ver.2.5.0
	{MCP_PRINTER_ID_ASK2500,	"ASK-2500",	TRUE,	},// 2008/10/09 Ver.2.6.8
};

// Handler at "Search" button pushed.
void CEnumDlg::OnSearch() 
{
	PMCP_PRINTER_INFO	pPrinterName;
	UINT				printerNum = 0, i;
	HANDLE				hPrinter;
	CString				strProductName, strDisp;

	// Clear display found printer list. 
	m_listPrinter.ResetContent();

	// Execute searching printer.
	if (!m_pSetup->Enum(&printerNum, &pPrinterName)) {
		return;
	}

	for (i = 0; i < MAX_PRINTER_CNT; i++) {
		// Destroy CPrinter instance for each printers.
		if (m_pPrinters[i] != NULL) {
			delete	m_pPrinters[i];
			m_pPrinters[i] = NULL;
		}
	}

	// Display found printer list. 
	for (i = 0; i < printerNum; i++) {

		hPrinter = m_pSetup->GetPrinterHandle(i);

		// Make printer product name string.
		strProductName = "Unknown";
		for (int j = 0; j < COUNTOF_ARRAY(ProductNameTbl); j++) {
			if (ProductNameTbl[j].ProductId == pPrinterName[i].nPrinterId) {
				strProductName = ProductNameTbl[j].strProductName;
				break;
			}
		}

//		strDisp.Format("%d       %-10s        %d", i + 1, strProductName, pPrinterName[i].nUsbNo);
		strDisp.Format(_T("%-10s        %d"), strProductName, pPrinterName[i].nUsbNo);

		m_listPrinter.AddString(strDisp);

		// Create CPrinter class instance for each printer.
//		m_pPrinters[i] = new CPrinter(i, hPrinter, strProductName);
		m_pPrinters[i] = new CPrinter(pPrinterName[i].nUsbNo, hPrinter, strProductName);

	}

	m_listPrinter.SetSel(0, TRUE);

}


// Handler at "Open" button pushed.
void CEnumDlg::OnOpen() 
{
	int				selCnt, selIndex[MAX_PRINTER_CNT], i, j;
	POINT			wndPos;

	// Get selected printer(s).
	selCnt = m_listPrinter.GetSelCount();
	if (selCnt < 1) {
		AfxMessageBox(IDS_ERR_NO_SEL_PRINTER, MB_OK | MB_ICONSTOP);
		return;
	}
	m_listPrinter.GetSelItems(selCnt, selIndex);

	// Start control to each printer(s).

	wndPos.x = 0;
	wndPos.y = 0;

	for (i = 0; i < selCnt; i++) {

		if (m_pPrinters[selIndex[i]] != NULL) {
			if (m_pPrinters[selIndex[i]]->IsOpen()) {
				AfxMessageBox(IDS_ERR_SDKS_ALREADY_OPEN, MB_OK | MB_ICONSTOP);
				return;
			}
		}

		CString	strPrinterProductName;
		m_pPrinters[selIndex[i]]->GetProductName(strPrinterProductName);
		for (j = 0; j < COUNTOF_ARRAY(ProductNameTbl); j++) {
			if (strPrinterProductName == ProductNameTbl[j].strProductName) {
				if (ProductNameTbl[j].fSupportControlByThisApp) {
					// Supported printer.
					break;
				}
			}
		}
		if (j >= COUNTOF_ARRAY(ProductNameTbl)) {
			// Not supported printer.
			AfxMessageBox(IDS_ERR_NOT_SUPPORT_PRINTER);
			return;
		}

		// Start control for target printer.
		if (!m_pPrinters[selIndex[i]]->Open()) {
			return;
		}

		// Display print dialog.
		m_PrintDlgs[selIndex[i]].SetPrinterInfo(m_pPrinters[selIndex[i]]);
		if (m_PrintDlgs[selIndex[i]].IsDlgCreate()) {
			m_PrintDlgs[selIndex[i]].DestroyWindow();
		}
		m_PrintDlgs[selIndex[i]].SetWindowPosition(wndPos);
		m_PrintDlgs[selIndex[i]].Create(IDD_PRINT_DLG, this);

		wndPos.x += 50;		// Slide print dialog position.
		wndPos.y += 20;

	}

}


// Handler at "Cancel" button pushed.
void CEnumDlg::OnCancel() 
{
	int		i;

	for (i = 0; i < MAX_PRINTER_CNT; i++) {
		// Destroy print setting dialog for each printer(s).
		if (m_PrintDlgs[i].IsDlgCreate()) {
			// Close print dialog.
			m_PrintDlgs[i].SendMessage(WM_COMMAND, MAKEWPARAM(IDCANCEL, BN_CLICKED));
			m_PrintDlgs[i].DestroyWindow();
		}
		// Destroy CPrinter instance for each printer(s).
		if (m_pPrinters[i] != NULL) {
			delete	m_pPrinters[i];
			m_pPrinters[i] = NULL;
		}
	}

	CDialog::OnCancel();
}
