/********************************************************/
/*														*/
/*	File :	Log_W32c.cpp								*/
/*														*/
/*	Class to output log to file	(For Win32)				*/
/*														*/
/********************************************************/

#include <windows.h>
#include <stdio.h>
#include <time.h>
#include <io.h>
#include "Log_W32c.h"


///////////////////////////////////////////////////////////////////////////// 
//	e define

// W[nhl
#define	LOG_HMODULE_DEFAULT				0xFFFFFFFF

// W[io[Wԍj̕\
#define	LOG_MODULEINFO_STR_LEN			128



///////////////////////////////////////////////////////////////////////////// 
//	}N`

// Log t@CANZXNeBJZNVp
#define	SECTION_ACCESS_LOGFILE_START	EnterCriticalSection(&m_openLogFileSection)
#define	SECTION_ACCESS_LOGFILE_END		LeaveCriticalSection(&m_openLogFileSection)



///////////////////////////////////////////////////////////////////////////// 
//	CLogFile public methods


// RXgN^^fXgN^
CLogFile::CLogFile(LPCSTR LogFileTitle)
{
	int		i;

	// Ot@CEobNAbvfBNgݒ
	if (LogFileTitle != NULL && strlen(LogFileTitle) < MAX_PATH) {
		strcpy(m_logFileTitle, LogFileTitle);
	} else {
		strcpy(m_logFileTitle, LOG_FILETITLE_DEFAULT);
	}

	strcpy(m_backupDir, m_logFileTitle);

	// Ot@CobNAbvftHglݒ
	m_backupCount = LOG_BACKUP_COUNT_DEFAULT;

	// Oo̓xftHglݒ
	m_logLevel = LOG_LEVEL_DEFAULT;

	// W[񏉊
	for (i = 0; i < LOG_MODULE_COUNT; i++) {
		m_hModule[i] = (HMODULE)LOG_HMODULE_DEFAULT;
	}

	// es̐擪ɕtw
	m_addInfo = LOG_ADDINFO_NOINFO;

	// Ot@CANZXNeBJZNV̏
	InitializeCriticalSection(&m_openLogFileSection);

}

CLogFile::~CLogFile()
{

	// Ot@CANZXNeBJZNV̔j
	DeleteCriticalSection(&m_openLogFileSection);

}


// Oo̓t@Cݒ
// iLogFileTitleF Oo̓t@CigqBgq ".txt" ŒBjj
BOOL CLogFile::LOG_SetLogFileTitle(LPCSTR LogFileTitle)
{

	if (strlen(LogFileTitle) >= MAX_PATH) {
		return	FALSE;
	}

	strcpy(m_logFileTitle, LogFileTitle);

	return	TRUE;
}

// ߋ̃Ot@CobNAbvݒ
// iobNAbvF Windows  Temp fBNg̃O̓t@C̃fBNg
//		"Oo̓t@C_nnn.txt" (nnn = 0,1,2,...) ŕۑߋ̃Oo̓t@C̍ő吔̂ƁBj
BOOL CLogFile::LOG_SetLogTopString(LPCSTR LogTopString)
{

	if (strlen(LogTopString) >= LOG_MAX_LEN_TOP_STRING) {
		return	FALSE;
	}
	strcpy(m_logTopString, LogTopString);

	return	TRUE;
}


// Ot@C擪ɏo͂ݒ
// iLogTopStringF iLOG_MAX_LEN_TOP_STRING ȓjj
void CLogFile::LOG_SetBackupCount(WORD BackupCount)
{

	m_backupCount = BackupCount;

}

// Ot@C擪ɏo͂eW[io[Wj̑ΏۃW[̃nhݒ
// iNULL ݒ̏ꍇACvZX̏óB
//	 ő LOG_MODULE_COUNT ܂ŐݒłBj
BOOL CLogFile::LOG_SetModuleHandle(HMODULE hModule)
{
	static int	index = 0;

	if (index >= LOG_MODULE_COUNT) {
		return	FALSE;
	}

	m_hModule[index] = hModule;
	index++;

	return	TRUE;
}

// Oo̓xݒ
// i"Oo̓x" Ƃ́Cw肳ꂽOt@Cɏނǂ̔fB
//   {֐Őݒ肳ꂽl荂Oo̓xw肳ꂽ LOG_PRINTF(), LOG_WRITE_DATA() 
//   Oo͍͂sȂȂBj
void CLogFile::LOG_SetLogLevel(BYTE LogLevel)
{

	m_logLevel = LogLevel;

}

// LOG_PRINTF(), LOG_WRITE_DATA() ł̃Oo͂̊es擪ɕtijݒ
// iLOG_ADDINFO_TIME_PAST, LOG_ADDINFO_TIME_NOW, LOG_ADDINFO_THREADID wBior wjj
BOOL CLogFile::LOG_SetAddInfo(BYTE AddInfo)
{

	if ((AddInfo & LOG_ADDINFO_TIME_PAST) && (AddInfo & LOG_ADDINFO_TIME_NOW)) {
		// oߎԂƌݎԂ𓯎w̓G[
		return	FALSE;
	}

	m_addInfo = AddInfo;

	return	TRUE;
}


#define	TOP_STR00	"///////////////////////////////////////////////////////////////////////////////"
#define	TOP_STR01	"//"
#define	TOP_STR02	"//    %s"
#define	TOP_STR03	"//"
#define	TOP_STR04	"//        Module [%02d] :  File Name        = %s"
#define	TOP_STR05	"//                       File Description = %s"
#define	TOP_STR06	"//                       File Version     = %s"
#define	TOP_STR07	"//                       Private Build    = %s"
#define	TOP_STR08	"//                       File path        = %s"
#define	TOP_STR09	"//"
#define	TOP_STR11	"//        Log start time (MM/DD/YY : time) = %s : %s"
#define	TOP_STR12	"//        Log file path                    = %s"
#define	TOP_STR13	"//        Log level                        = %d"
#define	TOP_STR14	"//"
#define	TOP_STR15	"///////////////////////////////////////////////////////////////////////////////"
#define	TOP_STR16	""
#define	TOP_STR21	"[Time by log start(sec)]"
#define	TOP_STR22	"[Now time]"
#define	TOP_STR23	"[Thread ID (Low WORD)]"
#define	TOP_STR24	"           [Thread ID (Low WORD)]"
#define	TOP_STR25	""

// Oo͊Jniߋ̃Ot@CobNAbvEeój{
BOOL CLogFile::LOG_Start(void)
{
	char	exePath[MAX_PATH], drive[16], dir[MAX_PATH];
	BYTE	addInfo;
	char	moduleName[LOG_MODULEINFO_STR_LEN], moduleDesc[LOG_MODULEINFO_STR_LEN],
			moduleVersion[LOG_MODULEINFO_STR_LEN], modulePrivateBuild[LOG_MODULEINFO_STR_LEN],
			modulePath[MAX_PATH],
			dateStr[16], timeStr[16];
	int		i;

	// Log o̓x̃`FbN
	if (m_logLevel <= LOG_LEVEL_NO_LOG) {
		return	FALSE;
	}

	// vZX̎sfBNg̃tpX擾
	GetModuleFileName(NULL, exePath, MAX_PATH);
	_splitpath(exePath, drive, dir, NULL, NULL);

	// Ot@Co̓fBNgivZX̎sfBNgj̃tpX쐬
//	sprintf(m_logFilePath, "%s%s%s.txt", drive, dir, m_logFileTitle);
	sprintf(m_logFilePath, "%s%sLog\\%s.txt", drive, dir, m_logFileTitle);// mochida 05/05/20

	// Ot@Co̓fBNgɎcĂ郍Ot@CobNAbv
	backupLogFile(m_logFilePath, m_logFileTitle, m_backupCount);

	// ꎞIɊes̐擪ɊetȂ悤ɐݒ肷
	addInfo = m_addInfo;
	m_addInfo = LOG_ADDINFO_NOINFO;

	// Ot@CɃOJnbZ[Wo
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR00);
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR01);
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR02, m_logTopString);
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR03);

	// eW[(EXE/DLL) ̃t@CEo[W擾
	i = 0;
	while (i < LOG_MODULE_COUNT && m_hModule[i] != (HMODULE)LOG_HMODULE_DEFAULT) {
		strcpy(moduleName, "");
		strcpy(moduleDesc, "");
		strcpy(moduleVersion, "");
		strcpy(modulePrivateBuild, "");
		if (getModuleVersionInfo(m_hModule[i], moduleName, moduleDesc, moduleVersion, modulePrivateBuild)) {
			// t@CEo[Wo
			LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR04, i + 1, moduleName);
			LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR05, moduleDesc);
			LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR06, moduleVersion);
			LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR07, modulePrivateBuild);
		}
		if (GetModuleFileName(m_hModule[i], modulePath, MAX_PATH) != 0) {
			LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR08, modulePath);
		}
		i++;
	}
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR09);

	// Ot@Cɏo͊Jno
	_strdate(dateStr);
	_strtime(timeStr);
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR11, dateStr, timeStr);
	// Ot@Cɏo̓pXo
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR12, m_logFilePath);
	// Ot@Cɏo̓xo
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR13, m_logLevel);
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR14);
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR15);
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR16);

	// es擪tij̐xo
	switch (addInfo) {
	case LOG_ADDINFO_TIME_PAST:
		LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR21);
		break;
	case LOG_ADDINFO_TIME_NOW:
		LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR22);
		break;
	case LOG_ADDINFO_THREADID:
		LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR23);
		break;
	case (LOG_ADDINFO_TIME_PAST | LOG_ADDINFO_THREADID):
		LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR21);
		LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR24);
		break;
	case (LOG_ADDINFO_TIME_NOW | LOG_ADDINFO_THREADID):
		LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR22);
		LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR24);
		break;
	case LOG_ADDINFO_NOINFO:
	default:
		break;
	}
	LOG_PRINTF(LOG_LEVEL_OPENING_PAGE, TOP_STR25);

	// es̐擪ɕtwƂɖ߂
	m_addInfo = addInfo;

	// Oo͊Jn`bNJEg̎擾
	m_startTickCount = GetTickCount();

	return	TRUE;
}


// w蕶 printf() `ŃOt@CɂPso͂
// i{֐ŎIɊes̐擪sAŌ̉stB
//   LOG_SetLogLevel() Őݒ肵Oo̓x LogLevel ̎wlȏ̏ꍇ̂݁COo͂sȂBj
BOOL CLogFile::LOG_PRINTF(BYTE LogLevel, const char *Format, ... )
{
	va_list		pArg;
	BOOL		result;

	va_start(pArg, Format);
	result = LOG_VPRINTF(LogLevel, Format, pArg);
	va_end(pArg);

	return	result;
}

// w蕶 vprintf() `ŃOt@CɂPso͂
// ȋ LOG_PRINTF() ƓlBj
BOOL CLogFile::LOG_VPRINTF(BYTE LogLevel, const char *Format, va_list pArg)
{
	FILE		*logfp;
	DWORD		tickCount, curThreadId;
	char		logStr[32];		// Log es擪t񕶎pobt@
	SYSTEMTIME	localTime;

	// Oo̓x̃`FbN
	if (m_logLevel < LogLevel) {
		return	FALSE;
	}

	// Ot@CANZXZNVɓ
	SECTION_ACCESS_LOGFILE_START;

	// Oo͕̐擪Ɋet
	switch (m_addInfo) {
	case LOG_ADDINFO_NOINFO:
		sprintf(logStr, "");
		break;
	case LOG_ADDINFO_TIME_PAST:
		// Oo͊Jñ`bNJEg̎擾
		tickCount = GetTickCount() - m_startTickCount;
		sprintf(logStr, "[%05d.%03d]  ", tickCount / 1000, tickCount % 1000);
		break;
	case LOG_ADDINFO_TIME_NOW:
		GetLocalTime(&localTime);
		sprintf(logStr, "[%02d:%02d:%02d.%03d]  ",
				localTime.wHour, localTime.wMinute, localTime.wSecond, localTime.wMilliseconds);
		break;
	case LOG_ADDINFO_THREADID:
		// JgXbh ID ̎擾
		curThreadId = GetCurrentThreadId();
		sprintf(logStr, "[%04Xh]  ", (WORD)curThreadId);
		break;
	case (LOG_ADDINFO_TIME_PAST | LOG_ADDINFO_THREADID):
		tickCount = GetTickCount() - m_startTickCount;
		curThreadId = GetCurrentThreadId();
		sprintf(logStr, "[%05d.%03d][%04Xh]  ", tickCount / 1000, tickCount % 1000, (WORD)curThreadId);
		break;
	case (LOG_ADDINFO_TIME_NOW | LOG_ADDINFO_THREADID):
		GetLocalTime(&localTime);
		curThreadId = GetCurrentThreadId();
		sprintf(logStr, "[%02d:%02d:%02d.%03d][%04Xh]  ",
				localTime.wHour, localTime.wMinute, localTime.wSecond, localTime.wMilliseconds, (WORD)curThreadId);
		break;
	}

	// Ot@CJĕ݁C
	logfp = fopen(m_logFilePath, "a");
	if (!logfp) {
		// Ot@CANZXZNV甲
		SECTION_ACCESS_LOGFILE_END;
		return	FALSE;
	}
	if (m_addInfo != LOG_ADDINFO_NOINFO) {
		fwrite(logStr, strlen(logStr), 1, logfp);
	}
	vfprintf(logfp, Format, pArg);
	fwrite("\n", strlen("\n"), 1, logfp);
	fclose(logfp);

	// Ot@CANZXZNV甲
	SECTION_ACCESS_LOGFILE_END;

	return	TRUE;
}


#define	WRITE_DATA_LEN_1LINE	0x10
#define	WRITE_DATA_LEFT_SPACE	"\t\t\t\t\t"
#define	WRITE_DATA_HEADER		"       +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F\n"

// woCgzf[^Ot@CɃeLXg`iPs 16 oCg 16 ijŏo
// ipDataF oCgzf[^擪AhXASizeF oCgzoCgj
BOOL CLogFile::LOG_WRITE_DATA(BYTE LogLevel, LPBYTE pData, WORD Size)
{
	FILE	*logfp;
	char	str[256], tmpStr[256];
	int		i, j, line, rest;

	// Oo̓x̃`FbN
	if (m_logLevel < LogLevel) {
		return	FALSE;
	}

	// Ot@CANZXZNVɓ
	SECTION_ACCESS_LOGFILE_START;

	logfp = fopen(m_logFilePath, "a");
	if (!logfp) {
		// Ot@CANZXZNV甲
		SECTION_ACCESS_LOGFILE_END;
		return	FALSE;
	}

	// wb_Ot@Cɏ
	sprintf(str, WRITE_DATA_LEFT_SPACE WRITE_DATA_HEADER);
	fwrite(str, strlen(str), 1, logfp);

	line = (int)(Size / WRITE_DATA_LEN_1LINE);	// ݕf[^̍si[ȍŌ̈sj
	rest = (int)(Size % WRITE_DATA_LEN_1LINE);	// [ȍŌ̈s̃f[^

	// f[^Ot@Cɏ
	for (i = 0; i < line; i++) {
		sprintf(str, WRITE_DATA_LEFT_SPACE "%04X :", WRITE_DATA_LEN_1LINE * i);
		for (j = 0; j < WRITE_DATA_LEN_1LINE; j++) {
			sprintf(tmpStr, " %02X", pData[WRITE_DATA_LEN_1LINE * i + j]);
			strcat(str, tmpStr);
		}
		strcat(str, "\n");
		fwrite(str, strlen(str), 1, logfp);
	}
	// f[^[ȍŌ̈s̏
	if (rest != 0) {
		sprintf(str, WRITE_DATA_LEFT_SPACE "%04X :", WRITE_DATA_LEN_1LINE * i);
		for (j = 0; j < rest; j++) {
			sprintf(tmpStr, " %02X", pData[WRITE_DATA_LEN_1LINE * i + j]);
			strcat(str, tmpStr);
		}
		strcat(str, "\n");
		fwrite(str, strlen(str), 1, logfp);
	}

	fclose(logfp);

	// Ot@CANZXZNV甲
	SECTION_ACCESS_LOGFILE_END;

	return	TRUE;
}



///////////////////////////////////////////////////////////////////////////// 
//	CLogFile private methods


// Oo̓fBNgɎcĂ郍Ot@C̃obNAbv
// iLogFilePathFOo̓t@CtpXABackupDirNameFobNAbvfBNgABackupCountFőobNAbvj
void CLogFile::backupLogFile(LPCSTR LogFilePath, LPCSTR BackupDirName, WORD BackupCount)
{
	char			tempDirPath[MAX_PATH], bakDirPath[MAX_PATH], bakLogFilePath[MAX_PATH], oldestBakLogFilePath[MAX_PATH];
	WIN32_FIND_DATA	findData;
	HANDLE			hFind, hFile;
	int				extNum;
	FILETIME		fileTime, oldestFileTime;

	// JgfBNgɑÕOt@C݂邩`FbN
	hFind = FindFirstFile(LogFilePath, &findData);
	if (hFind != INVALID_HANDLE_VALUE) {
		FindClose(hFind);
		// Temp fBNgobNAbvfBNgpX̎擾
		GetTempPath(MAX_PATH, tempDirPath);
		sprintf(bakDirPath, "%s\\%s", tempDirPath, BackupDirName);
		if ((_access(bakDirPath, 0)) == -1) {
			// obNAbvfBNgȂȂ쐬
			if (!CreateDirectory(bakDirPath, NULL)) {
				return;
			}
		}
		oldestFileTime.dwHighDateTime = 0xFFFFFFFF;
		oldestFileTime.dwLowDateTime = 0xFFFFFFFF;
		// obNAbvfBNgŃobNAbv̌
		for (extNum = 1; extNum <= BackupCount; extNum++) {
			sprintf(bakLogFilePath, "%s\\%s_%03d.txt", bakDirPath, BackupDirName, extNum);
			hFind = FindFirstFile(bakLogFilePath, &findData);
			if (hFind == INVALID_HANDLE_VALUE) {
				// ÕOt@CobNAbvt@Cit@Cɐ {jɖOύXĕۑ
				MoveFile(LogFilePath, bakLogFilePath);
				break;
			} else {
				FindClose(hFind);
				// t@C̍ŏIݎԌÂt@CT
				hFile = CreateFile(bakLogFilePath, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
				GetFileTime(hFile, NULL, NULL, &fileTime);
				if (CompareFileTime(&fileTime, &oldestFileTime) == -1) {
					oldestFileTime = fileTime;
					strcpy(oldestBakLogFilePath, bakLogFilePath);
				}
				CloseHandle(hFile);
			}
		}
		if (extNum > BackupCount) {
			// obNAbvt@CtCԌÂobNAbvt@C
			DeleteFile(oldestBakLogFilePath);
			MoveFile(LogFilePath, oldestBakLogFilePath);
		}
	}

}


#define TOKEN_FILENAME		"OriginalFilename"
#define TOKEN_FILEDESC		"FileDescription"
#define TOKEN_FILEVERSION	"FileVersion"
#define TOKEN_PRIVATEBUILD	"PrivateBuild"

// W[(EXE/DLL) ̃t@CEo[W擾
BOOL CLogFile::getModuleVersionInfo(HMODULE hModule, LPSTR lpModuleName, LPSTR lpModuleDesc, LPSTR lpModuleVersion, LPSTR lpModulePrivateBuild)
{
	HRSRC	hResouce;
	char	*pVersionRc;
	DWORD	rsrcSize, strOffset = 0, memOffset = 0, i;
	char	versionBuff[1024];

	// w胂W[̃o[W\[X[h
	hResouce = FindResource(hModule, MAKEINTRESOURCE(VS_VERSION_INFO), RT_VERSION);
	if (!hResouce) {
		return	FALSE;
	}
	rsrcSize = SizeofResource(hModule, hResouce);
	pVersionRc = (char *)LoadResource(hModule, hResouce);
	if (!pVersionRc) {
		return	FALSE;
	}

	// o[W\[XiUnicode ̕Wobt@j ASCII Wobt@ɕϊ
	memOffset = 0;
	strOffset = 0;
	while (memOffset < rsrcSize) {
		versionBuff[strOffset] = pVersionRc[memOffset];
		memOffset += 2;
		strOffset += 1;
	}
	versionBuff[strOffset] = '\0';

	// 擾o[WWobt@ "OriginalFilename", "FileDescription", "FileVersion", "PrivateBuild" 擾
	for (i = 0; i < strOffset; i++) {
		if (strncmp(&versionBuff[i], TOKEN_FILEVERSION, strlen(TOKEN_FILEVERSION)) == 0) {
			memcpy(lpModuleVersion, &versionBuff[i + strlen(TOKEN_FILEVERSION) + 2], LOG_MODULEINFO_STR_LEN);
		}
		if (strncmp(&versionBuff[i], TOKEN_FILEDESC, strlen(TOKEN_FILEDESC)) == 0) {
			memcpy(lpModuleDesc, &versionBuff[i + strlen(TOKEN_FILEDESC) + 2], LOG_MODULEINFO_STR_LEN);
		}
		if (strncmp(&versionBuff[i], TOKEN_FILENAME, strlen(TOKEN_FILENAME)) == 0) {
			memcpy(lpModuleName, &versionBuff[i + strlen(TOKEN_FILENAME) + 1], LOG_MODULEINFO_STR_LEN);
		}
		if (strncmp(&versionBuff[i], TOKEN_PRIVATEBUILD, strlen(TOKEN_PRIVATEBUILD)) == 0) {
			memcpy(lpModulePrivateBuild, &versionBuff[i + strlen(TOKEN_PRIVATEBUILD) + 1], LOG_MODULEINFO_STR_LEN);
		}
	}

	return	TRUE;
}
