/********************************************************/
/*														*/
/*	File :	Log_W32c.h									*/
/*														*/
/*	Class to output log to file	(For Win32)				*/
/*														*/
/********************************************************/

#ifndef __LOGW32C_H__
#define __LOGW32C_H__


#include <windows.h>


//===========================================================================
//
//	CLogFile NX
//
//		fobOpOt@Co͏NX
//		iWindows vOŁj
//
//		Tv
//			vOCӂ̕fobOpOt@CieLXgt@Cj
//			ɏo͂i񋟂B
//
//		gp@
//			1. CLogFile NXCX^X\zB
//			2. NXɑ΂āCeo͏ݒsȂB
//				ݒ荀				gp֐				ftHgl
//				-----------------------+-----------------------+------------------------
//				LogFile				LOG_SetLogFileTitle()	"LogFile"
//				igqj
//				-----------------------+-----------------------+------------------------
//				LogFile obNAbv	LOG_SetBackupCount()	LOG_BACKUP_COUNT_DEFAULT
//				-----------------------+-----------------------+------------------------
//				ŏ̐		LOG_SetLogTopString()	󕶎
//				-----------------------+-----------------------+------------------------
//				\W[	LOG_SetModuleHandle()	ݒ
//				nh
//				-----------------------+-----------------------+------------------------
//				Oo̓x			LOG_SetLogLevel()		LOG_LEVEL_DEFAULT
//				-----------------------+-----------------------+------------------------
//				eOo͕̊es	LOG_SetAddInfo()		LOG_ADDINFO_NOINFO
//				擪ɕt
//				-----------------------+-----------------------+------------------------
//			3. LOG_Start() ŃOo͊Jniߋ̃Ot@CobNAbvEeój
//			   sȂBiK{j
//			4. LOG_PRINTF(), LOG_WRITE_DATA() ŁAOo͂ LogFile ɏ
//			   ށB
//			5. CLogFile NXCX^XjB
//
//		l
//			E SẴOóiLOG_PRINTF(), LOG_VPRINTF(), LOG_WRITE_DATA() ɂj
//			   P񂲂ƂɃOt@C OpenA݁AClose {B
//
//
//===========================================================================



///////////////////////////////////////////////////////////////////////////// 
//	e define


// ftHg Log t@C
#define	LOG_FILETITLE_DEFAULT		"LogFile"

// ftHg Log obNAbvt@C
#define	LOG_BACKUP_COUNT_DEFAULT	10

// ŏ̃t@C̍ő咷
#define	LOG_MAX_LEN_TOP_STRING		1024

// t@CEo[W擾郂W[(EXE/DLL) 
#define	LOG_MODULE_COUNT			3

// Log o̓x
#define	LOG_LEVEL_NO_LOG			0		// Oo͂Ȃ
#define	LOG_LEVEL_OPENING_PAGE		10		// Ot@C̍ŏ̃t@Cy[Wo
#define	LOG_LEVEL_DEFAULT			50		// ftHgl

// CLogFile::LOG_SetAddInfo() Ɏw肷tw
#define	LOG_ADDINFO_NOINFO			0x00	// Ȃ
#define	LOG_ADDINFO_TIME_PAST		0x01	// oߎ
#define	LOG_ADDINFO_TIME_NOW		0x02	// ݎ
#define	LOG_ADDINFO_THREADID		0x04	// XbhID



///////////////////////////////////////////////////////////////////////////// 
//	CLogFile Class

class CLogFile {

public:

	// RXgN^^fXgN^

	CLogFile(LPCSTR LogFileTitle);	// LogFileTitleF Oo̓t@CigqBgq ".txt" ŒBj
	virtual ~CLogFile();

	// eo͏ݒ֐

	// Oo̓t@Cݒ
	// iLogFileTitleF Oo̓t@CigqBgq ".txt" ŒBjj
	BOOL	LOG_SetLogFileTitle(LPCSTR LogFileTitle);

	// ߋ̃Ot@CobNAbvݒ
	// iobNAbvF Windows  Temp fBNg̃O̓t@C̃fBNg
	//		"Oo̓t@C_nnn.txt" (nnn = 0,1,2,...) ŕۑߋ̃Oo̓t@C̍ő吔̂ƁBj
	void	LOG_SetBackupCount(WORD BackupCount);

	// Ot@C擪ɏo͂ݒ
	// iLogTopStringF iLOG_MAX_LEN_TOP_STRING ȓjj
	BOOL	LOG_SetLogTopString(LPCSTR LogTopString);

	// Ot@C擪ɏo͂eW[io[Wj̑ΏۃW[̃nhݒ
	// iNULL ݒ̏ꍇACvZX̏óB
	//	 ő LOG_MODULE_COUNT ܂ŐݒłBj
	BOOL	LOG_SetModuleHandle(HMODULE hModule);

	// Oo̓xݒ
	// i"Oo̓x" Ƃ́Cw肳ꂽOt@Cɏނǂ̔fB
	//   {֐Őݒ肳ꂽl荂Oo̓xw肳ꂽ LOG_PRINTF(), LOG_WRITE_DATA() 
	//   Oo͍͂sȂȂBj
	void	LOG_SetLogLevel(BYTE LogLevel);

	// LOG_PRINTF(), LOG_WRITE_DATA() ł̃Oo͂̊es擪ɕtijݒ
	// iLOG_ADDINFO_TIME_PAST, LOG_ADDINFO_TIME_NOW, LOG_ADDINFO_THREADID wBior wjj
	BOOL	LOG_SetAddInfo(BYTE AddInfo);


	// Ot@C֐

	// Oo͊Jniߋ̃Ot@CobNAbvEeój{
	BOOL	LOG_Start(void);

	// w蕶 printf() `ŃOt@CɂPso͂
	// i{֐ŎIɊes̐擪sAŌ̉stB
	//   LOG_SetLogLevel() Őݒ肵Oo̓x LogLevel ̎wlȏ̏ꍇ̂݁COo͂sȂBj
	BOOL	LOG_PRINTF(BYTE LogLevel, const char *Format, ... );

	// w蕶 vprintf() `ŃOt@CɂPso͂
	// ȋ LOG_PRINTF() ƓlBj
	BOOL	LOG_VPRINTF(BYTE LogLevel, const char *Format, va_list pArg);

	// woCgzf[^Ot@CɃeLXg`iPs 16 oCg 16 ijŏo
	// ipDataF oCgzf[^擪AhXASizeF oCgzoCgj
	BOOL	LOG_WRITE_DATA(BYTE LogLevel, LPBYTE pData, WORD Size);


private:

	char		m_logFileTitle[MAX_PATH];
	WORD		m_backupCount;
	char		m_logTopString[LOG_MAX_LEN_TOP_STRING];
	HMODULE		m_hModule[LOG_MODULE_COUNT];
	BYTE		m_logLevel;
	BYTE		m_addInfo;
	char		m_logFilePath[MAX_PATH];
	char		m_backupDir[MAX_PATH];
	DWORD		m_startTickCount;

	CRITICAL_SECTION	m_openLogFileSection;

	void	backupLogFile(LPCSTR LogFilePath, LPCSTR BackupDirName, WORD BackupCount);
	BOOL	getModuleVersionInfo(HMODULE hModule, LPSTR lpModuleName, LPSTR lpModuleDesc, LPSTR lpModuleVersion, LPSTR lpModulePrivateBuild);

};


#endif // #ifndef __LOGW32C_H__
