/************************************************************/
/*															*/
/*	File :	OperateImg.h									*/
/*															*/
/*	Printer SDK Sample Program								*/
/*		Operate image library "OperateImg.lib" Ver.2.4.1	*/
/*		header file											*/
/*															*/
/*			Last Modified at 2006/08/30						*/
/*															*/
/*	Copyright (C) 2004-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#ifndef __OPERATEIMG_H__
#define __OPERATEIMG_H__


#ifdef __cplusplus
extern "C"{
#endif


//Indicate linker option /NODEFAULTLIB:"libc.lib"
#pragma comment(linker, "/nodefaultlib:libc.lib")

/********************************************************************************************/
/*																							*/
/*	Notes																					*/
/*																							*/
/*		1.	When the use of DIB got by OPERATEIMG_Rotate(), OPERATEIMG_Scale(),				*/
/*			OPERATEIMG_ScaleInternalRect(),	OPERATEIMG_ScaleExternalRect() is over,			*/
/*			free memory by calling GlobalFree() Windows API.								*/
/*																							*/
/*		2.	Program using this library has to be indicate "8 byte (default)" to				*/
/*			alignment of structure member.													*/
/*																							*/
/********************************************************************************************/


//	Error Codes
#define OPERATEIMG_OK						0x00000000
#define OPERATEIMG_ERR_MEMORY_ALLOC			0x21000004
#define OPERATEIMG_ERR_NO_SUPPORT_FORMAT	0x21000005
#define OPERATEIMG_ERR_PARAM				0x21000006
#define OPERATEIMG_ERR_NO_3DLUT_DATA		0x21000007	// 2005/02/23 Ver.2.0.0
#define OPERATEIMG_ERR_NO_1DLUT_DATA		0x21000008	// 2005/04/22 Ver.2.1.0


//-----------------------------------------------------------------------------
//	Function    : DWORD WINAPI OPERATEIMG_Rotate(HGLOBAL hSrcDib, HGLOBAL *phDstDib)
//
//	Description : This function rotates a image clockwise by 90 degrees.
//
//	Arguments   :
//		[in] HGLOBAL hSrcDib - Memory Handle of Original Image
//		[in] HGLOBAL *phDstDib - Memory Handle of Roteted Image
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2004/10/20	Mochida Takeshi
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_Rotate(HGLOBAL hSrcDib, HGLOBAL *phDstDib);

//-----------------------------------------------------------------------------
//	Function    : DWORD WINAPI OPERATEIMG_Scale(HGLOBAL hSrcDib, int DstSizeX, int DstSizeY, HGLOBAL *phDstDib)
//
//	Description : This function scales a image to the specified width and height.
//
//	Arguments   :
//		[in] HGLOBAL hSrcDib - Memory Handle of Original Image
//		[in] int DstSizeX - Specified image width
//		[in] int DstSizeY - Specified image height
//		[in] HGLOBAL *phDstDib - Memory Handle of Scaled Image
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2004/10/20	Mochida Takeshi
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_Scale(HGLOBAL hSrcDib, int DstSizeX, int DstSizeY, HGLOBAL *phDstDib);


//-----------------------------------------------------------------------------
//	Function    : DWORD WINAPI OPERATEIMG_ScaleExternalRect(HGLOBAL hSrcDib, int RectSizeX, int RectSizeY, HGLOBAL *phDstDib, int *pDstImgSizeX, int *pDstImgSizeY)
//
//	Description : This function scales a image to fill in the specified rectangle-size in 
//				  equal scale ratio. If the scaled image-size is larger than rectangle-size, 
//				  the image is set center alignment and trimmed.
//
//	Arguments   :
//		[in] HGLOBAL hSrcDib - Memory Handle of Original Image
//		[in] int RectSizeX - Specified rectangle width
//		[in] int RectSizeY - Specified rectangle height
//		[in] HGLOBAL *phDstDib - Memory Handle of Scaled Image
//		[in] int *pDstImgSizeX - Scaled and trimmed image width
//		[in] int *pDstImgSizeY - Scaled and trimmed image height
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2004/10/20	Mochida Takeshi
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_ScaleExternalRect(HGLOBAL hSrcDib, int RectSizeX, int RectSizeY,
                                HGLOBAL *phDstDib, int *pDstImgSizeX, int *pDstImgSizeY);


//-----------------------------------------------------------------------------
//	Function    : DWORD WINAPI OPERATEIMG_ScaleInternalRect(HGLOBAL hSrcDib, int RectSizeX, int RectSizeY, HGLOBAL *phDstDib, int *pDstImgSizeX, int *pDstImgSizeY)
//
//	Description : This function scales a image to fall within the specified rectangle-size in
//				  equal scale ratio. If the scaled image-size is smaller than rectangle-size,
//				  the image has white spaces.
//
//	Arguments   :
//		[in] HGLOBAL hSrcDib - Memory Handle of Original Image
//		[in] int RectSizeX - Specified rectangle width
//		[in] int RectSizeY - Specified rectangle height
//		[in] HGLOBAL *phDstDib - Memory Handle of Scaled Image
//		[in] int *pDstImgSizeX - Scaled image width
//		[in] int *pDstImgSizeY - Scaled image height
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2004/10/20	Mochida Takeshi
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_ScaleInternalRect(HGLOBAL hSrcDib, int RectSizeX, int RectSizeY,
                                HGLOBAL *phDstDib, int *pDstImgSizeX, int *pDstImgSizeY);


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_dib2rgb()
//
//	Description : Make RGB raw data from DIB.
//
//	Arguments   :
//		[in] HGLOBAL hDib - Memory Handle of Original Image DIB 
//
//	Return Value: PBYTE - RGB BYTE memory array pointer. (new allocated in method.)
//                        If error occurred, return NULL.
//	                      After using image data, free memory by delete [].
//
//	Created Date: 2005/02/23	fujiwara
//-----------------------------------------------------------------------------
PBYTE WINAPI OPERATEIMG_dib2rgb(HGLOBAL hDib);	// 2005/02/23 Ver.2.0.0


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_rgb2dib()
//
//	Description : Make DIB data from RGB raw data, and copy memory.
//
//	Arguments   :
//		[in] HGLOBAL hDib - Memory handle of image DIB data. (Prepared BITMAPINFO data.)
//		[in] PBYTE pRgb - RGB raw data memory.
//		[in] int ImgSizeX - Image width. [Pixel]
//		[in] int ImgSizeY - Image height. [Pixel])
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2005/02/23	fujiwara
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_rgb2dib(HGLOBAL hDib, PBYTE pRgb, int ImgSizeX, int ImgSizeY);	// 2005/02/23 Ver.2.0.0


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_Init_Lut()
//
//	Description : Call before start to use OPERATEIMG_LutConversionForPrinter()
//	              in application.
//
//	Arguments   : void
//
//	Return Value: void
//
//	Created Date: 2005/02/23	fujiwara
//-----------------------------------------------------------------------------
void WINAPI OPERATEIMG_Init_Lut();		// 2005/02/23 Ver.2.0.0


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_LutConversionForPrinter()
//
//	Description : Make DIB data from RGB raw data, and copy memory.
//
//	Arguments   :
//		[in] HGLOBAL hDib - Memory Handle of Original Image DIB 
//		[in] PCSTR strDataFileName - File name of 3D LUT parameter data.
//		                             (File name only (Not full-path.))
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2005/02/23	fujiwara
//  Changed Data: 2005/10/26	nakashima
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_LutConversionForPrinter(HGLOBAL hDib, PCSTR strDataFile);	// 2005/02/23 Ver.2.0.0
//DWORD WINAPI OPERATEIMG_LutConversionForPrinter(HGLOBAL hDib, PCSTR strDataFileName);	// 2005/02/23 Ver.2.0.0

//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_LutConversionForPrinter_P()
//
//	Description : Make DIB data from RGB raw data, and copy memory.
//
//	Arguments   :
//		[in] LPVOID lpDib		- Memory Pointer of Original Image DIB 
//		[in] PCSTR strDataFile	- File name or path of 3D LUT parameter data.
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2005/10/26	nakashima
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_LutConversionForPrinter_P(LPVOID lpDib, PCSTR strDataFile);	// 2005/10/26 Ver.2.4.0


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_Finish_Lut()
//
//	Description : Call after finish to use OPERATEIMG_LutConversionForPrinter()
//	              in application.
//
//	Arguments   : void
//
//	Return Value: void
//
//	Created Date: 2005/02/23	fujiwara
//-----------------------------------------------------------------------------
void WINAPI OPERATEIMG_Finish_Lut();		// 2005/02/23 Ver.2.0.0


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_Init_1DLut()
//
//	Description : Call before start to use OPERATEIMG_1DLutConversion()
//	              in application.
//
//	Arguments   : void
//
//	Return Value: void
//
//	Created Date: 2005/04/22	Mochida
//-----------------------------------------------------------------------------
void WINAPI OPERATEIMG_Init_1DLut();		// 2005/04/22 Ver.2.1.0


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_1DLutConversion()
//
//	Description : Do 1D LUT Processing.
//
//	Arguments   :
//		[in] HGLOBAL hDib - Memory Handle of Original Image DIB 
//		[in] PCSTR strDataFilePath - File path of 1D LUT parameter data.
//		                             (full-path (Not only file name.)
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2005/04/22	Mochida
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_1DLutConversion(HGLOBAL hDib, PCSTR strDataFilePath);	// 2005/04/22 Ver.2.1.0


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_Finish_1DLut()
//
//	Description : Call after finish to use OPERATEIMG_1DLutConversion()
//	              in application.
//
//	Arguments   : void
//
//	Return Value: void
//
//	Created Date: 2005/04/22	Mochida
//-----------------------------------------------------------------------------
void WINAPI OPERATEIMG_Finish_1DLut();		// 2005/04/22 Ver.2.1.0

//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_Generate_1DLutData(LPBYTE lpb1Ddata, int iDdata, int iCData, int iMdata, int iYData)
//
//	Description : Generate 1d data to use DCMY parameter.
//
//	Arguments   :
//		[in] BYTE lpb1Ddata - Memory to hold 1d data.
//		[in] int iDdata - D parameter.
//		[in] int iCData - C parameter.
//		[in] int iMdata - M parameter.
//		[in] int iYData - Y parameter.
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2005/04/25	Mochida Takeshi
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_Generate_1DLutData(LPBYTE lpb1Ddata, int iDdata, int iCdata, int iMdata, int iYdata);// 2005/04/22 Ver.2.1.0

//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_Generate_1DLutDataWithGammaCurve(LPBYTE lpb1Ddata, int iDdata, int iCData, int iMdata, int iYData)
//
//	Description : Generate 1d data to use DCMY parameter.
//
//	Arguments   :
//		[in] BYTE lpb1Ddata - Memory to hold 1d data.
//		[in] int iDdata - D parameter.
//		[in] int iCData - C parameter.
//		[in] int iMdata - M parameter.
//		[in] int iYData - Y parameter.
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2006/08/30	Teruyoshi Nakashima
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_Generate_1DLutDataWithGammaCurve(LPBYTE lpb1Ddata, int iDdata, int iCdata, int iMdata, int iYdata);// 2006/08/30 Ver.2.4.1


//-----------------------------------------------------------------------------
//	Function    : OPERATEIMG_Create_1DLutFile(LPBYTE lpb1Ddata, const char *szDataFileName)
//
//	Description : Create 1d data File.
//
//	Arguments   :
//		[in] BYTE lpb1Ddata - Memory to hold 1d data.
//		[in] char *szDataFileName - 1d data file name.(Full path)
//
//	Return Value: DWORD - Error Code. If there is no error, it returns OPERATEIMG_OK.
//
//	Created Date: 2005/04/25	Mochida Takeshi
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_Create_1DLutFile(LPBYTE lpb1Ddata, const char *szDataFileName);// 2005/04/22 Ver.2.1.0


//-----------------------------------------------------------------------------
//	Function    : Set1DParameter(BOOL fSetup, int iMinRange, int iMaxRange, double dDstep, double dCMYstep)
//
//	Description : 
//
//	Arguments   :
//		[in] BOOL fSetup - Flag to use input param or default param.
//		[in] int iMinRange - Minimum range of arguments that Generate_1DLutData() have. 
//		[in] int iMaxRange - Maximum range of arguments that Generate_1DLutData() have.
//		[in] double dDstep - D Key step of calculation in Generate_1DLutData().
//		[in] double dCMYstep - CMY Key step of calculation in Generate_1DLutData().
//
//	Return Value: int - Error code. If there is no error, This returns EC_SUCCESS.
//
//	Created Date: 2005/04/28	Mochida Takeshi
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_Set1DParameter(BOOL fSetup, int iMinRange, int iMaxRange, double dDstep, double dCMYstep);

//-----------------------------------------------------------------------------
//	Function    : Set1DParameterWithGammaCurve(BOOL fSetup, int iBrightnessRange)
//
//	Description : 
//
//	Arguments   :
//		[in] BOOL fSetup - Flag to use input param or default param.
//		[in] int iBrightnessRange - Brightness range of arguments that Generate_1DLutDataWithGammaCurve() have. 
//
//	Return Value: int - Error code. If there is no error, This returns EC_SUCCESS.
//
//	Created Date: 2006/08/30	Teruyoshi Nakashima
//-----------------------------------------------------------------------------
DWORD WINAPI OPERATEIMG_Set1DParameterForGammaCurve(BOOL fSetup, int iBrightnessRange);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef __OPERATEIMG_H__	*/