/************************************************************/
/*															*/
/*	File :	SDKSample.cpp									*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#include "stdafx.h"
#include "SDKSample.h"
#include "LoadImg.h"
#include "EnumDlg.h"

#include "Debug.h"// 2005/12/07 Ver.1.7.1

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Image Setup object
CSetupImgDll	g_setupImgDll;// 2005.5.27 mochida


/////////////////////////////////////////////////////////////////////////////
// CSDKSampleApp

BEGIN_MESSAGE_MAP(CSDKSampleApp, CWinApp)
	//{{AFX_MSG_MAP(CSDKSampleApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSDKSampleApp Class constructor

CSDKSampleApp::CSDKSampleApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSDKSampleApp object

CSDKSampleApp theApp;


/////////////////////////////////////////////////////////////////////////////
// CSDKSampleApp Class initialize and exit.


// Initialize application.
BOOL CSDKSampleApp::InitInstance()
{
	CString		errStr;

	// Initialize printer SDK
	if (!m_setup.Init()) {
		return	FALSE;
	}

	// Initialize "Load image library"
	LOADIMG_Init();

	// Initialize "Setup image library(FFISPL.dll)"
	if(!g_setupImgDll.LoadDLL()){// 2005/12/16 Ver.2.0.0
		// Failed to load.
		errStr.LoadString(IDS_ERR_LOAD_IMG_SETUP_DLL);
		AfxMessageBox(errStr, MB_OK | MB_ICONSTOP);
		return	FALSE;		
	}

	// Initialize Log 2005/12/07 Ver.1.7.1
	DEBUG_StartLog(NULL);


	CEnumDlg		enumDlg;

	// Set pointer to CSetup object.
	enumDlg.SetPrinterSetup(&m_setup);

	// Display "Printer search & select" dialog.
	enumDlg.DoModal();


#ifdef _AFXDLL
	Enable3dControls();
#else
	Enable3dControlsStatic();
#endif

	LoadStdProfileSettings();

//	return TRUE;
	return FALSE;	// 2004/12/07 Ver.0.8.0
}


// Exit application.
int CSDKSampleApp::ExitInstance()
{
	// Finish Log 2005/12/07 Ver.1.7.1
	DEBUG_EndLog();

	// Finish use "Setup image library(PPImgSet.dll)"
	g_setupImgDll.UnloadDLL();

	// Finish use "Load image library"
	LOADIMG_Finish();

	// Finish printer SDK
	m_setup.Finish();

	return	0;
}


/////////////////////////////////////////////////////////////////////////////
// CSDKSampleApp command
