/************************************************************/
/*															*/
/*	File :	Setup.cpp										*/
/*															*/
/*	Printer SDK Sample Program								*/
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#include "stdafx.h"
#include "Setup.h"
#include "sdksetup.h"
#include "ErrDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


///////////////////////////////////////////////////////////////////////////////
//
//	CSetup class public method
//


// Constructor / Destructor
CSetup::CSetup()
{

	m_fSdkDllLoad	= FALSE;
	m_fSdkInit		= FALSE;
	m_printerCnt	= NULL;
	m_pPrinterInfos	= NULL;

}

CSetup::~CSetup()
{

}


// Initialize printer SDK. (Load DLL etc.)
// (Return value : TRUE OK, FALSE error)
BOOL CSetup::Init()
{
	DWORD	ret;

	// Load printer SDK DLL.
	if (!loadNCSDK()) {
		// Failed to load.
		ErrMessage(IDS_ERR_LOAD_SDKDLL, NULL, 0);
		return	FALSE;
	}
	m_fSdkDllLoad = TRUE;

	// Initialize SDK.
	ret = fnSDK.Init();
	if (ret != MCP_OK) {
		ErrMessage(_T("MCP_Init()"), NULL, ret);
		return	FALSE;
	}
	m_fSdkInit = TRUE;

	return	TRUE;
}


// Finish using printer SDK. (Unload DLL etc.)
// (Return value : TRUE OK, FALSE error)
BOOL CSetup::Finish()
{
	DWORD	ret;

	// Free memory for printer device information.
	if (m_pPrinterInfos != NULL) {
		delete [] m_pPrinterInfos;
		m_pPrinterInfos = NULL;
	}

	if (m_fSdkDllLoad == TRUE) {
		// Finish using SDK.
		if (m_fSdkInit) {
			ret = fnSDK.Finish();
			if (ret != MCP_OK) {
				ErrMessage(_T("MCP_Finish()"), NULL, ret);
			}
		}
		// Unload SDK DLL.
		unloadNCSDK();
	}

	return	TRUE;
}


// Enumerate controllable printers, and get device information of each printer.
// (pPrinterNum : [IN] Max enumerate printers count. [OUT] Enumerated printers count.
//  pPrinterInfos : [OUT] Information array of found printers.)
// (Return value : TRUE OK, FALSE error)
BOOL CSetup::Enum(PUINT pPrinterNum, PMCP_PRINTER_INFO *pPrinterInfos)
{
	DWORD					ret;
	UINT					printerNum = 0, i;

	CWaitCursor				wait;

	// If memory for printer device information allocated at before CSetup::Enum(), free.
	if (m_pPrinterInfos != NULL) {
		delete [] m_pPrinterInfos;
		m_pPrinterInfos = NULL;
	}

	// Search printers.
	printerNum = MAX_PRINTER_CNT;
	ret = fnSDK.EnumPrinter(&printerNum, m_hPrinter);
	if (ret != MCP_OK) {
		ErrMessage(_T("MCP_EnumPrinter()"), NULL, ret);
		return	FALSE;
	}
	if (printerNum == 0) {
		// Printer not found.
		ErrMessage(IDS_ERR_NO_PRINTER, NULL, 0);
		return	FALSE;
	}

	// Allocate memory for printer device information.
	m_pPrinterInfos = new MCP_PRINTER_INFO[printerNum];
	if (m_pPrinterInfos == NULL) {
		ErrMessage(IDS_ERR_NO_ALLOC_PRINTERINFO, NULL, 0);
		return	FALSE;
	}

	// Get device information of each printer.
	for (i = 0; i < printerNum; i++) {
		ret = fnSDK.GetPrinterInfo(m_hPrinter[i], &m_pPrinterInfos[i]);
		if (ret != MCP_OK) {
			ErrMessage(_T("MCP_GetPrinterInfo()"), m_hPrinter[i], ret);
			delete [] m_pPrinterInfos;
			m_pPrinterInfos = NULL;
			return	FALSE;
		}
	}

	*pPrinterNum	= printerNum;
	*pPrinterInfos	= m_pPrinterInfos;
	m_printerCnt	= printerNum;

	return	TRUE;
}


// Get each handle of printer that found at CSetup::Enum().
// (Index : Printer to get handle index at enumerated CSetup::Enum().)
// (Return value : Printer handle.)
HANDLE CSetup::GetPrinterHandle(int Index)
{

	return	m_hPrinter[Index];
}



///////////////////////////////////////////////////////////////////////////////
//
//	CSetup class private method
//


// Display error message. (Indicate string or resource ID of StringTable)
// (Str      : Error message string.
//  StrID    : Error message string ID in StringTable.
//  hPrinter : Printer handle. (If not indicate printer, set NULL.)
//  ErrCode  : SDK functions return code.
//             (If not SDK function error, set 0.)
void CSetup::ErrMessage(LPCTSTR Str, HANDLE hPrinter, DWORD ErrCode)
{
	CString		errStr, str;
	DWORD		lastErr;
	UINT		i, printerNo = UNKNOWN_PRINTER_NO;

	if (hPrinter != NULL) {
		// Get index of printer.
		for (i = 0; i < m_printerCnt; i++) {
			if (hPrinter == m_hPrinter[i]) {
				printerNo = m_pPrinterInfos[i].nUsbNo;
				break;
			}
		}
		str.Format(_T("\n\tPrinter No. = %02d"), printerNo);
	}

	if (ErrCode != 0) {
		// Get SDK last error.
		lastErr = fnSDK.GetLastError(hPrinter);
		// Display SDK error dialog.
		CErrDlg errDlg;
		errDlg.SetErrorInfo(Str, printerNo + 1, ErrCode, lastErr);
		errDlg.DoModal();
	} else {
		// Only display MessageBox.
		errStr =  Str + str;
		AfxMessageBox(errStr, MB_OK | MB_ICONSTOP);
	}

}

void CSetup::ErrMessage(UINT StrID, HANDLE hPrinter, DWORD ErrCode)
{
	CString		str;

	str.LoadString(StrID);

	CSetup::ErrMessage(str, hPrinter, ErrCode);

}
