/************************************************************/
/*                                                          */
/*  File :  SetupImgDll.cpp                                 */
/*                                                          */
/*  DPB-1500 series Wrapper SDK Sample Program              */
/*                                                          */
/*  Copyright (C) 2001-2005 Fuji Photo Film Co., Ltd.       */
/*                                                          */
/************************************************************/

#include "stdafx.h"
#include "SetupImgDll.h"

#include "Debug.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define	PADDED_LENGTH(OriginalLen, Boundary)	(((OriginalLen + Boundary - 1) / Boundary) * Boundary)


HMODULE	CSetupImgDll::m_hDll = NULL;
BOOL	CSetupImgDll::m_fLoad = FALSE;

typedef int (*PISPL_Init)(void);
typedef int (*PISPL_Finish)(void);
typedef int (*PISPL_SetDefaultParam)(PISPL_MANUAL_PARAM);
typedef int (*PISPL_ImgSetupWithRedEye)(BOOL, BOOL, ISPL_IMAGE_INFO, ISPL_MANUAL_PARAM, PISPL_REDEYE_RESULT, ISPL_PROFILE_INFO);
typedef int (*PISPL_ManualSetup)(ISPL_IMAGE_INFO, ISPL_MANUAL_PARAM, ISPL_PROFILE_INFO);
typedef int (*PISPL_RedEye)(ISPL_IMAGE_INFO, PISPL_REDEYE_RESULT);
typedef int (*PISPL_PrinterProfile)(ISPL_IMAGE_INFO, ISPL_PROFILE_INFO);

static PISPL_Init				fpISPL_Init;
static PISPL_Finish				fpISPL_Finish;
static PISPL_SetDefaultParam	fpISPL_SetDefaultParam;
static PISPL_ImgSetupWithRedEye fpISPL_ImgSetupWithRedEye;
static PISPL_ManualSetup		fpISPL_ManualSetup;
static PISPL_RedEye				fpISPL_RedEye;
static PISPL_PrinterProfile		fpISPL_PrinterProfile;


CSetupImgDll::CSetupImgDll()
{
	ZeroMemory(&m_RedEyeResult, sizeof(m_RedEyeResult));
}

CSetupImgDll::~CSetupImgDll()
{

}


BOOL CSetupImgDll::LoadDLL()
{
	BOOL	bRet = TRUE;

	if (m_hDll == NULL) {
		m_hDll = LoadLibrary(IMGDLL_NAME);
	}
	if (m_hDll == NULL) {
		bRet = FALSE;
		goto Exit;
	}

	// Get address of image setup DLL export functions
	fpISPL_Init               = (PISPL_Init)GetProcAddress(m_hDll, "ISPL_Init");
	fpISPL_Finish             = (PISPL_Finish)GetProcAddress(m_hDll, "ISPL_Finish");
	fpISPL_SetDefaultParam    = (PISPL_SetDefaultParam)GetProcAddress(m_hDll, "ISPL_SetDefaultParam");
	fpISPL_ImgSetupWithRedEye = (PISPL_ImgSetupWithRedEye)GetProcAddress(m_hDll, "ISPL_ImgSetupWithRedEye");
	fpISPL_ManualSetup	      = (PISPL_ManualSetup)GetProcAddress(m_hDll, "ISPL_ManualSetup");
	fpISPL_RedEye             = (PISPL_RedEye)GetProcAddress(m_hDll, "ISPL_RedEye");
	fpISPL_PrinterProfile     = (PISPL_PrinterProfile)GetProcAddress(m_hDll, "ISPL_PrinterProfile");

	if( fpISPL_Init==NULL ||
		fpISPL_Finish==NULL || 
		fpISPL_SetDefaultParam==NULL || 
		fpISPL_ImgSetupWithRedEye==NULL || 
		fpISPL_ManualSetup==NULL || 
		fpISPL_RedEye==NULL || 
		fpISPL_PrinterProfile==NULL ){
		bRet = FALSE;
	}

Exit:
	m_fLoad = bRet;
	return bRet;
}

void CSetupImgDll::UnloadDLL()
{
	if (m_hDll) {
		FreeLibrary(m_hDll);
		m_hDll = NULL;
	}	
}

///////////////////////////////////////////////////////////////////
//
int CSetupImgDll::Init()
{
	int	iRet;
//	DWORD	dwTime;	// For Log

//	DEBUG_LOG_PRINTF_SET(dwTime, "Init()");
	iRet = fpISPL_Init();
//	DEBUG_LOG_PRINTF_TIME(dwTime, "Init() return %d", iRet );
	return iRet;
}

int CSetupImgDll::Finish()
{
	int	iRet;
//	DWORD	dwTime;	// For Log

//	DEBUG_LOG_PRINTF_SET(dwTime, "Finish()");
	iRet = fpISPL_Finish();
//	DEBUG_LOG_PRINTF_TIME(dwTime, "Finish() return %d", iRet );
	return iRet;
}


int CSetupImgDll::SetDefaultParam(PISPL_MANUAL_PARAM pManualParam)
{
	int	iRet;
//	DWORD	dwTime;	// For Log

//	DEBUG_LOG_PRINTF_SET(dwTime, "SetDefaultParam()");
	iRet = fpISPL_SetDefaultParam(pManualParam);
//	DEBUG_LOG_PRINTF_TIME(dwTime, "SetDefaultParam() return %d", iRet );
	return iRet;
}

int CSetupImgDll::ImgSetupWithRedEye(BOOL fAutoSetup, BOOL fRedEye, ISPL_IMAGE_INFO ImageInfo, ISPL_MANUAL_PARAM ManualParam, PISPL_REDEYE_RESULT pRedEyeResult, ISPL_PROFILE_INFO ProfileInfo)
{
	int	iRet;
//	DWORD	dwTime;	// For Log

//	DEBUG_LOG_PRINTF_SET(dwTime, "ImgSetupWithRedEye()");
	iRet = fpISPL_ImgSetupWithRedEye(fAutoSetup, fRedEye, ImageInfo, ManualParam, pRedEyeResult, ProfileInfo);

/*
	DEBUG_LOG_PRINTF("\t\t<AutoSetup : %s>", _ON_OFF(fAutoSetup));
	DEBUG_LOG_PRINTF("\t\t<RedEye    : %s>", _ON_OFF(fRedEye));

	// Parameter list
	DEBUG_LOG_PRINTF("\t\t<Manual Param>");
	DEBUG_LOG_PRINTF("\t\t ColorC: %d", ManualParam.sColorC);
	DEBUG_LOG_PRINTF("\t\t ColorM: %d", ManualParam.sColorM);
	DEBUG_LOG_PRINTF("\t\t ColorY: %d", ManualParam.sColorY);
	DEBUG_LOG_PRINTF("\t\t Brightness  : %d", ManualParam.sBrightness);
	DEBUG_LOG_PRINTF("\t\t Contrast    : %d", ManualParam.sContrast);
	DEBUG_LOG_PRINTF("\t\t MonotoneMode: %s", _MONOTONE( ManualParam.nMonotoneMode ));

	DEBUG_LOG_PRINTF("\t\t<Image Info>");
	DEBUG_LOG_PRINTF("\t\t Setup Type: %s", _DSC_SCN(ImageInfo.nSetupType));
	DEBUG_LOG_PRINTF("\t\t FilePath  : %s", ImageInfo.pImgFilePath);

	DEBUG_LOG_PRINTF("\t\t<Profile Info>");
	DEBUG_LOG_PRINTF("\t\t ScannerProfile: %s", ProfileInfo.pScannerProfile);
	DEBUG_LOG_PRINTF("\t\t PrinterProfile: %s", ProfileInfo.pPrinterProfile);

	DEBUG_LOG_PRINTF_TIME(dwTime, "ImgSetupWithRedEye() return %d", iRet );
*/
  return iRet;
}

int CSetupImgDll::ManualSetup(ISPL_IMAGE_INFO ImageInfo, ISPL_MANUAL_PARAM ManualParam, ISPL_PROFILE_INFO ProfileInfo)
{
	int	iRet;
//	DWORD	dwTime;	// For Log

//	DEBUG_LOG_PRINTF_SET(dwTime, "ManualSetup()");
	iRet = fpISPL_ManualSetup(ImageInfo, ManualParam, ProfileInfo);
/*
	// Parameter list
	DEBUG_LOG_PRINTF("\t\t<Manual Param>");
	DEBUG_LOG_PRINTF("\t\t ColorC: %d", ManualParam.sColorC);
	DEBUG_LOG_PRINTF("\t\t ColorM: %d", ManualParam.sColorM);
	DEBUG_LOG_PRINTF("\t\t ColorY: %d", ManualParam.sColorY);
	DEBUG_LOG_PRINTF("\t\t Brightness  : %d", ManualParam.sBrightness);
	DEBUG_LOG_PRINTF("\t\t Contrast    : %d", ManualParam.sContrast);
	DEBUG_LOG_PRINTF("\t\t MonotoneMode: %s", _MONOTONE(ManualParam.nMonotoneMode) );

	DEBUG_LOG_PRINTF_TIME(dwTime, "ManualSetup() return %d", iRet );
*/
	return iRet;
}

int CSetupImgDll::RedEye(ISPL_IMAGE_INFO ImageInfo, PISPL_REDEYE_RESULT RedEyeResult)
{
	int	iRet;
//	DWORD	dwTime;	// For Log

//	DEBUG_LOG_PRINTF_SET(dwTime, "RedEye()");
	iRet = fpISPL_RedEye(ImageInfo, RedEyeResult);
//	DEBUG_LOG_PRINTF_TIME(dwTime, "RedEye() return %d", iRet );
	return iRet;
}

int CSetupImgDll::PrinterProfile(ISPL_IMAGE_INFO ImageInfo, ISPL_PROFILE_INFO ProfileInfo)
{
	int	iRet;
//	DWORD	dwTime;	// For Log

//	DEBUG_LOG_PRINTF_SET(dwTime, "PrinterProfile()");
	iRet = fpISPL_PrinterProfile(ImageInfo, ProfileInfo);
/*
	DEBUG_LOG_PRINTF("\t\t<Image Info>");
	DEBUG_LOG_PRINTF("\t\t Setup Type: %s", _DSC_SCN(ImageInfo.nSetupType));
	DEBUG_LOG_PRINTF("\t\t FilePath  : %s", ImageInfo.pImgFilePath);

	DEBUG_LOG_PRINTF("\t\t<Profile Info>");
	DEBUG_LOG_PRINTF("\t\t ScannerProfile: %s", ProfileInfo.pScannerProfile);
	DEBUG_LOG_PRINTF("\t\t PrinterProfile: %s", ProfileInfo.pPrinterProfile);

	DEBUG_LOG_PRINTF_TIME(dwTime, "PrinterProfile() return %d", iRet );
*/
	return iRet;
}

int CSetupImgDll::DoAutoSetup(BOOL fAuto, BOOL fRedEye, HANDLE hCvtDIB, HANDLE hOrgDIB, TCHAR* szFilePath, ISPL_MANUAL_PARAM ManualParam, int iSetupType, TCHAR* szInputProfile, TCHAR* szOutputProfile)
{
	int	iRet = ISPL_NOERR;
	LPBYTE				pCvtDIB;
	LPBYTE				pOrgDIB;
	ISPL_IMAGE_INFO		ImageInfo;
	ISPL_PROFILE_INFO	ProfileInfo;
	ISPL_MANUAL_PARAM	defaultManualParam;
	ISPL_REDEYE_RESULT*	pRedEyeResult = NULL;

	// Confirm whether DLL is loaded or not.
	if(m_fLoad==FALSE){
		iRet = ISPL_ERR_LOAD_DLL;
		goto Exit;
	}

	// Set structure of MANUAL_PARAM
	iRet = SetDefaultParam(&defaultManualParam);
	if(iRet!=ISPL_NOERR){
		goto Exit;
	}
	defaultManualParam.sColorC = ManualParam.sColorC;
	defaultManualParam.sColorM = ManualParam.sColorM;
	defaultManualParam.sColorY = ManualParam.sColorY;
	defaultManualParam.sBrightness = ManualParam.sBrightness;
	defaultManualParam.sContrast = ManualParam.sContrast;
	defaultManualParam.nMonotoneMode = ManualParam.nMonotoneMode;
	ManualParam = defaultManualParam;

	// Set structure of IMAGE_INFO
	pCvtDIB = (LPBYTE)GlobalLock(hCvtDIB);
	if( pCvtDIB == NULL ){
		iRet = ISPL_ERR_MEM_NEW;
		goto Exit;
	}
	pOrgDIB = (LPBYTE)GlobalLock(hOrgDIB);
	if( pOrgDIB == NULL ){
		iRet = ISPL_ERR_MEM_NEW;
		goto Exit;
	}
	ImageInfo.lpConvertImg = pCvtDIB;
	ImageInfo.lpOriginalImg = pOrgDIB;
	ImageInfo.nSetupType = iSetupType;
	ImageInfo.pImgFilePath = szFilePath;

	// Set structure of PROFILE_INFO
	if( !_tcscmp(szInputProfile, _T("")) ){
		ProfileInfo.pScannerProfile = NULL;
	}else{
		ProfileInfo.pScannerProfile = szInputProfile;
	}
	if( !_tcscmp(szOutputProfile, _T("")) ){
		ProfileInfo.pPrinterProfile = NULL;
	}else{
		ProfileInfo.pPrinterProfile = szOutputProfile;
	}

	// Set structure of REDEYE_RESULT
	if(fRedEye){
		pRedEyeResult = &m_RedEyeResult;
	}

	// Image Setup
	iRet = ImgSetupWithRedEye(fAuto, fRedEye, ImageInfo, ManualParam, pRedEyeResult, ProfileInfo);
	if(iRet!=ISPL_NOERR){
		goto Exit;
	}

Exit:
	if (hCvtDIB != NULL) {
		GlobalUnlock(hCvtDIB);
	}
	if (hOrgDIB != NULL) {
		GlobalUnlock(hOrgDIB);
	}
	return iRet;
}

int CSetupImgDll::Do3DLut(HANDLE hCvtDIB, TCHAR* szOutputProfile)
{
	int	iRet = ISPL_NOERR;
	LPBYTE				pCvtDIB;
	ISPL_IMAGE_INFO		ImageInfo;
	ISPL_PROFILE_INFO	ProfileInfo;

	// Confirm whether DLL is loaded or not.
	if(m_fLoad==FALSE){
		iRet = ISPL_ERR_LOAD_DLL;
		goto Exit;
	}

	// Set structure of IMAGE_INFO
	pCvtDIB = (LPBYTE)GlobalLock(hCvtDIB);
	if( pCvtDIB == NULL ){
		iRet = ISPL_ERR_MEM_NEW;
		goto Exit;
	}
	ImageInfo.lpConvertImg = pCvtDIB;
	ImageInfo.lpOriginalImg = NULL;
	ImageInfo.nSetupType = ISPL_SETUP_TYPE_DSC;
	ImageInfo.pImgFilePath = NULL;

	// Set structure of PROFILE_INFO
	ProfileInfo.pScannerProfile = NULL;
	ProfileInfo.pPrinterProfile = NULL;
	if ( _tcscmp( szOutputProfile, _T("") ) != 0 ) {
		ProfileInfo.pPrinterProfile = szOutputProfile;
	}else{
		iRet = ISPL_ERR_NOT_FOUND_FILE;
		goto Exit;
	}
	iRet = PrinterProfile(ImageInfo, ProfileInfo);

Exit:
	if (hCvtDIB != NULL) {
		GlobalUnlock(hCvtDIB);
	}
	return iRet;
}

int CSetupImgDll::DoAutoSetup(HANDLE hCvtDIB, HANDLE hOrgDIB, TCHAR* szFilePath, BOOL fRedEye)
{
	int	iRet = ISPL_NOERR;
	LPBYTE				pOrgDIB, pCvtDIB;
	ISPL_IMAGE_INFO		ImageInfo;
	ISPL_MANUAL_PARAM	ManualParam;
	ISPL_PROFILE_INFO	ProfileInfo;
	ISPL_REDEYE_RESULT*	pRedEyeResult = NULL;

	// Confirm whether DLL is loaded or not.
	if(m_fLoad==FALSE){
		iRet = ISPL_ERR_LOAD_DLL;
		goto Exit;
	}

	// Set structure of MANUAL_PARAM
	iRet = SetDefaultParam(&ManualParam);
	if(iRet!=ISPL_NOERR){
		goto Exit;
	}

	// Set structure of IMAGE_INFO
	pCvtDIB = (LPBYTE)GlobalLock(hCvtDIB);
	if( pCvtDIB == NULL ){
		iRet = ISPL_ERR_MEM_NEW;
		goto Exit;
	}
	pOrgDIB = (LPBYTE)GlobalLock(hOrgDIB);
	if( pOrgDIB == NULL ){
		iRet = ISPL_ERR_MEM_NEW;
		goto Exit;
	}
	ImageInfo.lpConvertImg = pCvtDIB;
	ImageInfo.lpOriginalImg = pOrgDIB;
	ImageInfo.nSetupType = ISPL_SETUP_TYPE_DSC;
	ImageInfo.pImgFilePath = szFilePath;

	// Set structure of PROFILE_INFO
	ProfileInfo.pScannerProfile = NULL;
	ProfileInfo.pPrinterProfile = NULL;

	// Set structure of REDEYE_RESULT
	if(fRedEye){
		pRedEyeResult = &m_RedEyeResult;
	}


	iRet = ImgSetupWithRedEye(TRUE, fRedEye, ImageInfo, ManualParam, pRedEyeResult, ProfileInfo);
	if(iRet!=ISPL_NOERR){
		goto Exit;
	}

Exit:
	if (hCvtDIB != NULL) {
		GlobalUnlock(hCvtDIB);
	}
	if (hOrgDIB != NULL) {
		GlobalUnlock(hOrgDIB);
	}
	return iRet;
}

int CSetupImgDll::DoManualSetup(HANDLE hDIB, TCHAR* szFilePath, ISPL_MANUAL_PARAM ManualParam)
{
	int	iRet = ISPL_NOERR;
	LPBYTE				pDIB;
	ISPL_IMAGE_INFO		ImageInfo;
	ISPL_PROFILE_INFO	ProfileInfo;
	ISPL_REDEYE_RESULT*	pRedEyeResult = NULL;

	// Confirm whether DLL is loaded or not.
	if(m_fLoad==FALSE){
		iRet = ISPL_ERR_LOAD_DLL;
		goto Exit;
	}

	// Set structure of IMAGE_INFO
	pDIB = (LPBYTE)GlobalLock(hDIB);
	if( pDIB == NULL ){
		iRet = ISPL_ERR_MEM_NEW;
		goto Exit;
	}
	ImageInfo.lpConvertImg = pDIB;
	ImageInfo.lpOriginalImg = pDIB;
	ImageInfo.nSetupType = ISPL_SETUP_TYPE_DSC;
	ImageInfo.pImgFilePath = szFilePath;

	// Set structure of PROFILE_INFO
	ProfileInfo.pScannerProfile = NULL;
	ProfileInfo.pPrinterProfile = NULL;

	iRet = ManualSetup(ImageInfo, ManualParam, ProfileInfo);
	if(iRet!=ISPL_NOERR){
		goto Exit;
	}

Exit:
	if (hDIB != NULL) {
		GlobalUnlock(hDIB);
	}
	return iRet;
}

int CSetupImgDll::DoRedEye(HANDLE hDIB, TCHAR* szFilePath, BOOL fMark)
{
	int	iRet = ISPL_NOERR;
	LPBYTE				pDIB;
	ISPL_IMAGE_INFO		ImageInfo;
	ISPL_REDEYE_RESULT*	pRedEyeResult = NULL;

	// Confirm whether DLL is loaded or not.
	if(m_fLoad==FALSE){
		iRet = ISPL_ERR_LOAD_DLL;
		goto Exit;
	}

	// Set structure of IMAGE_INFO
	pDIB = (LPBYTE)GlobalLock(hDIB);
	if( pDIB == NULL ){
		iRet = ISPL_ERR_MEM_NEW;
		goto Exit;
	}

	ImageInfo.lpConvertImg = pDIB;
	ImageInfo.lpOriginalImg = pDIB;
	ImageInfo.nSetupType = ISPL_SETUP_TYPE_DSC;
	ImageInfo.pImgFilePath = szFilePath;

	// RedEye Remove
	pRedEyeResult = &m_RedEyeResult;

	iRet = RedEye(ImageInfo, pRedEyeResult);

	if(fMark){// Draw RedEye Remove marker
		if (hDIB != NULL) {
			GlobalUnlock(hDIB);
		}
		DrawRedEyeResult(hDIB, m_RedEyeResult);
	}	

Exit:
	if (hDIB != NULL) {
		GlobalUnlock(hDIB);
	}
	return iRet;
}


BOOL CSetupImgDll::GetRedEyeAreaData(int index, ISPL_REDEYE_RESULT RedEyeResult, CRect& Rect, CPoint& Point)
{
	ISPL_REDEYE_AREA RedEyeArea;
	ZeroMemory(&RedEyeArea, sizeof(RedEyeArea));

	if(index >= RedEyeResult.nFaceNum * 2){
		return FALSE;
	}
	memcpy(&RedEyeArea, (LPBYTE)RedEyeResult.pRedEyeFaceData + sizeof(ISPL_REDEYE_AREA) * index, sizeof(ISPL_REDEYE_AREA) );
	
	Point.x = RedEyeArea.lnPointX;
	Point.y = RedEyeArea.lnPointY;

	Rect.left = RedEyeArea.lnRectX;
	Rect.top = RedEyeArea.lnRectY;
	Rect.right = RedEyeArea.ulRectW + RedEyeArea.lnRectX - 1;
	Rect.bottom = RedEyeArea.ulRectH + RedEyeArea.lnRectY - 1;

	return TRUE;
}

BOOL CSetupImgDll::DrawRedEyeResult(HANDLE hDIB, ISPL_REDEYE_RESULT RedEyeResult)
{
	BOOL bRet = TRUE;

	unsigned char RGB[3] = {255, 0, 0};

	int i, num;
	int xs, ys, xe, ye;
	int width_trim, height_trim;
	int offsetV1, offsetV2, offsetV3, offsetV4, offsetV5, offsetV6;
	int offsetH1, offsetH2, offsetH3, offsetH4, offsetH5, offsetH6;
	int width, height, widthByte;

	int rectNum = RedEyeResult.nFaceNum * 2;

	CRect rect;
	CPoint point;

	// Get Image size & Image Buffer Address
	LPBITMAPINFOHEADER	pBmpInfoHeader;
	LPBYTE				pDIB;

	pBmpInfoHeader = (LPBITMAPINFOHEADER)GlobalLock(hDIB);
	if(pBmpInfoHeader==NULL){
		bRet = FALSE;
		goto	Exit;
	}
	pDIB = (LPBYTE)pBmpInfoHeader + sizeof(BITMAPINFOHEADER);
	width = pBmpInfoHeader->biWidth;
	height = pBmpInfoHeader->biHeight;
	
	widthByte = (((width * 24) + 31 ) & ~31) >>3;

	for(num=0; num<rectNum; num++){

		// Get Rectangle Infomation & Peak point
		if(!GetRedEyeAreaData(num, RedEyeResult, rect, point)){
			break;
		}

		if( point.x!=0 || point.y!=0 ){
	
			////////////////////////////////////////////////////////////
			// Draw frame
			xs = rect.left;
			ys = rect.top;
			xe = rect.right;
			ye = rect.bottom;
			if ( xs > width )  xs = width -1;
			if ( xe > width )  xe = width -1;
			if ( ys > height ) ys = height -1;
			if ( ye > height ) ye = height -1;
			if ( xs < 0) xs = 0;
			if ( ys < 0) ys = 0;
			if ( xe < 0) xe = 0;
			if ( ye < 0) ye = 0;

			width_trim  = xe - xs +1;
			height_trim = ye - ys +1;

			offsetV1 = widthByte*(height-1-ys);
			offsetV2 = widthByte*(height-1-(ys+height_trim-1));

			offsetH1 = 3*xs;
			offsetH2 = 3*(xs+width_trim-1);

			offsetV3 = widthByte*(height-1-ys +1);
			offsetV4 = widthByte*(height-1-(ys+height_trim-1) +1);

			offsetH3 = 3*(xs +1);
			offsetH4 = 3*(xs+width_trim-1 +1);

			offsetV5 = widthByte*(height-1-ys -1);
			offsetV6 = widthByte*(height-1-(ys+height_trim-1) -1);

			offsetH5 = 3*(xs -1);
			offsetH6 = 3*(xs+width_trim-1 -1);

			for(i=0; i<width_trim; i++){			
				pDIB[3*(xs+i)    + offsetV1] = RGB[2];
				pDIB[3*(xs+i) +1 + offsetV1] = RGB[1];
				pDIB[3*(xs+i) +2 + offsetV1] = RGB[0];

				pDIB[3*(xs+i)    + offsetV2] = RGB[2];
				pDIB[3*(xs+i) +1 + offsetV2] = RGB[1];
				pDIB[3*(xs+i) +2 + offsetV2] = RGB[0];		

				pDIB[3*(xs+i)    + offsetV3] = RGB[2];
				pDIB[3*(xs+i) +1 + offsetV3] = RGB[1];
				pDIB[3*(xs+i) +2 + offsetV3] = RGB[0];

				pDIB[3*(xs+i)    + offsetV4] = RGB[2];
				pDIB[3*(xs+i) +1 + offsetV4] = RGB[1];
				pDIB[3*(xs+i) +2 + offsetV4] = RGB[0];		

				pDIB[3*(xs+i)    + offsetV5] = RGB[2];
				pDIB[3*(xs+i) +1 + offsetV5] = RGB[1];
				pDIB[3*(xs+i) +2 + offsetV5] = RGB[0];

				pDIB[3*(xs+i)    + offsetV6] = RGB[2];
				pDIB[3*(xs+i) +1 + offsetV6] = RGB[1];
				pDIB[3*(xs+i) +2 + offsetV6] = RGB[0];		
			}

			for(i=0; i<height_trim; i++){	
				pDIB[offsetH1    + widthByte*(height-1-(ys+i))] = RGB[2];
				pDIB[offsetH1 +1 + widthByte*(height-1-(ys+i))] = RGB[1];
				pDIB[offsetH1 +2 + widthByte*(height-1-(ys+i))] = RGB[0];

				pDIB[offsetH2    + widthByte*(height-1-(ys+i))] = RGB[2];
				pDIB[offsetH2 +1 + widthByte*(height-1-(ys+i))] = RGB[1];
				pDIB[offsetH2 +2 + widthByte*(height-1-(ys+i))] = RGB[0];	

				pDIB[offsetH3    + widthByte*(height-1-(ys+i))] = RGB[2];
				pDIB[offsetH3 +1 + widthByte*(height-1-(ys+i))] = RGB[1];
				pDIB[offsetH3 +2 + widthByte*(height-1-(ys+i))] = RGB[0];

				pDIB[offsetH4    + widthByte*(height-1-(ys+i))] = RGB[2];
				pDIB[offsetH4 +1 + widthByte*(height-1-(ys+i))] = RGB[1];
				pDIB[offsetH4 +2 + widthByte*(height-1-(ys+i))] = RGB[0];

				pDIB[offsetH5    + widthByte*(height-1-(ys+i))] = RGB[2];
				pDIB[offsetH5 +1 + widthByte*(height-1-(ys+i))] = RGB[1];
				pDIB[offsetH5 +2 + widthByte*(height-1-(ys+i))] = RGB[0];

				pDIB[offsetH6    + widthByte*(height-1-(ys+i))] = RGB[2];
				pDIB[offsetH6 +1 + widthByte*(height-1-(ys+i))] = RGB[1];
				pDIB[offsetH6 +2 + widthByte*(height-1-(ys+i))] = RGB[0];
			}

			////////////////////////////////////////////////////////////
			// Draw Peak point with cross
			for(i=point.x-10; i<point.x+10; i++){
				pDIB[3*(i)    + widthByte*(height-1-point.y)] = RGB[2];
				pDIB[3*(i) +1 + widthByte*(height-1-point.y)] = RGB[1];
				pDIB[3*(i) +2 + widthByte*(height-1-point.y)] = RGB[0];
			}
			for(i=point.y-10; i<point.y+10; i++){
				pDIB[3*(point.x)    + widthByte*(height-1-i)] = RGB[2];
				pDIB[3*(point.x) +1 + widthByte*(height-1-i)] = RGB[1];
				pDIB[3*(point.x) +2 + widthByte*(height-1-i)] = RGB[0];
			}
		}
	}

Exit:
	return bRet;
}
