/************************************************************/
/*															*/
/*	File :	SetupImgDll.h									*/
/*															*/
/*	DPB-1500 series Wrapper SDK Sample Program		        */
/*															*/
/*	Copyright (C) 2001-2006 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/

#ifndef __SETUP_IMGDLL_H__
#define __SETUP_IMGDLL_H__

#include "FFISPL.h"

#define	IMGDLL_NAME	_T("FFISPL.dll")

typedef struct{
	BOOL	fRedEye;
	BOOL	fMarker;
	BOOL	fAuto;
//	BOOL	fManual;
//	BOOL	fSplitProfile;
	int		iColorC;
	int		iColorM;
	int		iColorY;
	int		iBright;
	int		iContrast;
	int		iMonotone;
	int		iSetupType;
	TCHAR   wszInputProfile[MAX_PATH];
	TCHAR   wszOutputProfile[MAX_PATH];
}ISPL_INFO;

#define	MONOTONE_OFF	0
#define	MONOTONE_BW		1
#define	MONOTONE_SEPIA	2

#define	TYPE_DSC	0
#define	TYPE_SCN	1

#define	DEFAULT_PRINTER_PROFILE_1500 _T("DP3D1500.dat")
#define	DEFAULT_PRINTER_PROFILE_2000 _T("DP3D2000.dat")
#define	DEFAULT_PRINTER_PROFILE_4000 _T("DP3D4000.dat")
#define	DEFAULT_PRINTER_PROFILE_4000A _T("DP3D4000A.dat")	// nakashima addition 2007/06/29 Ver.2.5.0
#define	HQ_PRINTER_PROFILE_2000 _T("DP3D2000HQ.dat")		// nakashima addition 2007/10/11 Ver.2.6.2
#define DEFAULT_PRINTER_PROFILE_2500 _T("DP3D2500.dat")		// takanaka addition 2008/10/09 Ver.2.6.8
#define HQ_PRINTER_PROFILE_2500 _T("DP3D2500HQ.dat")		// takanaka addition 2009/04/09 Ver.2.7.0

class CSetupImgDll  
{
public:
	CSetupImgDll();
	virtual ~CSetupImgDll();

	BOOL LoadDLL();
	void UnloadDLL();

	int Finish();
	int Init();

	ISPL_REDEYE_RESULT GetRedEyeResult(){ return m_RedEyeResult; }

	int DoAutoSetup(HANDLE hCvtDIB, HANDLE hOrgDIB, TCHAR* szFilePath, BOOL fRedEye);
	int	DoAutoSetup(BOOL fAuto, BOOL fRedEye, HANDLE hCvtDIB, HANDLE hOrgDIB, TCHAR* szFilePath, ISPL_MANUAL_PARAM ManualParam, int iSetupType, TCHAR* szInputProfile, TCHAR* szOutputProfile);
	int DoManualSetup(HANDLE hDIB, TCHAR* szFilePath, ISPL_MANUAL_PARAM ManualParam);
	int DoRedEye(HANDLE hDIB, TCHAR* szFilePath, BOOL fMark);
	int Do3DLut(HANDLE hCvtDIB, TCHAR* szOutputProfile);

	int GetRedEyeResultNum(){ return m_RedEyeResult.nFaceNum; }
	BOOL GetRedEyeAreaData(int index, ISPL_REDEYE_RESULT RedEyeResult, CRect& Rect, CPoint& Point);
	BOOL DrawRedEyeResult(HANDLE hDIB, ISPL_REDEYE_RESULT RedEyeResult);


private:
	int ImgSetupWithRedEye(BOOL fAutoSetup, BOOL fRedEye, ISPL_IMAGE_INFO ImageInfo, ISPL_MANUAL_PARAM ManualParam, PISPL_REDEYE_RESULT pRedEyeResult, ISPL_PROFILE_INFO ProfileInfo);
	int ManualSetup(ISPL_IMAGE_INFO ImageInfo, ISPL_MANUAL_PARAM ManualParam, ISPL_PROFILE_INFO ProfileInfo);
	int RedEye(ISPL_IMAGE_INFO ImageInfo, PISPL_REDEYE_RESULT RedEyeResult);
	int SetDefaultParam(PISPL_MANUAL_PARAM pManualParam);
	int PrinterProfile(ISPL_IMAGE_INFO ImageInfo, ISPL_PROFILE_INFO ProfileInfo);

	static BOOL		m_fLoad;
	static HMODULE	m_hDll;

	ISPL_REDEYE_RESULT	m_RedEyeResult;
};

#endif /* __SETUP_IMGDLL_H__ */