/************************************************************/
/*															*/
/*	File :	sdksetup.c										*/
/*															*/
/*	ASK-1500 series Wrapper SDK Sample Program		        */
/*															*/
/*	Copyright (C) 2001-2005 Fuji Photo Film Co., Ltd.		*/
/*															*/
/************************************************************/


#include <Windows.h>
#include "sdksetup.h"


/*	SDK import functions table		*/
SDK_FUNC		fnSDK;

/*	SDK DLL handle	*/
static HMODULE	hSdkDll = NULL;


/************************************************************************/
/*																		*/
/*	loadNCSDK															*/
/*																		*/
/************************************************************************/
BOOL loadNCSDK(void)
{
	if (hSdkDll == NULL) {
		hSdkDll = LoadLibrary(SDK_DLL_NAME);
	} else {
		return	TRUE;
	}
	if (hSdkDll == NULL) {
		return	FALSE;
	}

	/*	Get address of SDK DLL export functions		*/
	fnSDK.Init						= (PMCP_Init)						GetProcAddress(hSdkDll, "MCP_Init");
	fnSDK.Finish					= (PMCP_Finish)						GetProcAddress(hSdkDll, "MCP_Finish");
	fnSDK.EnumPrinter				= (PMCP_EnumPrinter)				GetProcAddress(hSdkDll, "MCP_EnumPrinter");
	fnSDK.OpenPrinter				= (PMCP_OpenPrinter)				GetProcAddress(hSdkDll, "MCP_OpenPrinter");
	fnSDK.ClosePrinter				= (PMCP_ClosePrinter)				GetProcAddress(hSdkDll, "MCP_ClosePrinter");
	fnSDK.GetPrinterInfo			= (PMCP_GetPrinterInfo)				GetProcAddress(hSdkDll, "MCP_GetPrinterInfo");
	fnSDK.InitPrintSetting			= (PMCP_InitPrintSetting)			GetProcAddress(hSdkDll, "MCP_InitPrintSetting");
	fnSDK.SendPrintSetting			= (PMCP_SendPrintSetting)			GetProcAddress(hSdkDll, "MCP_SendPrintSetting");
	fnSDK.InitPrinterMemory			= (PMCP_InitPrinterMemory)			GetProcAddress(hSdkDll, "MCP_InitPrinterMemory");
	fnSDK.SendImageAndPrint			= (PMCP_SendImageAndPrint)			GetProcAddress(hSdkDll, "MCP_SendImageAndPrint");
	fnSDK.ReceivePrintedInfo		= (PMCP_ReceivePrintedInfo)			GetProcAddress(hSdkDll, "MCP_ReceivePrintedInfo");
	fnSDK.ReceiveVerInfo			= (PMCP_ReceiveVerInfo)				GetProcAddress(hSdkDll, "MCP_ReceiveVerInfo");
	fnSDK.GetPrinterStatus			= (PMCP_GetPrinterStatus)			GetProcAddress(hSdkDll, "MCP_GetPrinterStatus");
	fnSDK.GetPaperRemain			= (PMCP_GetPaperRemain)				GetProcAddress(hSdkDll, "MCP_GetPaperRemain");
	fnSDK.GetLastError				= (PMCP_GetLastError)				GetProcAddress(hSdkDll, "MCP_GetLastError");
	fnSDK.CancelPrint				= (PMCP_CancelPrint)				GetProcAddress(hSdkDll, "MCP_CancelPrint");
	fnSDK.LutConversionForPrinter	= (PMCP_LutConversionForPrinter)	GetProcAddress(hSdkDll, "MCP_LutConversionForPrinter");
	fnSDK.Generate1dData			= (PMCP_Generate1dData)				GetProcAddress(hSdkDll, "MCP_Generate1dData");   /* 2005/06/24 Ver.1.4.0 */
	fnSDK.Create1dDataFile			= (PMCP_Create1dDataFile)			GetProcAddress(hSdkDll, "MCP_Create1dDataFile"); /* 2005/06/24 Ver.1.4.0 */
	fnSDK.Delete1dDataFile			= (PMCP_Delete1dDataFile)			GetProcAddress(hSdkDll, "MCP_Delete1dDataFile"); /* 2005/06/24 Ver.1.4.0 */
	fnSDK.Search1dDataFile			= (PMCP_Search1dDataFile)			GetProcAddress(hSdkDll, "MCP_Search1dDataFile"); /* 2005/06/24 Ver.1.4.0 */
	fnSDK.Do1dLut					= (PMCP_Do1dLut)					GetProcAddress(hSdkDll, "MCP_Do1dLut");          /* 2005/06/24 Ver.1.4.0 */
	fnSDK.Exec1dConversion			= (PMCP_Exec1dConversion)			GetProcAddress(hSdkDll, "MCP_Exec1dConversion"); /* 2005/06/24 Ver.1.4.0 */
	fnSDK.SendImageAndMultiPrint	= (PMCP_SendImageAndMultiPrint)		GetProcAddress(hSdkDll, "MCP_SendImageAndMultiPrint");/* 2005/07/04 Ver.1.4.1 */
	fnSDK.SetUsbNo	                = (PMCP_SetUsbNo)		            GetProcAddress(hSdkDll, "MCP_SetUsbNo");              /* 2005/12/08 Ver.1.8.0 */
	fnSDK.SetAutoRecoveryFlag    	= (PMCP_SetAutoRecoveryFlag)		GetProcAddress(hSdkDll, "MCP_SetAutoRecoveryFlag");   /* 2005/12/08 Ver.1.8.0 */
	fnSDK.StopPrint              	= (PMCP_StopPrint)	               	GetProcAddress(hSdkDll, "MCP_StopPrint");             /* 2005/12/08 Ver.1.8.0 */
	fnSDK.GetPrinterError         	= (PMCP_GetPrinterError)	        GetProcAddress(hSdkDll, "MCP_GetPrinterError");       /* 2006/03/13 Ver.2.2.0 */
// Ver.2.4.0
	fnSDK.Generate1dDataWithGammaCurve	= (PMCP_Generate1dDataWithGammaCurve)	GetProcAddress(hSdkDll, "MCP_Generate1dDataWithGammaCurve");   /* 2006/08/14 Ver.2.4.0 */
#ifndef RET_VER247	// nakashima addition 2007/06/29 Ver.2.5.0
	fnSDK.SendImageAndThreeDivPrint	= (PMCP_SendImageAndThreeDivPrint)	GetProcAddress(hSdkDll, "MCP_SendImageAndThreeDivPrint");
#endif

#ifndef RET_VERSION_250		// nakashima addition 2007/08/09 Ver.2.6.0
	fnSDK.Make1dDataLinear			= (PMCP_Make1dDataLinear)			GetProcAddress(hSdkDll, "MCP_Make1dDataLinear");
	fnSDK.Make1dDataGammaCurve		= (PMCP_Make1dDataGammaCurve)		GetProcAddress(hSdkDll, "MCP_Make1dDataGammaCurve");
#endif

#ifndef RET_VERSION_265		// nakashima addition 2008/02/10 Ver.2.6.6
	fnSDK.ReceiveHeadPrintedInfo	= (PMCP_ReceiveHeadPrintedInfo)		GetProcAddress(hSdkDll, "MCP_ReceiveHeadPrintedInfo");
#endif

	return	TRUE;
}


/************************************************************************/
/*																		*/
/*	unloadNCSDK															*/
/*																		*/
/************************************************************************/
void unloadNCSDK(void)
{
	if (hSdkDll) {
		FreeLibrary(hSdkDll);
		hSdkDll = NULL;
		ZeroMemory(&fnSDK, sizeof(fnSDK));
	}
}
